//+------------------------------------------------------------------+
//|                                                    ExampleEA.mq5 |
//|                                Copyright 2023, Dragan Drenjanin. |
//|                                        drenjanindragan@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, Dragan Drenjanin."
#property link      "drenjanindragan@gmail.com"
#property version   "1.00"
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
#include <Trade\PositionInfo.mqh>
#include <Trade\Trade.mqh>
#include <Trade\SymbolInfo.mqh>
#include <Trade\AccountInfo.mqh>
#include <Trade\DealInfo.mqh>
#include <Trade\OrderInfo.mqh>
#include <Expert\Money\MoneyFixedMargin.mqh>
//---
#resource "\\Indicators\\AdaptiveATRChannelMT5Indicator.ex5"
#resource "\\Indicators\\ColorRsiMACD.ex5"
//---
CPositionInfo     m_position;                   // object of CPositionInfo class
CTrade            m_trade;                      // object of CTrade class
CSymbolInfo       m_symbol;                     // object of CSymbolInfo class
CAccountInfo      m_account;                    // object of CAccountInfo class
CDealInfo         m_deal;                       // object of CDealInfo class
COrderInfo        m_order;                      // object of COrderInfo class
CMoneyFixedMargin *m_money;                     // object of CMoneyFixedMargin class
//+----------------------------------------------+
//|  Algorithms                                 |
//+----------------------------------------------+
#include <TradeAlgorithms.mqh>
//+----------------------------------------------+
//|  Description of the class CXMA               |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh>
//+----------------------------------------------+
//|  Adding views                                |
//+----------------------------------------------+
enum AlgMode
  {
   breakdown,  //breakdowns zeros
   MACDtwist,  //Changing the MACD Direction
   SIGNALtwist,//Changing the direction of the signal line
   MACDdisposition //Sample Linear MACD Signal Line
  };
//+----------------------------------------------+
//| dding views                                  |
//+----------------------------------------------+
enum Applied_price_ //Type of Constant
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4)
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+------------------------------------------------------------------+
//| Enum Lor or Risk                                                 |
//+------------------------------------------------------------------+
enum ENUM_LOT_OR_RISK
  {
   lots_min = 0, // Lots Min
   lot = 1,      // Constant lot
   risk = 2,     // Risk in percent for a deal (range: from 1.00 to 100.00)
  };
//+------------------------------------------------------------------+
//| Enum Pips Or Points                                              |
//+------------------------------------------------------------------+
enum ENUM_InpPipsOrPointsS
  {
   pips = 0,      // Pips (1.00045-1.00055=1 pips)
   points = 1,    // Points (1.00045-1.00055=10 points)
  };
//+------------------------------------------------------------------+
//| Enum Trade Mode                                                  |
//+------------------------------------------------------------------+
enum ENUM_InpTradeMode
  {
   buy = 0,       // Only BUY positions
   sell = 1,      // Only SELL positions
   buy_sell = 2,  // BUY and SELL positions
  };
//+------------------------------------------------------------------+
//| Input parameters                                                 |
//+------------------------------------------------------------------+
sinput string                InpExpertAdvisorName                = "Kral";          
input group             "___ Working Settings ___"
input ENUM_InpPipsOrPointsS  InpPipsOrPoints                     = pips;              // Pips or Points
input ENUM_TIMEFRAMES        InpWorkingPeriod                    = PERIOD_CURRENT;    // Working timeframe
input ENUM_InpTradeMode      InpTradeMode                        = buy_sell;          // Choose trade mode
input group                 "___ Spread Control ___"
input bool                   ActivateMaxSpread                   = false;             // Activate
input double                 InpMaxSpread                        = 1;                 // Maximum spread
input group                 "___ Money Management ___"
input ENUM_LOT_OR_RISK       InpLotOrRisk                        = risk;              // Money Management: Lot or Risk
input double                 InpVolumeLotOrRisk                  = 8.0;               // The value for "Money management"
input group               "___ Exit Rules ___"
input uint                   InpStopLoss                         = 41;                // Stop Loss
input uint                   InpTakeProfit                       = 52;                // Take Profit
input group             "___ Trailing Rules ___"
input bool                 input_activate_trailing_stop         = true;               // Activate
input uint                   InpTrailingStop                     = 6;                 // Trailing Stop
input uint                   InpTrailingStep                     = 10;                // Trailing Step
input group             "___ Break-Even Rules ___"
input bool                 input_activate_be_stop               = false;              // Activate
input ushort                 InpBreakEvenStop                    = 8;                 // Breakeven stop
input ushort                 InpBreakEvenStep                    = 0;                 // Breakeven step
input group                "___ Auxiliary ___"
input bool                   InpRevers                           = false;             // Positions: Reverse
input bool                   input_only_one                      = true;              // Positions: Only one
input bool                   InpCloseOposit                      = false;             // Positions: Close opposite
input uchar                  InpFreezeLevel                      = 1;                 // Coefficient (if Freeze==0 Or StopsLevels==0)
input ulong                  InpDeviation                        = 0;                 // Deviation/Slippage
input ulong                  InpMagic                            = 15;                // Magic number
input string                 MyComment                           = "Kral Pro";        // Your comment here --->>>
input bool                   InpPrintLogo                        = false;             // Print log
input group             "Time control(24 hours scale)"
input bool     input_time_control       = false;                                 // Use time control
input uchar    input_start_hour         = 11;                                    // Start Hour
input uchar    input_start_minute       = 0;                                     // Start Minute
input uchar    input_end_hour           = 13;                                    // End Hour
input uchar    input_end_minute         = 0;                                     // End Minute
input bool     input_use_monday         = true;                                      // Monday
input bool     input_use_tuesday        = false;                                     // Tuesday
input bool     input_use_wednesday      = false;                                     // Wednesday
input bool     input_use_thursday       = false;                                     // Thursday
input bool     input_use_friday         = false;                                     // Friday
sinput string              noname1                               = " ";               // ========================
sinput string              noname2                               = " ";               // Group - Signals
sinput string              noname3                               = " ";               // ========================
input group             "___ Adaptive ATR Channel ___"
input ENUM_TIMEFRAMES        InpAATRTimeFrame                    = PERIOD_H1;         // AATR: Timeframe
input int                    InpAATRChannelMAPeriod              = 5;                 // AATR: Period
input ENUM_APPLIED_PRICE     InpAATRAppliedPrice                 = PRICE_WEIGHTED;    // AATR: Price
input double                 InpAATRMultiplier                   = 5.2;               // AATR: Multiplier
input group             "___ Color RsiMACD ___"
input ENUM_TIMEFRAMES      InpRsiMACDTimeFrame                   = PERIOD_H4;    // RsiMACD: Timeframe
input AlgMode              Mode             = breakdown;                         // RsiMACD: algo mode
input uint                 RSIPeriod        = 11;                                // RsiMACD: rsi period
input ENUM_APPLIED_PRICE   RSIPrice         = PRICE_LOW;                         // RsiMACD: rsi price type
input Smooth_Method        XMA_Method       = MODE_SMA_;                         // RsiMACD: method of liquidation of the histogram
input uint                 Fast_XMA         = 31;                                // RsiMACD: fast xma
input uint                 Slow_XMA         = 31;                                // RsiMACD: slow xma
input int                  XPhase           =1;                                  // RsiMACD: xfase
//for JJMA, the change in the range -100 ... +100, affects the quality of the current flow;
// For VIDIA this is CMO, for AMA this is slow speed
input Smooth_Method        Signal_Method    = MODE_VIDYA;                        // RsiMACD: signal line method
input int                  Signal_XMA       = 41;                                // RsiMACD: signal line period
input int                  Signal_Phase     = 31;                                // RsiMACD: paramether signal line
//change in limits -100 ... +100,
//determines the quality of the forward process;
input Applied_price_       AppliedPrice     = PRICE_HIGH_;                       // RsiMACD: tipe of the price
input uint                 SignalBar        =1;                                  // RsiMACD: number of bara for receiving the input signal
sinput string              noname4                               = " ";               // ========================
//+------------------------------------------------------------------+
//| Global Variable                                                  |
//+------------------------------------------------------------------+
//---
double   Ex_stop_loss                = 0.0;      // Stop Loss                  -> double
double   Ex_take_profit              = 0.0;      // Take Profit                -> double
double   Ex_trailing_stop            = 0.0;      // Trailing Stop              -> double
double   Ex_m_trailing_step          = 0.0;      // Trailing Step              -> double
double   Ex_m_breakeven_stop         = 0.0;      // Breakeven Stop             -> double
double   Ex_m_breakeven_step         = 0.0;      // Breakeven Step             -> double
double   Ex_m_max_spread             = 0.0;      // Maximum spread -> double

double  Ex_InpMyMaxLoss =0.0;
double  Ex_InpMyMinProfit=0.0;
//---
int      handle_iCustom;                        // variable for storing the handle of the iCustom indicator
int      handle2_iCustom;
//---
double   m_adjusted_point;                       // point value adjusted for 3 or 5 points
datetime m_last_trailing            = 0;         // "0" -> D'1970.01.01 00:00';
datetime m_last_signal              = 0;         // "0" -> D'1970.01.01 00:00';
datetime m_last_breakeven           = 0;         // "0" -> D'1970.01.01 00:00';
datetime m_prev_bars                = 0;         // "0" -> D'1970.01.01 00:00';
datetime m_last_deal_in             = 0;         // "0" -> D'1970.01.01 00:00';
int      m_bar_current              = 0;         // curreent postition of candle
//---
bool     m_need_close_all           = false;    // close all positions
double   m_last_volume = 0;
bool     m_init_error               = false;    // error on InInit
//+------------------------------------------------------------------+
//| Structure Positions                                              |
//+------------------------------------------------------------------+
struct STRUCT_POSITION
  {
   ENUM_POSITION_TYPE pos_type;              // position type
   double            volume;                 // position volume (if "0.0" -> the lot is "Money management")
   double            lot_coefficient;        // lot coefficient
   bool              waiting_transaction;    // waiting transaction, "true" -> it's forbidden to trade, we expect a transaction
   ulong             waiting_order_ticket;   // waiting order ticket, ticket of the expected order
   bool              transaction_confirmed;  // transaction confirmed, "true" -> transaction confirmed
   //--- Constructor
                     STRUCT_POSITION()
     {
      pos_type                   = WRONG_VALUE;
      volume                     = 0.0;
      lot_coefficient            = 0.0;
      waiting_transaction        = false;
      waiting_order_ticket       = 0;
      transaction_confirmed      = false;
     }
  };
STRUCT_POSITION SPosition[];
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
   Ex_stop_loss                = 0.0;      // Stop Loss                  -> double
   Ex_take_profit              = 0.0;      // Take Profit                -> double
   Ex_trailing_stop            = 0.0;      // Trailing Stop              -> double
   Ex_m_trailing_step          = 0.0;      // Trailing Step              -> double
   Ex_m_breakeven_stop         = 0.0;      // Breakeven Stop             -> double
   Ex_m_breakeven_step         = 0.0;      // Breakeven Step             -> double
   Ex_m_max_spread             = 0.0;      // Maximum spread -> double

   m_last_trailing            = 0;         // "0" -> D'1970.01.01 00:00';
   m_last_signal              = 0;         // "0" -> D'1970.01.01 00:00';
   m_last_breakeven           = 0;         // "0" -> D'1970.01.01 00:00';
   m_prev_bars                = 0;         // "0" -> D'1970.01.01 00:00';
   m_last_deal_in             = 0;         // "0" -> D'1970.01.01 00:00';
   m_bar_current              = 0;         // curreent postition of candle
//---
   m_need_close_all           = false;    // close all positions
   m_last_volume = 0;
   m_init_error               = false;    // error on InInit
//---
   ResetLastError();
//---
   if(!m_symbol.Name(Symbol()))   // sets symbol name
     {
      Print(__FILE__, " ", __FUNCTION__, ", ERROR: CSymbolInfo.Name");
      return(INIT_FAILED);
     }
   RefreshRates();
//---
   if(IsFillingTypeAllowed(m_symbol.Name(), SYMBOL_FILLING_FOK))
      m_trade.SetTypeFilling(ORDER_FILLING_FOK);
   else
      if(IsFillingTypeAllowed(m_symbol.Name(), SYMBOL_FILLING_IOC))
         m_trade.SetTypeFilling(ORDER_FILLING_IOC);
      else
         m_trade.SetTypeFilling(ORDER_FILLING_RETURN);
//---
   m_trade.SetExpertMagicNumber(InpMagic);
   m_trade.SetMarginMode();
   m_trade.SetTypeFillingBySymbol(m_symbol.Name());
   m_trade.SetDeviationInPoints(InpDeviation);
//--- tuning for 3 or 5 digits
   int digits_adjust = 1;
   if(m_symbol.Digits() == 3 || m_symbol.Digits() == 5)
      digits_adjust = 10;
   m_adjusted_point = m_symbol.Point() * digits_adjust;
   if(InpPipsOrPoints == pips)   // Pips (1.00045-1.00055=1 pips)
     {
      Ex_stop_loss                = InpStopLoss                 * m_adjusted_point;
      Ex_take_profit              = InpTakeProfit               * m_adjusted_point;
      Ex_trailing_stop            = InpTrailingStop             * m_adjusted_point;
      Ex_m_trailing_step          = InpTrailingStep             * m_adjusted_point;
      Ex_m_breakeven_stop         = InpBreakEvenStop            * m_adjusted_point;
      Ex_m_breakeven_step         = InpBreakEvenStep            * m_adjusted_point;
      Ex_m_max_spread             = InpMaxSpread                * m_adjusted_point;

     }
   else     // Points (1.00045-1.00055=10 points)
     {
      Ex_stop_loss                = InpStopLoss                 * m_symbol.Point();
      Ex_take_profit              = InpTakeProfit               * m_symbol.Point();
      Ex_trailing_stop            = InpTrailingStop             * m_symbol.Point();
      Ex_m_trailing_step          = InpTrailingStep             * m_symbol.Point();
      Ex_m_breakeven_stop         = InpBreakEvenStop            * m_symbol.Point();
      Ex_m_breakeven_step         = InpBreakEvenStep            * m_symbol.Point();
      Ex_m_max_spread             = InpMaxSpread                * m_symbol.Point();

     }
//--- check the input parameter "Lots"
   string err_text8 = "";
   if(InpLotOrRisk == lot)
     {
      if(!CheckVolumeValue(InpVolumeLotOrRisk, err_text8))
        {
         //--- when testing, we will only output to the log about incorrect input parameters
         if(MQLInfoInteger(MQL_TESTER))
            Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", err_text8);
         else
            // if the Expert Advisor is run on the chart, tell the user about the error
            Alert(__FILE__, " ", __FUNCTION__, ", ERROR: ", err_text8);
         //---
         m_init_error=true;
         return(INIT_SUCCEEDED);
        }
     }
   else
      if(InpLotOrRisk == risk)
        {
         if(m_money != NULL)
            delete m_money;
         m_money = new CMoneyFixedMargin;
         if(m_money != NULL)
           {
            if(InpVolumeLotOrRisk < 1 || InpVolumeLotOrRisk > 100)
              {
               Print(__FILE__, " ", __FUNCTION__, ", ERROR: ");
               Print("The value for \"Money management\" (", DoubleToString(InpVolumeLotOrRisk, 2), ") -> invalid parameters");
               Print("   parameter must be in the range: from 1.00 to 100.00");
               //---
               m_init_error=true;
               return(INIT_SUCCEEDED);
              }
            if(!m_money.Init(GetPointer(m_symbol), Period(), m_symbol.Point()*digits_adjust))
              {
               Print(__FILE__, " ", __FUNCTION__, ", ERROR: CMoneyFixedMargin.Init");
               //---
               m_init_error=true;
               return(INIT_SUCCEEDED);
              }
            m_money.Percent(InpVolumeLotOrRisk);
           }
         else
           {
            Print(__FILE__, " ", __FUNCTION__, ", ERROR: Object CMoneyFixedMargin is NULL");
            return(INIT_FAILED);
           }
        }
//--- create handle of the indicator iCustom
   handle_iCustom = iCustom(m_symbol.Name(),InpAATRTimeFrame, "::Indicators\\AdaptiveATRChannelMT5Indicator",
                            InpAATRChannelMAPeriod, InpAATRAppliedPrice, InpAATRMultiplier);
//--- if the handle is not created
   if(handle_iCustom == INVALID_HANDLE)
     {
      //--- tell about the failure and output the error code
      PrintFormat("Failed to create handle of the iCustom indicator for the symbol %s/%s, error code %d",
                  m_symbol.Name(),
                  EnumToString(InpAATRTimeFrame),
                  GetLastError());
      //--- the indicator is stopped early
      m_init_error=true;
      return(INIT_SUCCEEDED);
     }
//---- ColorRsiMACD
   handle2_iCustom=iCustom(m_symbol.Name(),InpRsiMACDTimeFrame,"::Indicators\\ColorRsiMACD.ex5",RSIPeriod,RSIPrice,
                           XMA_Method,Fast_XMA,Slow_XMA,XPhase,Signal_Method,Signal_XMA,Signal_Phase,AppliedPrice);
   if(handle2_iCustom==INVALID_HANDLE)
     {
      PrintFormat("Failed to create handle of the iCustom indicator for the symbol %s/%s, error code %d",
                  m_symbol.Name(),
                  EnumToString(InpRsiMACDTimeFrame),
                  GetLastError());
      //--- the indicator is stopped early
      m_init_error=true;
      return(INIT_SUCCEEDED);
     }
//---
   m_bar_current=1;
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
   if(m_money != NULL)
      delete m_money;
//----
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   if(m_init_error)
      return;
//---recovery losses

   if(m_need_close_all)
     {
      if(IsPositionExists())
        {
         CloseAllPositions();
         return;
        }
      else
        {
         m_need_close_all = false;
         m_last_volume = 0;
         ArrayFree(SPosition);
        }
     }
//---
   double profit = ProfitAllPositions();
   if((Ex_InpMyMaxLoss != 0.0 && profit <= Ex_InpMyMaxLoss) || (Ex_InpMyMinProfit != 0.0 && profit >= Ex_InpMyMinProfit))
     {
      m_need_close_all = true;
      return;
     }

//---end of code
//---
   int size_need_position = ArraySize(SPosition);
   if(size_need_position > 0)
     {
      for(int i = size_need_position - 1; i >= 0; i--)
        {
         if(SPosition[i].waiting_transaction)
           {
            if(!SPosition[i].transaction_confirmed)
              {
               if(InpPrintLogo)
                  Print(__FILE__, " ", __FUNCTION__, ", OK: ", "transaction_confirmed: ", SPosition[i].transaction_confirmed);
               return;
              }
            else
               if(SPosition[i].transaction_confirmed)
                 {
                  ArrayRemove(SPosition, i, 1);
                  return;
                 }
           }
         if(SPosition[i].pos_type == POSITION_TYPE_BUY)
           {
            if(InpCloseOposit || input_only_one)
              {
               int      count_buys           = 0;
               double   volume_buys          = 0.0;
               double   volume_biggest_buys  = 0.0;
               int      count_sells          = 0;
               double   volume_sells         = 0.0;
               double   volume_biggest_sells = 0.0;
               CalculateAllPositions(count_buys, volume_buys, volume_biggest_buys,
                                     count_sells, volume_sells, volume_biggest_sells);
               if(InpCloseOposit)
                 {
                  if(count_sells > 0)
                    {
                     ClosePositions(POSITION_TYPE_SELL);
                     return;
                    }
                 }
               if(input_only_one)
                 {
                  if(count_buys + count_sells == 0)
                    {
                     SPosition[i].waiting_transaction = true;
                     OpenPosition(i);
                     return;
                    }
                  else
                     ArrayRemove(SPosition, i, 1);
                  return;
                 }
               if(!input_only_one)
                 {
                  if(count_buys + count_sells == 0)
                    {
                     SPosition[i].waiting_transaction = true;
                     OpenPosition(i);
                     return;
                    }
                  else
                     ArrayRemove(SPosition, i, 2);
                  return;
                 }
              }
            SPosition[i].waiting_transaction = true;
            OpenPosition(i);
            return;
           }
         //--
         if(SPosition[i].pos_type == POSITION_TYPE_SELL)
           {
            if(InpCloseOposit || input_only_one)
              {
               int      count_buys           = 0;
               double   volume_buys          = 0.0;
               double   volume_biggest_buys  = 0.0;
               int      count_sells          = 0;
               double   volume_sells         = 0.0;
               double   volume_biggest_sells = 0.0;
               CalculateAllPositions(count_buys, volume_buys, volume_biggest_buys,
                                     count_sells, volume_sells, volume_biggest_sells);
               if(InpCloseOposit)
                 {
                  if(count_buys > 0)
                    {
                     ClosePositions(POSITION_TYPE_BUY);
                     return;
                    }
                 }
               if(input_only_one)
                 {
                  if(count_buys + count_sells == 0)
                    {
                     SPosition[i].waiting_transaction = true;
                     OpenPosition(i);
                     return;
                    }
                  else
                     ArrayRemove(SPosition, i, 1);
                  return;
                 }
               if(!input_only_one)
                 {
                  if(count_buys + count_sells == 0)
                    {
                     SPosition[i].waiting_transaction = true;
                     OpenPosition(i);
                     return;
                    }
                  else
                     ArrayRemove(SPosition, i, 2);
                  return;
                 }
              }
            SPosition[i].waiting_transaction = true;
            OpenPosition(i);
            return;
           }
        }
     }
//--- we work only at the time of the birth of new bar
   datetime time_0=iTime(m_symbol.Name(),InpWorkingPeriod,0);
   if(time_0==m_prev_bars)
      return;
   m_prev_bars=time_0;
//--- trailing only at the time of the birth of new bar
   Trailing();
   Breakeven();
//--- search for trading signals only at the time of the birth of new bar
   if(!RefreshRates())
     {
      m_prev_bars=0;
      return;
     }
//--- search for trading signals
   if(!SearchTradingSignals())
     {
      m_prev_bars=0;
      return;
     }
//---
   return;
//---
  }
//+------------------------------------------------------------------+
//| TradeTransaction function                                        |
//+------------------------------------------------------------------+
void OnTradeTransaction(const MqlTradeTransaction & trans,
                        const MqlTradeRequest & request,
                        const MqlTradeResult & result)

  {
//--- get transaction type as enumeration value
   ENUM_TRADE_TRANSACTION_TYPE type = trans.type;
//--- if transaction is result of addition of the transaction in history
   if(type == TRADE_TRANSACTION_DEAL_ADD)
     {
      if(HistoryDealSelect(trans.deal))
         m_deal.Ticket(trans.deal);
      else
         return;
      if(m_deal.Symbol() == m_symbol.Name() && m_deal.Magic() == InpMagic)
        {
         if(m_deal.DealType() == DEAL_TYPE_BUY || m_deal.DealType() == DEAL_TYPE_SELL)
           {
            if(m_deal.Entry() == DEAL_ENTRY_IN || m_deal.Entry() == DEAL_ENTRY_INOUT)
              {
               m_last_deal_in = iTime(m_symbol.Name(), InpWorkingPeriod, 0);
              }
            else
              {
               if(m_deal.Entry() == DEAL_ENTRY_OUT)
                 {
                  if(m_deal.Commission() + m_deal.Swap() + m_deal.Profit() < 0.0)
                     m_last_volume = m_deal.Volume();
                  else
                     m_last_volume = 0.0;
                 }
              }
            int size_need_position = ArraySize(SPosition);
            if(size_need_position > 0)
              {
               for(int i = 0; i < size_need_position; i++)
                 {
                  if(SPosition[i].waiting_transaction)
                     if(SPosition[i].waiting_order_ticket == m_deal.Order())
                       {
                        Print(__FUNCTION__, " Transaction confirmed");
                        SPosition[i].transaction_confirmed = true;
                        break;
                       }
                 }
              }
           }
        }
     }
  }
//+------------------------------------------------------------------+
//| Refreshes the symbol quotes data                                 |
//+------------------------------------------------------------------+
bool RefreshRates()
  {
//--- refresh rates
   if(!m_symbol.RefreshRates())
     {
      if(InpPrintLogo)
         Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "RefreshRates error");
      return(false);
     }
//--- protection against the return value of "zero"
   if(m_symbol.Ask() == 0 || m_symbol.Bid() == 0)
     {
      if(InpPrintLogo)
         Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "Ask == 0.0 OR Bid == 0.0");
      return(false);
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
//| Check the correctness of the position volume                     |
//+------------------------------------------------------------------+
bool CheckVolumeValue(double volume, string & error_description)
  {
//--- minimal allowed volume for trade operations
   double min_volume = m_symbol.LotsMin();
   if(volume < min_volume)
     {
      error_description = StringFormat("Volume is less than the minimal allowed SYMBOL_VOLUME_MIN=%.2f", min_volume);
      return(false);
     }
//--- maximal allowed volume of trade operations
   double max_volume = m_symbol.LotsMax();
   if(volume > max_volume)
     {
      error_description = StringFormat("Volume is greater than the maximal allowed SYMBOL_VOLUME_MAX=%.2f", max_volume);
      return(false);
     }
//--- get minimal step of volume changing
   double volume_step = m_symbol.LotsStep();
   int ratio = (int)MathRound(volume / volume_step);
   if(MathAbs(ratio * volume_step - volume) > 0.0000001)
     {
      error_description = StringFormat("Volume is not a multiple of the minimal step SYMBOL_VOLUME_STEP=%.2f, the closest correct volume is %.2f",
                                       volume_step, ratio * volume_step);
      return(false);
     }
   error_description = "Correct volume value";
   return(true);
  }
//+------------------------------------------------------------------+
//| Lot Check                                                        |
//+------------------------------------------------------------------+
double LotCheck(double lots, CSymbolInfo & symbol)
  {
//--- calculate maximum volume
   double volume = NormalizeDouble(lots, 2);
   double stepvol = symbol.LotsStep();
   if(stepvol > 0.0)
      volume = stepvol * MathFloor(volume / stepvol);
//---
   double minvol = symbol.LotsMin();
   if(volume < minvol)
      volume = 0.0;
//---
   double maxvol = symbol.LotsMax();
   if(volume > maxvol)
      volume = maxvol;
   return(volume);
  }
//+------------------------------------------------------------------+
//| Check Freeze and Stops levels                                    |
//+------------------------------------------------------------------+
void FreezeStopsLevels(double & freeze, double & stops)
  {
//--- check Freeze and Stops levels
   /*
   SYMBOL_TRADE_FREEZE_LEVEL shows the distance of freezing the trade operations
      for pending orders and open positions in points
   ------------------------|--------------------|--------------------------------------------
   Type of order/position  |  Activation price  |  Check
   ------------------------|--------------------|--------------------------------------------
   Buy Limit order         |  Ask               |  Ask-OpenPrice  >= SYMBOL_TRADE_FREEZE_LEVEL
   Buy Stop order          |  Ask               |  OpenPrice-Ask  >= SYMBOL_TRADE_FREEZE_LEVEL
   Sell Limit order        |  Bid               |  OpenPrice-Bid  >= SYMBOL_TRADE_FREEZE_LEVEL
   Sell Stop order         |  Bid               |  Bid-OpenPrice  >= SYMBOL_TRADE_FREEZE_LEVEL
   Buy position            |  Bid               |  TakeProfit-Bid >= SYMBOL_TRADE_FREEZE_LEVEL
                           |                    |  Bid-StopLoss   >= SYMBOL_TRADE_FREEZE_LEVEL
   Sell position           |  Ask               |  Ask-TakeProfit >= SYMBOL_TRADE_FREEZE_LEVEL
                           |                    |  StopLoss-Ask   >= SYMBOL_TRADE_FREEZE_LEVEL
   ------------------------------------------------------------------------------------------

   SYMBOL_TRADE_STOPS_LEVEL determines the number of points for minimum indentation of the
      StopLoss and TakeProfit levels from the current closing price of the open position
   ------------------------------------------------|------------------------------------------
   Buying is done at the Ask price                 |  Selling is done at the Bid price
   ------------------------------------------------|------------------------------------------
   TakeProfit        >= Bid                        |  TakeProfit        <= Ask
   StopLoss          <= Bid                        |  StopLoss          >= Ask
   TakeProfit - Bid  >= SYMBOL_TRADE_STOPS_LEVEL   |  Ask - TakeProfit  >= SYMBOL_TRADE_STOPS_LEVEL
   Bid - StopLoss    >= SYMBOL_TRADE_STOPS_LEVEL   |  StopLoss - Ask    >= SYMBOL_TRADE_STOPS_LEVEL
   ------------------------------------------------------------------------------------------
   */
   double coeff = (double)InpFreezeLevel;
   if(!RefreshRates() || !m_symbol.Refresh())
      return;
//--- FreezeLevel -> for pending order and modification
   double freeze_level = m_symbol.FreezeLevel() * m_symbol.Point();
   if(freeze_level == 0.0)
      if(InpFreezeLevel > 0)
         freeze_level = (m_symbol.Ask() - m_symbol.Bid()) * coeff;
//--- StopsLevel -> for TakeProfit and StopLoss
   double stop_level = m_symbol.StopsLevel() * m_symbol.Point();
   if(stop_level == 0.0)
      if(InpFreezeLevel > 0)
         stop_level = (m_symbol.Ask() - m_symbol.Bid()) * coeff;
//---
   freeze = freeze_level;
   stops = stop_level;
//---
   return;
  }
//+------------------------------------------------------------------+
//| Open position                                                    |
//|   double stop_loss                                               |
//|      -> pips * m_adjusted_point (if "0.0" -> the Ex_stop_loss)    |
//|   double take_profit                                             |
//|      -> pips * m_adjusted_point (if "0.0" -> the Ex_take_profit)  |
//+------------------------------------------------------------------+
void OpenPosition(const int index)
  {
//---
   double freeze = 0.0, stops = 0.0;
   FreezeStopsLevels(freeze, stops);
   /*
   SYMBOL_TRADE_STOPS_LEVEL determines the number of points for minimum indentation of the
      StopLoss and TakeProfit levels from the current closing price of the open position
   ------------------------------------------------|------------------------------------------
   Buying is done at the Ask price                 |  Selling is done at the Bid price
   ------------------------------------------------|------------------------------------------
   TakeProfit        >= Bid                        |  TakeProfit        <= Ask
   StopLoss          <= Bid                        |  StopLoss          >= Ask
   TakeProfit - Bid  >= SYMBOL_TRADE_STOPS_LEVEL   |  Ask - TakeProfit  >= SYMBOL_TRADE_STOPS_LEVEL
   Bid - StopLoss    >= SYMBOL_TRADE_STOPS_LEVEL   |  StopLoss - Ask    >= SYMBOL_TRADE_STOPS_LEVEL
   ------------------------------------------------------------------------------------------
   */
   if(ActivateMaxSpread)
     {
      double spread = m_symbol.Ask() - m_symbol.Bid();
      if(spread > Ex_m_max_spread)
        {
         SPosition[index].waiting_transaction = false;
         if(InpPrintLogo)
            Print(__FILE__, " ", __FUNCTION__,
                  ", ERROR: ", "Spread Ask-Bid (", DoubleToString(spread, m_symbol.Digits()), ")",
                  " > Maximum spread (", DoubleToString(Ex_m_max_spread, m_symbol.Digits()), ")");
         return;
        }
     }
//--- buy
   if(SPosition[index].pos_type == POSITION_TYPE_BUY)
     {
      double sl = (Ex_stop_loss == 0.0) ? 0.0 : m_symbol.Ask() - Ex_stop_loss;
      if(sl > 0.0)
         if(m_symbol.Bid() - sl < stops)
            sl = m_symbol.Bid() - stops;
      double tp = (Ex_take_profit == 0.0) ? 0.0 : m_symbol.Ask() + Ex_take_profit;
      if(tp > 0.0)
         if(tp - m_symbol.Ask() < stops)
            tp = m_symbol.Ask() + stops;
      OpenBuy(index, sl, tp);
      return;
     }
//--- sell
   if(SPosition[index].pos_type == POSITION_TYPE_SELL)
     {
      double sl = (Ex_stop_loss == 0.0) ? 0.0 : m_symbol.Bid() + Ex_stop_loss;
      if(sl > 0.0)
         if(sl - m_symbol.Ask() < stops)
            sl = m_symbol.Ask() + stops;
      double tp = (Ex_take_profit == 0.0) ? 0.0 : m_symbol.Bid() - Ex_take_profit;
      if(tp > 0.0)
         if(m_symbol.Bid() - tp < stops)
            tp = m_symbol.Bid() - stops;
      OpenSell(index, sl, tp);
      return;
     }
  }
//+------------------------------------------------------------------+
//| Open Buy position                                                |
//+------------------------------------------------------------------+
void OpenBuy(const int index, double sl, double tp)
  {
   sl = m_symbol.NormalizePrice(sl);
   tp = m_symbol.NormalizePrice(tp);
   double long_lot = 0.0;
   if(SPosition[index].volume > 0.0)
      long_lot = SPosition[index].volume;
   else
     {
      if(InpLotOrRisk == risk)
        {
         long_lot = m_money.CheckOpenLong(m_symbol.Ask(), sl);
         if(InpPrintLogo)
            Print(__FILE__, " ", __FUNCTION__, ", OK: ", "sl=", DoubleToString(sl, m_symbol.Digits()),
                  ", CheckOpenLong: ", DoubleToString(long_lot, 2),
                  ", Balance: ",    DoubleToString(m_account.Balance(), 2),
                  ", Equity: ",     DoubleToString(m_account.Equity(), 2),
                  ", FreeMargin: ", DoubleToString(m_account.FreeMargin(), 2));
         if(long_lot == 0.0)
           {
            ArrayRemove(SPosition, index, 1);
            if(InpPrintLogo)
               Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "CMoneyFixedMargin.CheckOpenLong returned the value of 0.0");
            return;
           }
        }
      else
         if(InpLotOrRisk == lot)
            long_lot = InpVolumeLotOrRisk;
         else
            if(InpLotOrRisk == lots_min)
               long_lot = m_symbol.LotsMin();
            else
              {
               ArrayRemove(SPosition, index, 1);
               return;
              }
     }
   if(SPosition[index].lot_coefficient > 0.0)
     {
      long_lot = LotCheck(long_lot * SPosition[index].lot_coefficient,
                          m_symbol);
      if(long_lot == 0)
        {
         ArrayRemove(SPosition, index, 1);
         if(InpPrintLogo)
            Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "LotCheck returned the 0.0");
         return;
        }
     }
   if(m_symbol.LotsLimit() > 0.0)
     {
      int      count_buys           = 0;
      double   volume_buys          = 0.0;
      double   volume_biggest_buys  = 0.0;
      int      count_sells          = 0;
      double   volume_sells         = 0.0;
      double   volume_biggest_sells = 0.0;
      CalculateAllPositions(count_buys, volume_buys, volume_biggest_buys,
                            count_sells, volume_sells, volume_biggest_sells);
      if(volume_buys + volume_sells + long_lot > m_symbol.LotsLimit())
        {
         ArrayRemove(SPosition, index, 1);
         if(InpPrintLogo)
            Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "#0 Buy, Volume Buy (", DoubleToString(volume_buys, 2),
                  ") + Volume Sell (", DoubleToString(volume_sells, 2),
                  ") + Volume long (", DoubleToString(long_lot, 2),
                  ") > Lots Limit (", DoubleToString(m_symbol.LotsLimit(), 2), ")");
         return;
        }
     }
//--- check volume before OrderSend to avoid "not enough money" error (CTrade)
   double free_margin_check = m_account.FreeMarginCheck(m_symbol.Name(),
                              ORDER_TYPE_BUY,
                              long_lot,
                              m_symbol.Ask());
   double margin_check = m_account.MarginCheck(m_symbol.Name(),
                         ORDER_TYPE_BUY,
                         long_lot,
                         m_symbol.Ask());
   if(free_margin_check > margin_check)
     {
      if(m_trade.Buy(long_lot, m_symbol.Name(),
                     m_symbol.Ask(), sl, tp, MyComment))   // CTrade::Buy -> "true"
        {
         if(m_trade.ResultDeal() == 0)
           {
            if(m_trade.ResultRetcode() == 10009)   // trade order went to the exchange
              {
               SPosition[index].waiting_transaction = true;
               SPosition[index].waiting_order_ticket = m_trade.ResultOrder();
              }
            else
              {
               SPosition[index].waiting_transaction = false;
               if(InpPrintLogo)
                  Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "#1 Buy -> false. Result Retcode: ", m_trade.ResultRetcode(),
                        ", description of result: ", m_trade.ResultRetcodeDescription());
              }
            if(InpPrintLogo)
               PrintResultTrade(m_trade, m_symbol);
           }
         else
           {
            if(m_trade.ResultRetcode() == 10009)
              {
               SPosition[index].waiting_transaction = true;
               SPosition[index].waiting_order_ticket = m_trade.ResultOrder();
              }
            else
              {
               SPosition[index].waiting_transaction = false;
               if(InpPrintLogo)
                  Print(__FILE__, " ", __FUNCTION__, ", OK: ", "#2 Buy -> true. Result Retcode: ", m_trade.ResultRetcode(),
                        ", description of result: ", m_trade.ResultRetcodeDescription());
              }
            if(InpPrintLogo)
               PrintResultTrade(m_trade, m_symbol);
           }
        }
      else
        {
         SPosition[index].waiting_transaction = false;
         if(InpPrintLogo)
            Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "#3 Buy -> false. Result Retcode: ", m_trade.ResultRetcode(),
                  ", description of result: ", m_trade.ResultRetcodeDescription());
         if(InpPrintLogo)
            PrintResultTrade(m_trade, m_symbol);
        }
     }
   else
     {
      ArrayRemove(SPosition, index, 1);
      if(InpPrintLogo)
         Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "CAccountInfo.FreeMarginCheck returned the value ", DoubleToString(free_margin_check, 2));
      return;
     }
//---
  }
//+------------------------------------------------------------------+
//| Open Sell position                                               |
//+------------------------------------------------------------------+
void OpenSell(const int index, double sl, double tp)
  {
   sl = m_symbol.NormalizePrice(sl);
   tp = m_symbol.NormalizePrice(tp);
   double short_lot = 0.0;
   if(SPosition[index].volume > 0.0)
      short_lot = SPosition[index].volume;
   else
     {
      if(InpLotOrRisk == risk)
        {
         short_lot = m_money.CheckOpenShort(m_symbol.Bid(), sl);
         if(InpPrintLogo)
            Print(__FILE__, " ", __FUNCTION__, ", OK: ", "sl=", DoubleToString(sl, m_symbol.Digits()),
                  ", CheckOpenLong: ", DoubleToString(short_lot, 2),
                  ", Balance: ",    DoubleToString(m_account.Balance(), 2),
                  ", Equity: ",     DoubleToString(m_account.Equity(), 2),
                  ", FreeMargin: ", DoubleToString(m_account.FreeMargin(), 2));
         if(short_lot == 0.0)
           {
            ArrayRemove(SPosition, index, 1);
            if(InpPrintLogo)
               Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "CMoneyFixedMargin.CheckOpenShort returned the value of \"0.0\"");
            return;
           }
        }
      else
         if(InpLotOrRisk == lot)
            short_lot = InpVolumeLotOrRisk;
         else
            if(InpLotOrRisk == lots_min)
               short_lot = m_symbol.LotsMin();
            else
              {
               ArrayRemove(SPosition, index, 1);
               return;
              }
     }
   if(SPosition[index].lot_coefficient > 0.0)
     {
      short_lot = LotCheck(short_lot * SPosition[index].lot_coefficient, m_symbol);
      if(short_lot == 0)
        {
         ArrayRemove(SPosition, index, 1);
         if(InpPrintLogo)
            Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "LotCheck returned the 0.0");
         return;
        }
     }
   if(m_symbol.LotsLimit() > 0.0)
     {
      int      count_buys           = 0;
      double   volume_buys          = 0.0;
      double   volume_biggest_buys  = 0.0;
      int      count_sells          = 0;
      double   volume_sells         = 0.0;
      double   volume_biggest_sells = 0.0;
      CalculateAllPositions(count_buys, volume_buys, volume_biggest_buys,
                            count_sells, volume_sells, volume_biggest_sells);
      if(volume_buys + volume_sells + short_lot > m_symbol.LotsLimit())
        {
         ArrayRemove(SPosition, index, 1);
         if(InpPrintLogo)
            Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "#0 Buy, Volume Buy (", DoubleToString(volume_buys, 2),
                  ") + Volume Sell (", DoubleToString(volume_sells, 2),
                  ") + Volume short (", DoubleToString(short_lot, 2),
                  ") > Lots Limit (", DoubleToString(m_symbol.LotsLimit(), 2), ")");
         return;
        }
     }
//--- check volume before OrderSend to avoid "not enough money" error (CTrade)
   double free_margin_check = m_account.FreeMarginCheck(m_symbol.Name(),
                              ORDER_TYPE_SELL,
                              short_lot,
                              m_symbol.Bid());
   double margin_check = m_account.MarginCheck(m_symbol.Name(),
                         ORDER_TYPE_SELL,
                         short_lot,
                         m_symbol.Bid());
   if(free_margin_check > margin_check)
     {
      if(m_trade.Sell(short_lot, m_symbol.Name(),
                      m_symbol.Bid(), sl, tp, MyComment))   // CTrade::Sell -> "true"
        {
         if(m_trade.ResultDeal() == 0)
           {
            if(m_trade.ResultRetcode() == 10009)   // trade order went to the exchange
              {
               SPosition[index].waiting_transaction = true;
               SPosition[index].waiting_order_ticket = m_trade.ResultOrder();
              }
            else
              {
               SPosition[index].waiting_transaction = false;
               if(InpPrintLogo)
                  Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "#1 Sell -> false. Result Retcode: ", m_trade.ResultRetcode(),
                        ", description of result: ", m_trade.ResultRetcodeDescription());
              }
            if(InpPrintLogo)
               PrintResultTrade(m_trade, m_symbol);
           }
         else
           {
            if(m_trade.ResultRetcode() == 10009)
              {
               SPosition[index].waiting_transaction = true;
               SPosition[index].waiting_order_ticket = m_trade.ResultOrder();
              }
            else
              {
               SPosition[index].waiting_transaction = false;
               if(InpPrintLogo)
                  Print(__FILE__, " ", __FUNCTION__, ", OK: ", "#2 Sell -> true. Result Retcode: ", m_trade.ResultRetcode(),
                        ", description of result: ", m_trade.ResultRetcodeDescription());
              }
            if(InpPrintLogo)
               PrintResultTrade(m_trade, m_symbol);
           }
        }
      else
        {
         SPosition[index].waiting_transaction = false;
         if(InpPrintLogo)
            Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "#3 Sell -> false. Result Retcode: ", m_trade.ResultRetcode(),
                  ", description of result: ", m_trade.ResultRetcodeDescription());
         if(InpPrintLogo)
            PrintResultTrade(m_trade, m_symbol);
        }
     }
   else
     {
      ArrayRemove(SPosition, index, 1);
      if(InpPrintLogo)
         Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "CAccountInfo.FreeMarginCheck returned the value ", DoubleToString(free_margin_check, 2));
      return;
     }
//---
  }
//+------------------------------------------------------------------+
//| Print CTrade result                                              |
//+------------------------------------------------------------------+
void PrintResultTrade(CTrade & trade, CSymbolInfo & symbol)
  {
   Print(__FILE__, " ", __FUNCTION__, ", Symbol: ", symbol.Name() + ", " +
         "Code of request result: " + IntegerToString(trade.ResultRetcode()) + ", " +
         "Code of request result as a string: " + trade.ResultRetcodeDescription(),
         "Trade execution mode: " + symbol.TradeExecutionDescription());
   Print("Deal ticket: " + IntegerToString(trade.ResultDeal()) + ", " +
         "Order ticket: " + IntegerToString(trade.ResultOrder()) + ", " +
         "Order retcode external: " + IntegerToString(trade.ResultRetcodeExternal()) + ", " +
         "Volume of deal or order: " + DoubleToString(trade.ResultVolume(), 2));
   Print("Price, confirmed by broker: " + DoubleToString(trade.ResultPrice(), symbol.Digits()) + ", " +
         "Current bid price: " + DoubleToString(symbol.Bid(), symbol.Digits()) + " (the requote): " + DoubleToString(trade.ResultBid(), symbol.Digits()) + ", " +
         "Current ask price: " + DoubleToString(symbol.Ask(), symbol.Digits()) + " (the requote): " + DoubleToString(trade.ResultAsk(), symbol.Digits()));
   Print("Broker comment: " + trade.ResultComment());
  }
//+------------------------------------------------------------------+
//| Breakeven                                                         |
//|   InpBreakevenStop: min distance from price to Stop Loss          |
//+------------------------------------------------------------------+
void Breakeven()
  {
   /*
      Buying is done at the Ask price                 |  Selling is done at the Bid price
      ------------------------------------------------|----------------------------------
      TakeProfit        >= Bid                        |  TakeProfit        <= Ask
      StopLoss          <= Bid                        |  StopLoss          >= Ask
      TakeProfit - Bid  >= SYMBOL_TRADE_STOPS_LEVEL   |  Ask - TakeProfit  >= SYMBOL_TRADE_STOPS_LEVEL
      Bid - StopLoss    >= SYMBOL_TRADE_STOPS_LEVEL   |  StopLoss - Ask    >= SYMBOL_TRADE_STOPS_LEVEL
   */
   if(input_activate_be_stop)
     {
      if(InpBreakEvenStop == 0)
         return;
      double freeze = 0.0, stops = 0.0;
      FreezeStopsLevels(freeze, stops);
      double stop_level = 0;
      for(int i = PositionsTotal() - 1; i >= 0; i--) // returns the number of open positions
         if(m_position.SelectByIndex(i))
            if(m_position.Symbol() == m_symbol.Name())
              {
               double price_current = m_position.PriceCurrent();
               double price_open    = m_position.PriceOpen();
               double stop_loss     = m_position.StopLoss();
               double take_profit   = m_position.TakeProfit();
               double ask           = m_symbol.Ask();
               double bid           = m_symbol.Bid();
               //---
               if(m_position.PositionType() == POSITION_TYPE_BUY)
                 {
                  if(price_current - price_open > Ex_m_breakeven_stop + Ex_m_breakeven_step)
                     if(stop_loss < price_open + Ex_m_breakeven_stop)
                        if(!CompareDoubles(stop_loss, price_open + Ex_m_breakeven_stop, m_symbol.Digits()))
                           if(Ex_m_breakeven_stop >= stop_level && (take_profit - bid >= stop_level || take_profit == 0.0))
                             {
                              if(!m_trade.PositionModify(m_position.Ticket(),
                                                         m_symbol.NormalizePrice(price_open + Ex_m_breakeven_stop),
                                                         take_profit))
                                 if(InpPrintLogo)
                                    Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "Modify BUY ", m_position.Ticket(),
                                          " Position -> false. Result Retcode: ", m_trade.ResultRetcode(),
                                          ", description of result: ", m_trade.ResultRetcodeDescription());
                              if(InpPrintLogo)
                                {
                                 RefreshRates();
                                 m_position.SelectByIndex(i);
                                 PrintResultModify(m_trade, m_symbol, m_position);
                                }
                              continue;
                             }
                 }
               else
                 {
                  if(price_open - price_current > Ex_m_breakeven_stop + Ex_m_breakeven_step)
                     if((stop_loss > (price_open - Ex_m_breakeven_stop)) || (stop_loss == 0))
                        if(!CompareDoubles(stop_loss, price_open - Ex_m_breakeven_stop, m_symbol.Digits()))
                           if(Ex_m_breakeven_stop >= stop_level && ask - take_profit >= stop_level)
                             {
                              if(!m_trade.PositionModify(m_position.Ticket(),
                                                         m_symbol.NormalizePrice(price_open - Ex_m_breakeven_stop),
                                                         take_profit))
                                 if(InpPrintLogo)
                                    Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "Modify SELL ", m_position.Ticket(),
                                          " Position -> false. Result Retcode: ", m_trade.ResultRetcode(),
                                          ", description of result: ", m_trade.ResultRetcodeDescription());
                              if(InpPrintLogo)
                                {
                                 RefreshRates();
                                 m_position.SelectByIndex(i);
                                 PrintResultModify(m_trade, m_symbol, m_position);
                                }
                             }
                 }
              }
      return;
     }

  }
//+------------------------------------------------------------------+
//| Compare doubles                                                  |
//+------------------------------------------------------------------+
bool CompareDoubles(double number1, double number2, int digits)
  {
   digits--;
   if(digits < 0)
      digits = 0;
   if(NormalizeDouble(number1 - number2, digits) == 0)
      return(true);
   else
      return(false);
  }
//+------------------------------------------------------------------+
//| Trailing                                                         |
//|   InpTrailingStop: min distance from price to Stop Loss          |
//+------------------------------------------------------------------+
void Trailing()
  {
   if(input_activate_trailing_stop)
     {
      if(InpTrailingStop == 0)
         return;
      double freeze = 0.0, stops = 0.0;
      FreezeStopsLevels(freeze, stops);
      /*
      SYMBOL_TRADE_FREEZE_LEVEL shows the distance of freezing the trade operations
         for pending orders and open positions in points
      ------------------------|--------------------|--------------------------------------------
      Type of order/position  |  Activation price  |  Check
      ------------------------|--------------------|--------------------------------------------
      Buy Limit order         |  Ask               |  Ask-OpenPrice  >= SYMBOL_TRADE_FREEZE_LEVEL
      Buy Stop order          |  Ask               |  OpenPrice-Ask  >= SYMBOL_TRADE_FREEZE_LEVEL
      Sell Limit order        |  Bid               |  OpenPrice-Bid  >= SYMBOL_TRADE_FREEZE_LEVEL
      Sell Stop order         |  Bid               |  Bid-OpenPrice  >= SYMBOL_TRADE_FREEZE_LEVEL
      Buy position            |  Bid               |  TakeProfit-Bid >= SYMBOL_TRADE_FREEZE_LEVEL
                              |                    |  Bid-StopLoss   >= SYMBOL_TRADE_FREEZE_LEVEL
      Sell position           |  Ask               |  Ask-TakeProfit >= SYMBOL_TRADE_FREEZE_LEVEL
                              |                    |  StopLoss-Ask   >= SYMBOL_TRADE_FREEZE_LEVEL
      ------------------------------------------------------------------------------------------
      */
      for(int i = PositionsTotal() - 1; i >= 0; i--) // returns the number of open positions
         if(m_position.SelectByIndex(i))
            if(m_position.Symbol() == m_symbol.Name() && m_position.Magic() == InpMagic)
              {
               double price_current = m_position.PriceCurrent();
               double price_open    = m_position.PriceOpen();
               double stop_loss     = m_position.StopLoss();
               double take_profit   = m_position.TakeProfit();
               double ask           = m_symbol.Ask();
               double bid           = m_symbol.Bid();
               //---
               if(m_position.PositionType() == POSITION_TYPE_BUY)
                 {
                  if(price_current - price_open > Ex_trailing_stop + Ex_m_trailing_step)
                     if(stop_loss < price_current - (Ex_trailing_stop + Ex_m_trailing_step))
                        if(Ex_trailing_stop >= freeze && (take_profit - bid >= freeze || take_profit == 0.0))
                          {
                           if(!m_trade.PositionModify(m_position.Ticket(),
                                                      m_symbol.NormalizePrice(price_current - Ex_trailing_stop),
                                                      take_profit))
                              if(InpPrintLogo)
                                 Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "Modify BUY ", m_position.Ticket(),
                                       " Position -> false. Result Retcode: ", m_trade.ResultRetcode(),
                                       ", description of result: ", m_trade.ResultRetcodeDescription());
                           if(InpPrintLogo)
                             {
                              RefreshRates();
                              m_position.SelectByIndex(i);
                              PrintResultModify(m_trade, m_symbol, m_position);
                             }
                           continue;
                          }
                 }
               else
                 {
                  if(price_open - price_current > Ex_trailing_stop + Ex_m_trailing_step)
                     if((stop_loss > (price_current + (Ex_trailing_stop + Ex_m_trailing_step))) || (stop_loss == 0))
                        if(Ex_trailing_stop >= freeze && ask - take_profit >= freeze)
                          {
                           if(!m_trade.PositionModify(m_position.Ticket(),
                                                      m_symbol.NormalizePrice(price_current + Ex_trailing_stop),
                                                      take_profit))
                              if(InpPrintLogo)
                                 Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "Modify SELL ", m_position.Ticket(),
                                       " Position -> false. Result Retcode: ", m_trade.ResultRetcode(),
                                       ", description of result: ", m_trade.ResultRetcodeDescription());
                           if(InpPrintLogo)
                             {
                              RefreshRates();
                              m_position.SelectByIndex(i);
                              PrintResultModify(m_trade, m_symbol, m_position);
                             }
                          }
                 }
              }
      return;
     }
  }
//+------------------------------------------------------------------+
//| Print CTrade result                                              |
//+------------------------------------------------------------------+
void PrintResultModify(CTrade & trade, CSymbolInfo & symbol, CPositionInfo & position)
  {
   Print("File: ", __FILE__, ", symbol: ", symbol.Name());
   Print("Code of request result: " + IntegerToString(trade.ResultRetcode()));
   Print("code of request result as a string: " + trade.ResultRetcodeDescription());
   Print("Deal ticket: " + IntegerToString(trade.ResultDeal()));
   Print("Order ticket: " + IntegerToString(trade.ResultOrder()));
   Print("Volume of deal or order: " + DoubleToString(trade.ResultVolume(), 2));
   Print("Price, confirmed by broker: " + DoubleToString(trade.ResultPrice(), symbol.Digits()));
   Print("Current bid price: " + DoubleToString(symbol.Bid(), symbol.Digits()) + " (the requote): " + DoubleToString(trade.ResultBid(), symbol.Digits()));
   Print("Current ask price: " + DoubleToString(symbol.Ask(), symbol.Digits()) + " (the requote): " + DoubleToString(trade.ResultAsk(), symbol.Digits()));
   Print("Broker comment: " + trade.ResultComment());
   Print("Freeze Level: " + DoubleToString(symbol.FreezeLevel(), 0), ", Stops Level: " + DoubleToString(symbol.StopsLevel(), 0));
   Print("Price of position opening: " + DoubleToString(position.PriceOpen(), symbol.Digits()));
   Print("Price of position's Stop Loss: " + DoubleToString(position.StopLoss(), symbol.Digits()));
   Print("Price of position's Take Profit: " + DoubleToString(position.TakeProfit(), symbol.Digits()));
   Print("Current price by position: " + DoubleToString(position.PriceCurrent(), symbol.Digits()));
  }
//+------------------------------------------------------------------+
//| Close positions                                                  |
//+------------------------------------------------------------------+
void ClosePositions(const ENUM_POSITION_TYPE pos_type)
  {
   double freeze = 0.0, stops = 0.0;
   FreezeStopsLevels(freeze, stops);
   /*
   SYMBOL_TRADE_FREEZE_LEVEL shows the distance of freezing the trade operations
      for pending orders and open positions in points
   ------------------------|--------------------|--------------------------------------------
   Type of order/position  |  Activation price  |  Check
   ------------------------|--------------------|--------------------------------------------
   Buy Limit order         |  Ask               |  Ask-OpenPrice  >= SYMBOL_TRADE_FREEZE_LEVEL
   Buy Stop order          |  Ask               |  OpenPrice-Ask  >= SYMBOL_TRADE_FREEZE_LEVEL
   Sell Limit order        |  Bid               |  OpenPrice-Bid  >= SYMBOL_TRADE_FREEZE_LEVEL
   Sell Stop order         |  Bid               |  Bid-OpenPrice  >= SYMBOL_TRADE_FREEZE_LEVEL
   Buy position            |  Bid               |  TakeProfit-Bid >= SYMBOL_TRADE_FREEZE_LEVEL
                           |                    |  Bid-StopLoss   >= SYMBOL_TRADE_FREEZE_LEVEL
   Sell position           |  Ask               |  Ask-TakeProfit >= SYMBOL_TRADE_FREEZE_LEVEL
                           |                    |  StopLoss-Ask   >= SYMBOL_TRADE_FREEZE_LEVEL
   ------------------------------------------------------------------------------------------
   */
   for(int i = PositionsTotal() - 1; i >= 0; i--) // returns the number of current positions
      if(m_position.SelectByIndex(i)) // selects the position by index for further access to its properties
         if(m_position.Symbol() == m_symbol.Name() && m_position.Magic() == InpMagic)
            if(m_position.PositionType() == pos_type)
              {
               if(m_position.PositionType() == POSITION_TYPE_BUY)
                 {
                  bool take_profit_level = ((m_position.TakeProfit() != 0.0 && m_position.TakeProfit() - m_position.PriceCurrent() >= freeze) || m_position.TakeProfit() == 0.0);
                  bool stop_loss_level = ((m_position.StopLoss() != 0.0 && m_position.PriceCurrent() - m_position.StopLoss() >= freeze) || m_position.StopLoss() == 0.0);
                  if(take_profit_level && stop_loss_level)
                     if(!m_trade.PositionClose(m_position.Ticket())) // close a position by the specified m_symbol
                        if(InpPrintLogo)
                           Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "CTrade.PositionClose ", m_position.Ticket());
                 }
               if(m_position.PositionType() == POSITION_TYPE_SELL)
                 {
                  bool take_profit_level = ((m_position.TakeProfit() != 0.0 && m_position.PriceCurrent() - m_position.TakeProfit() >= freeze) || m_position.TakeProfit() == 0.0);
                  bool stop_loss_level = ((m_position.StopLoss() != 0.0 && m_position.StopLoss() - m_position.PriceCurrent() >= freeze) || m_position.StopLoss() == 0.0);
                  if(take_profit_level && stop_loss_level)
                     if(!m_trade.PositionClose(m_position.Ticket())) // close a position by the specified m_symbol
                        if(InpPrintLogo)
                           Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "CTrade.PositionClose ", m_position.Ticket());
                 }
              }
  }
//+------------------------------------------------------------------+
//| Calculate all positions                                          |
//+------------------------------------------------------------------+
void CalculateAllPositions(int &count_buys, double & volume_buys, double & volume_biggest_buys,
                           int &count_sells, double & volume_sells, double & volume_biggest_sells)
  {
   count_buys  = 0;
   volume_buys   = 0.0;
   volume_biggest_buys  = 0.0;
   count_sells = 0;
   volume_sells  = 0.0;
   volume_biggest_sells = 0.0;
   for(int i = PositionsTotal() - 1; i >= 0; i--)
      if(m_position.SelectByIndex(i)) // selects the position by index for further access to its properties
         if(m_position.Symbol() == m_symbol.Name())
           {
            if(m_position.PositionType() == POSITION_TYPE_BUY)
              {
               count_buys++;
               volume_buys += m_position.Volume();
               if(m_position.Volume() > volume_biggest_buys)
                  volume_biggest_buys = m_position.Volume();
               continue;
              }
            else
               if(m_position.PositionType() == POSITION_TYPE_SELL)
                 {
                  count_sells++;
                  volume_sells += m_position.Volume();
                  if(m_position.Volume() > volume_biggest_sells)
                     volume_biggest_sells = m_position.Volume();
                 }
           }
  }
//+------------------------------------------------------------------+
//| Get value of buffers                                             |
//+------------------------------------------------------------------+
bool iGetArray(const int handle, const int buffer, const int start_pos,
               const int count, double & arr_buffer[])
  {
   bool result = true;
   if(!ArrayIsDynamic(arr_buffer))
     {
      if(InpPrintLogo)
         PrintFormat("ERROR! EA: %s, FUNCTION: %s, this a no dynamic array!", __FILE__, __FUNCTION__);
      return(false);
     }
   ArrayFree(arr_buffer);
//--- reset error code
   ResetLastError();
//--- fill a part of the iBands array with values from the indicator buffer
   int copied = CopyBuffer(handle, buffer, start_pos, count, arr_buffer);
   if(copied != count)
     {
      //--- if the copying fails, tell the error code
      if(InpPrintLogo)
         PrintFormat("ERROR! EA: %s, FUNCTION: %s, amount to copy: %d, copied: %d, error code %d",
                     __FILE__, __FUNCTION__, count, copied, GetLastError());
      //--- quit with zero result - it means that the indicator is considered as not calculated
      return(false);
     }
   return(result);
  }
//+------------------------------------------------------------------+
//| Search trading signals                                           |
//+------------------------------------------------------------------+
bool SearchTradingSignals(void)
  {
//---
   if(iTime(m_symbol.Name(),InpWorkingPeriod,0)==m_last_deal_in) // on one bar - only one deal
      return(true);
//---
   if(!TimeControlHourMinute())
      return(true);
//---
   double transform_color[], upper_band[], lower_band[],atr_base_line[],macd_bar_transform_color[],macd_signal_L_transform_color[];
   ArraySetAsSeries(transform_color, true);
   ArraySetAsSeries(macd_bar_transform_color, true);
   ArraySetAsSeries(macd_signal_L_transform_color, true);
   ArraySetAsSeries(atr_base_line, true);
   ArraySetAsSeries(upper_band, true);
   ArraySetAsSeries(lower_band, true);
   MqlRates rates[];
   ArraySetAsSeries(rates, true);
   int start_pos = 0, count = 6;
   if(!iGetArray(handle_iCustom, 0, start_pos, count,atr_base_line)      ||
      !iGetArray(handle_iCustom, 1, start_pos, count, transform_color)      ||
      !iGetArray(handle_iCustom, UPPER_BAND, start_pos, count, upper_band)  ||
      !iGetArray(handle_iCustom, LOWER_BAND, start_pos, count, lower_band)  ||
      !iGetArray(handle2_iCustom, 1, start_pos, count, macd_bar_transform_color)  ||
      !iGetArray(handle2_iCustom, 3, start_pos, count, macd_signal_L_transform_color)  ||
      CopyRates(m_symbol.Name(), Period(), start_pos, count, rates) != count)
      return(false);
//---
   bool buy_1  = transform_color[m_bar_current + 1] == 2.0 && transform_color[m_bar_current]== 1.0;
   bool buy_2  = rates[m_bar_current+1].close < atr_base_line[m_bar_current+1] && rates[m_bar_current].close > atr_base_line[m_bar_current];
   bool buy_3 = macd_bar_transform_color[m_bar_current + 1] == 2.0 && macd_bar_transform_color[m_bar_current]== 1.0;
   bool buy_4 =  macd_signal_L_transform_color[m_bar_current + 1] == 2.0 && macd_signal_L_transform_color[m_bar_current]== 1.0;
   
//---

   bool sell_1 = transform_color[m_bar_current + 1] == 1.0 && transform_color[m_bar_current] == 2.0;
   bool sell_2 = rates[m_bar_current+1].close > atr_base_line[m_bar_current+1] && rates[m_bar_current].close < atr_base_line[m_bar_current];
   
   bool sell_3 = macd_bar_transform_color[m_bar_current + 1] == 1.0 && macd_bar_transform_color[m_bar_current] == 2.0;
   bool sell_4 =   macd_signal_L_transform_color[m_bar_current + 1] == 1.0 &&  macd_signal_L_transform_color[m_bar_current] == 2.0;
//---
   int size_need_position = ArraySize(SPosition);
   if(size_need_position > 0)
      return(true);
//---
   if((buy_1 || buy_2) && ( buy_3 || buy_4))
     {
      if(!InpRevers)
        {
         if(InpTradeMode != sell)
           {
            ArrayResize(SPosition, size_need_position + 1);
            SPosition[size_need_position].pos_type = POSITION_TYPE_BUY;
            if(InpPrintLogo)
               Print(__FILE__, " ", __FUNCTION__, ", OK: ", "Signal BUY");
            return(true);
           }
        }
      else
        {
         if(InpTradeMode != buy)
           {
            ArrayResize(SPosition, size_need_position + 1);
            SPosition[size_need_position].pos_type = POSITION_TYPE_SELL;
            if(InpPrintLogo)
               Print(__FILE__, " ", __FUNCTION__, ", OK: ", "Signal SELL");
            return(true);
           }
        }
     }
//---
   if((sell_1 || sell_2) && ( sell_3 || sell_4) )
     {
      if(!InpRevers)
        {
         if(InpTradeMode != buy)
           {
            ArrayResize(SPosition, size_need_position + 1);
            SPosition[size_need_position].pos_type = POSITION_TYPE_SELL;
            if(InpPrintLogo)
               Print(__FILE__, " ", __FUNCTION__, ", OK: ", "Signal SELL");
            return(true);
           }
        }
      else
        {
         if(InpTradeMode != sell)
           {
            ArrayResize(SPosition, size_need_position + 1);
            SPosition[size_need_position].pos_type = POSITION_TYPE_BUY;
            if(InpPrintLogo)
               Print(__FILE__, " ", __FUNCTION__, ", OK: ", "Signal BUY");
            return(true);
           }
        }
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
//| Checks if the specified filling mode is allowed                  |
//+------------------------------------------------------------------+
bool IsFillingTypeAllowed(string symbol, int fill_type)
  {
   int filling = (int)SymbolInfoInteger(symbol, SYMBOL_FILLING_MODE);
   return ((filling & fill_type) == fill_type);
  }
//+------------------------------------------------------------------+
//| Calculate all volumes                                            |
//+------------------------------------------------------------------+
double CalculateAllVolumes(void)
  {
   double volumnes = 0.0;
   for(int i = PositionsTotal() - 1; i >= 0; i--)
      if(m_position.SelectByIndex(i)) // selects the position by index for further access to its properties
         if(m_position.Symbol() == m_symbol.Name())
            volumnes += m_position.Volume();
//---
   return(volumnes);
  }
//+------------------------------------------------------------------+
//| Is position exists                                               |
//+------------------------------------------------------------------+
bool IsPositionExists(void)
  {
   for(int i = PositionsTotal() - 1; i >= 0; i--)
      if(m_position.SelectByIndex(i)) // selects the position by index for further access to its properties
         if(m_position.Symbol() == m_symbol.Name() && m_position.Magic() == InpMagic)
            return(true);
//---
   return(false);
  }
//+------------------------------------------------------------------+
//| Close all positions                                              |
//+------------------------------------------------------------------+
void CloseAllPositions(void)
  {
   double freeze = 0.0, stops = 0.0;
   FreezeStopsLevels(freeze, stops);
   /*
   SYMBOL_TRADE_FREEZE_LEVEL shows the distance of freezing the trade operations
      for pending orders and open positions in points
   ------------------------|--------------------|--------------------------------------------
   Type of order/position  |  Activation price  |  Check
   ------------------------|--------------------|--------------------------------------------
   Buy Limit order         |  Ask               |  Ask-OpenPrice  >= SYMBOL_TRADE_FREEZE_LEVEL
   Buy Stop order          |  Ask               |  OpenPrice-Ask  >= SYMBOL_TRADE_FREEZE_LEVEL
   Sell Limit order        |  Bid               |  OpenPrice-Bid  >= SYMBOL_TRADE_FREEZE_LEVEL
   Sell Stop order         |  Bid               |  Bid-OpenPrice  >= SYMBOL_TRADE_FREEZE_LEVEL
   Buy position            |  Bid               |  TakeProfit-Bid >= SYMBOL_TRADE_FREEZE_LEVEL
                           |                    |  Bid-StopLoss   >= SYMBOL_TRADE_FREEZE_LEVEL
   Sell position           |  Ask               |  Ask-TakeProfit >= SYMBOL_TRADE_FREEZE_LEVEL
                           |                    |  StopLoss-Ask   >= SYMBOL_TRADE_FREEZE_LEVEL
   ------------------------------------------------------------------------------------------
   */
   for(int i = PositionsTotal() - 1; i >= 0; i--) // returns the number of current positions
      if(m_position.SelectByIndex(i)) // selects the position by index for further access to its properties
         if(m_position.Symbol() == m_symbol.Name() && m_position.Magic() == InpMagic)
           {
            if(m_position.PositionType() == POSITION_TYPE_BUY)
              {
               bool take_profit_level = (m_position.TakeProfit() != 0.0 && m_position.TakeProfit() - m_position.PriceCurrent() >= freeze) || m_position.TakeProfit() == 0.0;
               bool stop_loss_level = (m_position.StopLoss() != 0.0 && m_position.PriceCurrent() - m_position.StopLoss() >= freeze) || m_position.StopLoss() == 0.0;
               if(take_profit_level && stop_loss_level)
                  if(!m_trade.PositionClose(m_position.Ticket())) // close a position by the specified m_symbol
                     if(InpPrintLogo)
                        Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "BUY PositionClose ", m_position.Ticket(), ", ", m_trade.ResultRetcodeDescription());
              }
            if(m_position.PositionType() == POSITION_TYPE_SELL)
              {
               bool take_profit_level = (m_position.TakeProfit() != 0.0 && m_position.PriceCurrent() - m_position.TakeProfit() >= freeze) || m_position.TakeProfit() == 0.0;
               bool stop_loss_level = (m_position.StopLoss() != 0.0 && m_position.StopLoss() - m_position.PriceCurrent() >= freeze) || m_position.StopLoss() == 0.0;
               if(take_profit_level && stop_loss_level)
                  if(!m_trade.PositionClose(m_position.Ticket())) // close a position by the specified m_symbol
                     if(InpPrintLogo)
                        Print(__FILE__, " ", __FUNCTION__, ", ERROR: ", "SELL PositionClose ", m_position.Ticket(), ", ", m_trade.ResultRetcodeDescription());
              }
           }
  }
//+------------------------------------------------------------------+
//| Profit all positions                                             |
//+------------------------------------------------------------------+
double ProfitAllPositions(void)
  {
   double profit = 0.0;
   for(int i = PositionsTotal() - 1; i >= 0; i--)
      if(m_position.SelectByIndex(i)) // selects the position by index for further access to its properties
         if(m_position.Symbol() == m_symbol.Name() && m_position.Magic() == InpMagic)
            profit += m_position.Commission() + m_position.Swap() + m_position.Profit();
//---
   return(profit);
  }
//+------------------------------------------------------------------+
//| TimeControl                                                      |
//+------------------------------------------------------------------+
bool TimeControlHourMinute(void)
  {
   if(!input_time_control)
      return(true);
   MqlDateTime STimeCurrent;
   datetime time_current=TimeCurrent();
   if(time_current==D'1970.01.01 00:00')
      return(false);
   TimeToStruct(time_current,STimeCurrent);
   if(STimeCurrent.day_of_week==1 && !input_use_monday)
      return(false);
   if(STimeCurrent.day_of_week==2 && !input_use_tuesday)
      return(false);
   if(STimeCurrent.day_of_week==3 && !input_use_wednesday)
      return(false);
   if(STimeCurrent.day_of_week==4 && !input_use_thursday)
      return(false);
   if(STimeCurrent.day_of_week==5 && !input_use_friday)
      return(false);
   TimeToStruct(time_current,STimeCurrent);
   if((input_start_hour*60*60+input_start_minute*60)<(input_end_hour*60*60+input_end_minute*60)) // intraday time interval
     {
      /*
      Example:
      input uchar    input_start_hour      = 5;        // Start hour
      input uchar    input_end_hour        = 10;       // End hour
      0  1  2  3  4  5  6  7  8  9  10 11 12 13 14 15 16 17 18 19 20 21 22 23 0  1  2  3  4  5  6  7  8  9  10 11 12 13 14 15
      _  _  _  _  _  +  +  +  +  +  _  _  _  _  _  _  _  _  _  _  _  _  _  _  _  _  _  _  _  +  +  +  +  +  _  _  _  _  _  _
      */
      if((STimeCurrent.hour*60*60+STimeCurrent.min*60>=input_start_hour*60*60+input_start_minute*60) &&
         (STimeCurrent.hour*60*60+STimeCurrent.min*60<input_end_hour*60*60+input_end_minute*60))
         return(true);
     }
   else
      if((input_start_hour*60*60+input_start_minute*60)>(input_end_hour*60*60+input_end_minute*60)) // time interval with the transition in a day
        {
         /*
         Example:
         input uchar    input_start_hour      = 10;       // Start hour
         input uchar    input_end_hour        = 5;        // End hour
         0  1  2  3  4  5  6  7  8  9  10 11 12 13 14 15 16 17 18 19 20 21 22 23 0  1  2  3  4  5  6  7  8  9  10 11 12 13 14 15
         _  _  _  _  _  _  _  _  _  _  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  _  _  _  _  _  +  +  +  +  +  +
         */
         if(STimeCurrent.hour*60*60+STimeCurrent.min*60>=input_start_hour*60*60+input_start_minute*60 ||
            STimeCurrent.hour*60*60+STimeCurrent.min*60<input_end_hour*60*60+input_end_minute*60)
            return(true);
        }
      else
         return(false);
//---
   return(false);
  }
//+------------------------------------------------------------------+
//| Tester function                                                  |
//+------------------------------------------------------------------+
double OnTester()
  {
//--- custom criterion optimization value (the higher, the better)
   double ret = 0.0;
//--- get trade results to the array
   double array[];
   double trades_volume;
   GetTradeResultsToArray(array, trades_volume);
   int trades = ArraySize(array);
//--- if there are less than 10 trades, test yields no positive results
   if(trades < 10)
      return (0);
//--- average result per trade
   double average_pl = 0;
   for(int i = 0; i < ArraySize(array); i++)
      average_pl += array[i];
   average_pl /= trades;
//--- display the message for the single-test mode
   if(MQLInfoInteger(MQL_TESTER) && !MQLInfoInteger(MQL_OPTIMIZATION))
      PrintFormat("%s: Trades=%d, Average profit=%.2f", __FUNCTION__, trades, average_pl);
//--- calculate linear regression ratios for the profit graph
   double a, b, std_error;
   double chart[];
   if(!CalculateLinearRegression(array, chart, a, b))
      return (0);
//--- calculate the error of the chart deviation from the regression line
   if(!CalculateStdError(chart, a, b, std_error))
      return (0);
//--- calculate the ratio of trend profits to the standard deviation
   ret = (std_error == 0.0) ? a * trades : a * trades / std_error;
//--- return custom criterion optimization value
   return(ret);
  }
//+------------------------------------------------------------------+
//| Get the array of profits/losses from deals                       |
//+------------------------------------------------------------------+
bool GetTradeResultsToArray(double &pl_results[], double &volume)
  {
//--- request the complete trading history
   if(!HistorySelect(0, TimeCurrent()))
      return (false);
   uint total_deals = HistoryDealsTotal();
   volume = 0;
//--- set the initial size of the array with a margin - by the number of deals in history
   ArrayResize(pl_results, total_deals);
//--- counter of deals that fix the trading result - profit or loss
   int counter = 0;
   ulong ticket_history_deal = 0;
//--- go through all deals
   for(uint i = 0; i < total_deals; i++)
     {
      //--- select a deal
      if((ticket_history_deal = HistoryDealGetTicket(i)) > 0)
        {
         ENUM_DEAL_ENTRY deal_entry  = (ENUM_DEAL_ENTRY)HistoryDealGetInteger(ticket_history_deal, DEAL_ENTRY);
         long            deal_type   = HistoryDealGetInteger(ticket_history_deal, DEAL_TYPE);
         double          deal_profit = HistoryDealGetDouble(ticket_history_deal, DEAL_PROFIT);
         double          deal_volume = HistoryDealGetDouble(ticket_history_deal, DEAL_VOLUME);
         //--- we are only interested in trading operations
         if((deal_type != DEAL_TYPE_BUY) && (deal_type != DEAL_TYPE_SELL))
            continue;
         //--- only deals that fix profits/losses
         if(deal_entry != DEAL_ENTRY_IN)
           {
            //--- write the trading result to the array and increase the counter of deals
            pl_results[counter] = deal_profit;
            volume += deal_volume;
            counter++;
           }
        }
     }
//--- set the final size of the array
   ArrayResize(pl_results, counter);
   return (true);
  }
//+------------------------------------------------------------------+
//| Calculate the linear regression y=a*x+b                          |
//+------------------------------------------------------------------+
bool CalculateLinearRegression(double  &change[], double &chartline[],
                               double  &a_coef, double  &b_coef)
  {
//--- check for data sufficiency
   if(ArraySize(change) < 3)
      return (false);
//--- create a chart array with an accumulation
   int N = ArraySize(change);
   ArrayResize(chartline, N);
   chartline[0] = change[0];
   for(int i = 1; i < N; i++)
      chartline[i] = chartline[i - 1] + change[i];
//--- now, calculate regression ratios
   double x = 0, y = 0, x2 = 0, xy = 0;
   for(int i = 0; i < N; i++)
     {
      x = x + i;
      y = y + chartline[i];
      xy = xy + i * chartline[i];
      x2 = x2 + i * i;
     }
   a_coef = (N * xy - x * y) / (N * x2 - x * x);
   b_coef = (y - a_coef * x) / N;
//---
   return (true);
  }
//+------------------------------------------------------------------+
//|  Calculate mean-square deviation error for specified a and b     |
//+------------------------------------------------------------------+
bool  CalculateStdError(double  &data[], double  a_coef, double  b_coef, double &std_err)
  {
//--- sum of error squares
   double error = 0;
   int N = ArraySize(data);
   if(N <= 2)
      return (false);
   for(int i = 0; i < N; i++)
      error += MathPow(a_coef * i + b_coef - data[i], 2);
   std_err = MathSqrt(error / (N - 2));
//---
   return (true);
  }
//+------------------------------------------------------------------+
//+---------------------------End Of Code----------------------------+
//+------------------------------------------------------------------+