//+------------------------------------------------------------------+
//|                                            FileUnlimitedTest.mq5 |
//+------------------------------------------------------------------+
#property copyright "TheXpert"

#include <TheXpert/FileUnlimited.mqh>
#include <TheXpert/StringUtils.mqh>

#define CP_UTF16 1200

void OnStart()
{
   string name = "TheXpert\\Test.txt";
   string path = TerminalInfoString(TERMINAL_DATA_PATH) + "\\MQL5\\Files\\" + name;
   
   int hFile = FileOpen(name, FILE_WRITE | FILE_TXT, ' ', CP_UTF16);
   if (hFile == INVALID_HANDLE)
   {
      Print("File not opened.");
      return;
   }
   
   bool writeBool = false, readBool = true;
   long writeLong = -4369549, readLong = 0;
   double writeDouble = -4369549.245, readDouble = 0;
   datetime writeDatetime = 2596824987, readDatetime = 0;
   color writeColor = Blue, readColor = White;
   string writeString = "2r4i6bf4wb9tb69vw", readString = "";
   
   
   FileWrite(hFile, writeBool);
   FileWrite(hFile, writeLong);
   FileWrite(hFile, writeDouble);
   FileWrite(hFile, writeDatetime);
   FileWrite(hFile, writeColor);
   FileWrite(hFile, writeString);

   FileClose(hFile);
   
   ConstFile* file = OpenConstFile(path);
   if (CheckPointer(file) != POINTER_INVALID)
   {
      file.Read(readBool);
      Print("readBool = ", readBool);

      file.Read(readLong);
      Print("readLong = ", readLong);

      file.Read(readDouble);
      Print("readDouble = ", readDouble);

      file.Read(readDatetime);
      Print("readDatetime = ", readDatetime);

      file.Read(readColor);
      Print("readColor = ", readColor);

      file.Read(readString);
      Print("readString = ", readString);
      
      delete file;
   }
   else
   {
      Print("Failed to open ConstFile at path -- ", path);
   }
}