//+------------------------------------------------------------------+
//|                                             Blau_Ergodic_CMI.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp." // copyright
#property link      "http://www.mql5.com"                       // URL
#property description "Ergodic CMI-Oscillator (William Blau)"   // description
#include <WilliamBlau.mqh>                 // include file (terminal_data_folder\MQL5\Include)
//--- indicator settings
#property indicator_separate_window        // indicator in a separate window
#property indicator_buffers 12             // number of buffers used
#property indicator_plots   2              // number of graphic plots
//--- horizontal levels
#property indicator_level1 -25             // level #0
#property indicator_level2 25              // level #1
#property indicator_levelcolor Silver      // level line color
#property indicator_levelstyle STYLE_DOT   // level line style
#property indicator_levelwidth 1           // level line width
//--- scale
#property indicator_minimum -100           // lower bound
#property indicator_maximum 100            // upper bound
//--- graphic plot #0 (Main)
#property indicator_label1  "Ergodic"      // label of graphic plot #0
#property indicator_type1   DRAW_HISTOGRAM // draw as a histogram
#property indicator_color1  Silver         // histogram color
#property indicator_style1  STYLE_SOLID    // histogram style
#property indicator_width1  2              // histogram width
//--- graphic plot #1 (Signal Line)
#property indicator_label2  "Signal"       // label of graphic plot #1
#property indicator_type2   DRAW_LINE      // draw as a line
#property indicator_color2  Red            // line color
#property indicator_style2  STYLE_SOLID    // line style
#property indicator_width2  1              // line width
//--- input parameters
input int    q=1;  // q - period of Candlestick Momentum
input int    r=20; // r - 1st EMA, applied to Candlestick Momentum
input int    s=5;  // s - 2nd EMA, applied to the 1st smoothing
input int    u=3;  // u - 3rd EMA, applied to the 2nd smoothing
input int    ul=3; // ul - period of a Signal Line
input ENUM_APPLIED_PRICE AppliedPrice1=PRICE_CLOSE; // AppliedPrice1 - price type [close]
input ENUM_APPLIED_PRICE AppliedPrice2=PRICE_OPEN;  // AppliedPrice2 - price type [open]
//--- dynamic arrays
double MainBuffer[];         // Ergodic line (graphic plot #0)
double SignalBuffer[];       // Signal Line: EMA(ul), applied to Ergodic (graphic plot #1)
double Price1Buffer[];       // price array [close]
double Price2Buffer[];       // price array [open]
double CMtmBuffer[];         // q-period Candlestick Momentum
double EMA_CMtmBuffer[];     // r-period 1st EMA
double DEMA_CMtmBuffer[];    // s-period 2nd EMA
double TEMA_CMtmBuffer[];    // u-period 3rd EMA
double AbsCMtmBuffer[];      // q-period Candlestick Momentum (absolute value)
double EMA_AbsCMtmBuffer[];  // r-period 1st EMA (absolute value)
double DEMA_AbsCMtmBuffer[]; // s-period 2nd EMA (absolute value)
double TEMA_AbsCMtmBuffer[]; // u-period 3rd EMA (absolute value)
//--- global variable
int    begin1, begin2, begin3, begin4, begin5; // starting index
int    rates_total_min; // rates total min
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers
   // graphic plot #0
   SetIndexBuffer(0,MainBuffer,INDICATOR_DATA);                  // Ergodic
   // graphic plot #1
   SetIndexBuffer(1,SignalBuffer,INDICATOR_DATA);                // Signal Line: EMA(ul), applied to Ergodic
   // buffers for intermediate calculations
   SetIndexBuffer(2,Price1Buffer,INDICATOR_CALCULATIONS);        // price array [close]
   SetIndexBuffer(3,Price2Buffer,INDICATOR_CALCULATIONS);        // price array [open]
   SetIndexBuffer(4,CMtmBuffer,INDICATOR_CALCULATIONS);          // q-period Candlestick Momentum
   SetIndexBuffer(5,EMA_CMtmBuffer,INDICATOR_CALCULATIONS);      // r-period 1st EMA
   SetIndexBuffer(6,DEMA_CMtmBuffer,INDICATOR_CALCULATIONS);     // s-period 2nd EMA
   SetIndexBuffer(7,TEMA_CMtmBuffer,INDICATOR_CALCULATIONS);     // u-period 3rd EMA
   SetIndexBuffer(8,AbsCMtmBuffer,INDICATOR_CALCULATIONS);       // q-period Candlestick Momentum (absolute value)
   SetIndexBuffer(9,EMA_AbsCMtmBuffer,INDICATOR_CALCULATIONS);   // r-period 1st EMA (absolute value)
   SetIndexBuffer(10,DEMA_AbsCMtmBuffer,INDICATOR_CALCULATIONS); // s-period 2nd EMA (absolute value)
   SetIndexBuffer(11,TEMA_AbsCMtmBuffer,INDICATOR_CALCULATIONS); // u-period 3rd EMA (absolute value)
/*
//--- graphic plot #0 (Main)
   PlotIndexSetString(0,PLOT_LABEL,"Ergodic");           // label of graphic plot #0
   PlotIndexSetInteger(0,PLOT_DRAW_TYPE,DRAW_HISTOGRAM); // draw as a histogram
   PlotIndexSetInteger(0,PLOT_LINE_COLOR,Silver);        // histogram color
   PlotIndexSetInteger(0,PLOT_LINE_STYLE,STYLE_SOLID);   // histogram line style
   PlotIndexSetInteger(0,PLOT_LINE_WIDTH,2);             // histogram line width
//--- graphic plot #1 (Signal Line)
   PlotIndexSetString(1,PLOT_LABEL,"Signal");            // label of graphic plot #1
   PlotIndexSetInteger(1,PLOT_DRAW_TYPE,DRAW_LINE);      // draw as a line
   PlotIndexSetInteger(1,PLOT_LINE_COLOR,Red);           // line color
   PlotIndexSetInteger(1,PLOT_LINE_STYLE,STYLE_SOLID);   // line style
   PlotIndexSetInteger(1,PLOT_LINE_WIDTH,1);             // line width
*/
//--- precision
   IndicatorSetInteger(INDICATOR_DIGITS,2);
/*
//--- horizontal levels
   IndicatorSetInteger(INDICATOR_LEVELS,2);                // number of levels
   IndicatorSetDouble(INDICATOR_LEVELVALUE,0,-25);         // level #0
   IndicatorSetDouble(INDICATOR_LEVELVALUE,1,25);          // level #1
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,Silver);       // level line color
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,STYLE_DOT);    // level line style
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,1);            // level line width
   IndicatorSetString(INDICATOR_LEVELTEXT,0,"Oversold");   // description of level #0 "Oversold"
   IndicatorSetString(INDICATOR_LEVELTEXT,1,"Overbought"); // description of level #1 "Overbought"
//--- scale
   IndicatorSetDouble(INDICATOR_MINIMUM,-100); // lower bound
   IndicatorSetDouble(INDICATOR_MAXIMUM,100);  // upper bound
*/
//---
   begin1=q-1;         //                                    - CMtmBuffer[], AbsCMtmBuffer[]
   begin2=begin1+r-1;  // or =(q-1)+(r-1)                    - EMA_...[]
   begin3=begin2+s-1;  // or =(q-1)+(r-1)+(s-1)              - DEMA_...[]
   begin4=begin3+u-1;  // or =(q-1)+(r-1)+(s-1)+(u-1)        - TEMA_...[], MainBuffer[]
   begin5=begin4+ul-1; // or =(q-1)+(r-1)+(s-1)+(u-1)+(ul-1) - SignalBuffer[]
   //
   rates_total_min=begin5+1; // rates total min
//--- starting bar index for graphic plot #0
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,begin4);
//--- starting bar index for graphic plot #1
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,begin5);
//--- short indicator name
   string shortname=PriceName(AppliedPrice1)+","+PriceName(AppliedPrice2)+","+string(q)+","+string(r)+","+string(s)+","+string(u)+","+string(ul);
   IndicatorSetString(INDICATOR_SHORTNAME,"Blau_Ergodic_CMI("+shortname+")");
//--- OnInit done
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(
                const int rates_total,     // rates total
                const int prev_calculated, // number of bars, calculated at previous call
                const datetime &Time[],    // Time
                const double &Open[],      // Open
                const double &High[],      // High
                const double &Low[],       // Low
                const double &Close[],     // Close
                const long &TickVolume[],  // Tick Volume
                const long &Volume[],      // Real Volume
                const int &Spread[]        // Spread
               )
  {
   int i,pos;
   double value1,value2;
//--- check rates
   if(rates_total<rates_total_min) return(0);
//--- calculation of Price1Buffer[] and Price2Buffer[]
   CalculatePriceBuffer(
                        AppliedPrice1,       // applied price [close]
                        rates_total,         // rates total
                        prev_calculated,     // number of bars, calculated at previous call
                        Open,High,Low,Close, // Open[], High[], Low[], Close[]
                        Price1Buffer         // target array
                       );
   CalculatePriceBuffer(AppliedPrice2,rates_total,prev_calculated,Open,High,Low,Close,Price2Buffer);
//--- calculation of cmtm and |cmtm|
   if(prev_calculated==0)      // at first call
     {
      pos=begin1;              // 
      for(i=0;i<pos;i++)       // 
        {
         CMtmBuffer[i]=0.0;    // zero values
         AbsCMtmBuffer[i]=0.0; //
        }
     }
   else pos=prev_calculated-1; // overwise calculate only last value
   // calculation of CMtmBuffer[] and AbsCMtmBuffer[]
   for(i=pos;i<rates_total;i++)
     {
      CMtmBuffer[i]=Price1Buffer[i]-Price2Buffer[i-(q-1)];
      AbsCMtmBuffer[i]=MathAbs(CMtmBuffer[i]);
     }
//--- EMA smoothing
   // r-period 1st EMA
   ExponentialMAOnBufferWB(
                           rates_total,     // rates total
                           prev_calculated, // number of bars, calculated at previous call
                           begin1,          // starting index
                           r,               // smoothing period
                           CMtmBuffer,      // input array
                           EMA_CMtmBuffer   // target array
                          );
   ExponentialMAOnBufferWB(rates_total,prev_calculated,begin1,r,AbsCMtmBuffer,EMA_AbsCMtmBuffer);
   // s-period 2nd EMA
   ExponentialMAOnBufferWB(rates_total,prev_calculated,begin2,s,EMA_CMtmBuffer,DEMA_CMtmBuffer);
   ExponentialMAOnBufferWB(rates_total,prev_calculated,begin2,s,EMA_AbsCMtmBuffer,DEMA_AbsCMtmBuffer);
   // u-period 3rd EMA
   ExponentialMAOnBufferWB(rates_total,prev_calculated,begin3,u,DEMA_CMtmBuffer,TEMA_CMtmBuffer);
   ExponentialMAOnBufferWB(rates_total,prev_calculated,begin3,u,DEMA_AbsCMtmBuffer,TEMA_AbsCMtmBuffer);
//--- calculation of Ergodic (graphic plot #0)
   if(prev_calculated==0)      // at first call
     {
      pos=begin4;              // 
      for(i=0;i<pos;i++)       // 
         MainBuffer[i]=0.0;    // zero values
     }
   else pos=prev_calculated-1; // overwise calculate only last value
   // calculation of MainBuffer[]
   for(i=pos;i<rates_total;i++)
     {
      value1=100*TEMA_CMtmBuffer[i];
      value2=TEMA_AbsCMtmBuffer[i];
      MainBuffer[i]=(value2>0)?value1/value2:0;
     }
//--- calculation of a Signal Line (graphic plot #1)
   ExponentialMAOnBufferWB(rates_total,prev_calculated,begin4,ul,MainBuffer,SignalBuffer);
//--- OnCalculate done. Return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+