//+------------------------------------------------------------------+
//|                                                    Functions.mqh |
//|                                    2019-2021, dimitri pecheritsa |
//|                                         mql5.com/en/users/dmipec |
//|------------------------------------------------------------------|
//|   f| introsort example                                           |
//| 005| enum sort order                                             |
//| 010| array sort (keys[<>], algorithm, order, prn)                |
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//| 005| enum sort order parameter                                   |
//+------------------------------------------------------------------+
enum ENUM_SORT_ORDER
  {
   SORT_ORDER_ACCENDING,
   SORT_ORDER_DESCENDING
  };
//+------------------------------------------------------------------+
//| 010| sort keys with a sorting algorithm                          |
//|  ->| keys     | array which values are compared and sorted       |
//|  ->| algorithm| any compatible sorting algorithm                 |
//|  ->| order    | sorting order flag                               |
//+------------------------------------------------------------------+
#include <Mqh\Algorithms\ASorter.mqh>
template<typename TKey>
void ArraySort(TKey& keys[],ASorter<TKey,TKey>* algorithm,ENUM_SORT_ORDER order)
  {
   if(!CheckPointer(algorithm))
      return;
//--- prepare algorithm
   ArrayCopy(algorithm.keys,keys);
//--- sort keys
   algorithm.Sort();
//--- save sorted items
   ArrayCopy(keys,algorithm.keys);
//--- keep order
   if(order==SORT_ORDER_DESCENDING)
      ArrayReverse(keys);
//--- clear
   if(CheckPointer(algorithm)==POINTER_DYNAMIC)
      delete algorithm;
  }
//+------------------------------------------------------------------+
