//+------------------------------------------------------------------+
//|                                                      ASorter.mqh |
//|                                    2019-2021, dimitri pecheritsa |
//|                                         mql5.com/en/users/dmipec |
//|------------------------------------------------------------------|
//|   c| generic abstract parent of various sorting algorithms       |
//|  <>| keys | generic array                                        |
//|  <>| items| generic array. items swap like keys at the same time,|
//|but only keys are compared to each other. in other words items are|
//|sorted by keys, which may come handy in variuos circumstances     |
//|  <-| sort | point of entry for sorting                           |
//|  <-| name | of algorithm                                         |
//+------------------------------------------------------------------+
template<typename TKey,typename TItem>
class ASorter
  {
public:
   TKey              keys[];
   TItem             items[];
                     ASorter(void) {}
                    ~ASorter(void) {}
   virtual void      Sort(void)=0;
   virtual string    Name(void)=0;
protected:
   virtual void      Swap(int a,int b);
  };
//+------------------------------------------------------------------+
//| default swap implementation that fits most concrete algorithms.  |
//|children may redefine it or ignore. items will swap indexes if its|
//|length matches keys                                               |
//|  ->| a| first index for swapping                                 |
//|  ->| b| second index for swapping                                |
//+------------------------------------------------------------------+
template<typename TKey,typename TItem>
void ASorter::Swap(int a,int b)
  {
//--- swap keys at indexes a and b
   TKey key=keys[a];
   keys[a]=keys[b];
   keys[b]=key;
//--- stop if items are not symchronized with keys
   if(ArraySize(items)!=ArraySize(keys))
      return;
//--- swap same items indexes
   TItem item=items[a];
   items[a]=items[b];
   items[b]=item;
  }
//+------------------------------------------------------------------+
