//+------------------------------------------------------------------+
//|                                              CompareFunction.mqh |
//|                                    2019-2021, dimitri pecheritsa |
//|                                         mql5.com/en/users/dmipec |
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//| overloads                                                        |
//+------------------------------------------------------------------+
//| 01 | compare bool (x, y)                                         |
//| 02 | compare char (x, y)                                         |
//| 03 | compare uchar (x, y)                                        |
//| 04 | compare short (x, y)                                        |
//| 05 | compare ushort (x, y)                                       |
//| 06 | compare color x, y)                                         |
//| 07 | compare int (x, y)                                          |
//| 08 | compare uint (x, y)                                         |
//| 09 | compare datetime (x, y)                                     |
//| 10 | compare long (x, y)                                         |
//| 11 | compare ulong (x, y)                                        |
//| 12 | compare float (x, y)                                        |
//| 13 | compare double (x, y)                                       |
//| 14 | compare string (x, y)                                       |
//| 15 | compare custom (x, y)                                       |
//| 16 | compare custom (x, y, comparer)                             |
//+------------------------------------------------------------------+
//|  [use] a universal overloaded compare method for all standard    |
//|mql types. returns 1 if x greater than y, -1 if x less than y,    |
//|and 0 if x and y are equal. custom compare methods rely on two    |
//|interfaces: comparable and comparer                               |
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//| 01 | compare                                                     |
//+------------------------------------------------------------------+
//|  [in] x, y: bool                                                 |
//|  [ret] -1 less / 0 equal / 1 greater, by comparing x to y        |
//+------------------------------------------------------------------+
int Compare(const bool x,const bool y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| 02 | compare                                                     |
//+------------------------------------------------------------------+
//|  [in] x, y: char                                                 |
//|  [ret] -1 less / 0 equal / 1 greater, by comparing x to y        |
//+------------------------------------------------------------------+
int Compare(const char x,const char y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| 03 | compare                                                     |
//+------------------------------------------------------------------+
//|  [in] x, y: uchar                                                |
//|  [ret] -1 less / 0 equal / 1 greater, by comparing x to y        |
//+------------------------------------------------------------------+
int Compare(const uchar x,const uchar y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| 04 | compare                                                     |
//+------------------------------------------------------------------+
//|  [in] x, y: short                                                |
//|  [ret] -1 less / 0 equal / 1 greater, by comparing x to y        |
//+------------------------------------------------------------------+
int Compare(const short x,const short y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| 05 | compare                                                     |
//+------------------------------------------------------------------+
//|  [in] x, y: ushort                                               |
//|  [ret] -1 less / 0 equal / 1 greater, by comparing x to y        |
//+------------------------------------------------------------------+
int Compare(const ushort x,const ushort y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| 06 | compare                                                     |
//+------------------------------------------------------------------+
//|  [in] x, y: color                                                |
//|  [ret] -1 less / 0 equal / 1 greater, by comparing x to y        |
//+------------------------------------------------------------------+
int Compare(const color x,const color y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| 07 | compare                                                     |
//+------------------------------------------------------------------+
//|  [in] x, y: int                                                  |
//|  [ret] -1 less / 0 equal / 1 greater, by comparing x to y        |
//+------------------------------------------------------------------+
int Compare(const int x,const int y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| 08 | compare                                                     |
//+------------------------------------------------------------------+
//|  [in] x, y: uint                                                 |
//|  [ret] -1 less / 0 equal / 1 greater, by comparing x to y        |
//+------------------------------------------------------------------+
int Compare(const uint x,const uint y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| 09 | compare                                                     |
//+------------------------------------------------------------------+
//|  [in] x, y: datetime                                             |
//|  [ret] -1 less / 0 equal / 1 greater, by comparing x to y        |
//+------------------------------------------------------------------+
int Compare(const datetime x,const datetime y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| 10 | compare                                                     |
//+------------------------------------------------------------------+
//|  [in] x, y: long                                                 |
//|  [ret] -1 less / 0 equal / 1 greater, by comparing x to y        |
//+------------------------------------------------------------------+
int Compare(const long x,const long y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| 11 | compare                                                     |
//+------------------------------------------------------------------+
//|  [in] x, y: ulong                                                |
//|  [ret] -1 less / 0 equal / 1 greater, by comparing x to y        |
//+------------------------------------------------------------------+
int Compare(const ulong x,const ulong y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| 12 | compare                                                     |
//+------------------------------------------------------------------+
//|  [in] x, y: float                                                |
//|  [in] digits: floating point accuracy, default 13                |
//|  [ret] -1 less / 0 equal / 1 greater, by comparing the           |
//|difference between x and y with some minimum value, where the     |
//|user sets the number of 'digits' after the floating point for     |
//|this minimum value                                                |
//+------------------------------------------------------------------+
int Compare(const float x,const float y,int digits=13)
  {
   double min=pow(10,-fabs(digits));
   return (((fabs(x-y)<min))? 0 : ((x-y>=min))? 1 : -1);
  }
//+------------------------------------------------------------------+
//| 13 | compare                                                     |
//+------------------------------------------------------------------+
//|  [in] x, y: double                                               |
//|  [in] digits: floating point accuracy, default 13                |
//|  [ret] -1 less / 0 equal / 1 greater, by comparing the           |
//|difference between x and y with some minimum value, where the     |
//|user sets the number of 'digits' after the floating point for     |
//|this minimum value                                                |
//+------------------------------------------------------------------+
int Compare(const double x,const double y,int digits=13)
  {
   double min=pow(10,-fabs(digits));
   return (((fabs(x-y)<min))? 0 : ((x-y>=min))? 1 : -1);
  }
//+------------------------------------------------------------------+
//| 14 | compare                                                     |
//+------------------------------------------------------------------+
//|  [in] x, y: string                                               |
//|  [ret] -1 less / 0 equal / 1 greater, by comparing x to y        |
//+------------------------------------------------------------------+
int Compare(const string x,const string y)
  {
   return (x>y) ? 1 : (x<y) ? -1 : 0;
  }
//+------------------------------------------------------------------+
//| interface comparable                                             |
//+------------------------------------------------------------------+
template<typename T>
interface IComparable
  {
   int       Compare(T value);
  };
//+------------------------------------------------------------------+
//| 15 | compare                                                     |
//+------------------------------------------------------------------+
//|  [in] x, y: custom                                               |
//|  [ret] -1 less / 0 equal / 1 greater, by comparing custom object |
//|x to y, by casting one of them to a comparable object             |
//+------------------------------------------------------------------+
template<typename T>
int Compare(T x,T y)
  {
//--- try to convert to a comparable object
   IComparable<T>*comparable=dynamic_cast<IComparable<T>*>(x);
   return (comparable)?
//--- use the specified compare method
          comparable.Compare(y):
//--- unknown compare function
          int("nan");
  }
//+------------------------------------------------------------------+
//| interface comparer                                               |
//+------------------------------------------------------------------+
template<typename T>
interface IComparer
  {
   int       Compare(T x,T y);
  };
//+------------------------------------------------------------------+
//| 16 | compare                                                     |
//+------------------------------------------------------------------+
//|  [in] x, y: custom                                               |
//|  [in] comparer: an external compatible comparer                  |
//|  [ret] -1 less / 0 equal / 1 greater, by comparing custom object |
//|x to y by using the external 'comparer'. if comparer is invalid   |
//|returns nan, which means an error                                 |
//+------------------------------------------------------------------+
template<typename T>
int Compare(T x,T y,IComparer* comparer)
  {
//--- avoid invalid pointer
   if(CheckPointer(comparer)==0)
      return int("nan");
//--- use the proposed comparer
   return comparer.Compare(x,y);
  }
//+------------------------------------------------------------------+
