//+------------------------------------------------------------------+
//|                                                      ASorter.mqh |
//|                                    2019-2021, dimitri pecheritsa |
//|                                         mql5.com/en/users/dmipec |
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//| template abstract sorter class                                   |
//+------------------------------------------------------------------+
//|  [use] a common class for various descending sorting algorithms  |
//|  [in/out] keys: main array which contains values of any type     |
//|that must be sorted.                                              |
//|  [in/out] items: an array which can be of the same type as the   |
//|'keys' but it does not have to. 'items' mimic the swapping        |
//|procedures executed with the 'keys', however it doesn't           |
//|participate in the comparisons or the algorithm steps. as a       |
//|result the 'items' will get sorted by the elements of the keys    |
//|array. this may come handy in variuos circumstances.              |
//|  [method] sort: pure virtual and must be defined by children     |
//|classes.                                                          |
//+------------------------------------------------------------------+
template<typename TKey,typename TItem>
class ASorter
  {
public:
   TKey              keys[];
   TItem             items[];
                     ASorter(void) {}
                    ~ASorter(void) {}
   virtual void      Sort(void)=0;
protected:
   virtual void      Swap(int a,int b);
  };
//+------------------------------------------------------------------+
//| swap                                                             |
//+------------------------------------------------------------------+
//|  [in] a: first index for swapping                                |
//|  [in] b: second index for swapping                               |
//|  [ret] void. a default implementation of a virtual swapping      |
//|method of keys (and items) at indexes a and b, applicable to most |
//|concrete algorithms, where it can be used as is. however,         |
//|children may redefine this method, if they decide that it is      |
//|unfit for their use, or just ignore this method altogether.       |
//|  the items array participates in swapping if its length matches  |
//|the length of the keys, otherwise it is ignored, thus only the    |
//|keys will eventually get sorted                                   |
//+------------------------------------------------------------------+
template<typename TKey,typename TItem>
void ASorter::Swap(int a,int b)
  {
//--- swap keys at indexes a and b
   TKey key=keys[a];
   keys[a]=keys[b];
   keys[b]=key;
//--- check if items exist
   if(ArraySize(items)!=ArraySize(keys))
      return;
//--- swap items at the same indexes
   TItem item=items[a];
   items[a]=items[b];
   items[b]=item;
  }
//+------------------------------------------------------------------+
