//+------------------------------------------------------------------+
//|                                                      Element.mqh |
//|                                    2019-2020, dimitri pecheritsa |
//|                                                 792112@gmail.com |
//+------------------------------------------------------------------+
interface Visitor;
class Element
  {
protected:
   Visitor*          m_visitor;
public:
                    ~Element(void);
   virtual void      Accept(Visitor* visitor)=0;
protected:
   void              Switch(Visitor* visitor);
  };


//+------------------------------------------------------------------+
//| destructor                                                       |
//+------------------------------------------------------------------+
Element::~Element(void)
  {
   if(CheckPointer(m_visitor)==1)
      delete m_visitor;
  }


//+------------------------------------------------------------------+
//| switch                                                           |
//+------------------------------------------------------------------+
void Element::Switch(Visitor *visitor)
  {
   if(CheckPointer(m_visitor)==1)
      delete m_visitor;
   m_visitor=visitor;
  }
  
  
//+------------------------------------------------------------------+
