//+------------------------------------------------------------------+
//|                                                  SubjectPull.mqh |
//|                                    2019-2020, dimitri pecheritsa |
//|                                                 792112@gmail.com |
//+------------------------------------------------------------------+
#include "ObserverPull.mqh"

class Subject
  {
public:
                    ~Subject(void);

   void              Attach(Observer* observer);
   void              Detach(Observer& observer);
   void              Notify(void);

protected:
   Observer*         m_observers[];

   int               Find(Observer& observer);
  };


//+------------------------------------------------------------------+
//|                                                       destructor |
//+------------------------------------------------------------------+
Subject::~Subject(void)
  {
   int itotal=ArraySize(m_observers);
   for(int i=0; i<itotal; i++)
     {
      Observer* item=m_observers[i];
      if(CheckPointer(item)==1)
         delete item;
     }
  }


//+------------------------------------------------------------------+
//|                                                           notify |
//+------------------------------------------------------------------+
void Subject::Notify(void)
  {
   int total=ArraySize(m_observers);
   for(int i=0; i<total; i++)
     {
      Print("observer ",m_observers[i]," pulling state from subject...");
      m_observers[i].Update();
     }
  }


//+------------------------------------------------------------------+
//|                                                           attach |
//+------------------------------------------------------------------+
void Subject::Attach(Observer* observer)
  {
   int size=ArraySize(m_observers);
   ArrayResize(m_observers,size+1);
   m_observers[size]=observer;
  }


//+------------------------------------------------------------------+
//|                                                           detach |
//+------------------------------------------------------------------+
void Subject::Detach(Observer &observer)
  {
   int find=Find(observer);
   if(find==-1)
      return;
   Observer* item=m_observers[find];
   if(CheckPointer(item)==1)
      delete item;
   ArrayRemove(m_observers,find,1);
  }


//+------------------------------------------------------------------+
//|                                                             find |
//+------------------------------------------------------------------+
int Subject::Find(Observer &observer)
  {
   int itotal=ArraySize(m_observers);
   for(int i=0; i<itotal; i++)
     {
      Observer* item=m_observers[i];
      if(item==&observer)
         return i;
     }
   return -1;
  }

//+------------------------------------------------------------------+
