//+------------------------------------------------------------------+
//|                                                201021_104755.mqh |
//|                                    2019-2020, dimitri pecheritsa |
//|                                                 792112@gmail.com |
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//| concrete aggregate                                               |
//+------------------------------------------------------------------+
//   implements the iterator creation interface to return an instance
// of the proper concrete iterator
//---
#include <Mqh\201021_104329.mqh> //aggregate
#include <Mqh\201021_104101.mqh> //iterator
#include <Mqh\201021_104505.mqh> //concrete iterator
//---
class ConcreteAggregate:public Aggregate<string>
  {
public:
   Iterator<string>* CreateIterator(void);
   //---
   int               Count(void);
   void              operator+=(string item);
   string            operator[](int at);
protected:
   string            m_items[];
  };
//+------------------------------------------------------------------+
//| create iterator                                                  |
//+------------------------------------------------------------------+
Iterator<string>* ConcreteAggregate::CreateIterator(void)
  {
   return new ConcreteIterator<string>(this);
  }
//+------------------------------------------------------------------+
//| add item                                                         |
//+------------------------------------------------------------------+
void ConcreteAggregate::operator+=(string item)
  {
   int size=ArraySize(m_items);
   ArrayResize(m_items,size+1);
   m_items[size]=item;
  }
//+------------------------------------------------------------------+
//| access item                                                      |
//+------------------------------------------------------------------+
string ConcreteAggregate::operator[](int at)
  {
   return m_items[at];
  }
//+------------------------------------------------------------------+
//| count                                                            |
//+------------------------------------------------------------------+
int ConcreteAggregate::Count()
  {
   return ArraySize(m_items);
  }
//+------------------------------------------------------------------+
