//+------------------------------------------------------------------+
//|                                                201021_104505.mqh |
//|                                    2019-2020, dimitri pecheritsa |
//|                                                 792112@gmail.com |
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//| concrete iterator                                                |
//+------------------------------------------------------------------+
//   implements the iterator interface
//   keeps track of the current position in the traversal of the aggregate
//---
#include <Mqh\201021_104101.mqh> //iterator
#include <Mqh\201021_104329.mqh> //aggregate
#define ERR_ITERATOR_OUT_OF_BOUNDS 1
//---
template<typename T>
class ConcreteIterator:public Iterator<T>
  {
public:
   void              First(void);
   void              Next(void);
   bool              IsDone(void);
   T                 CurrentItem(void);
                     ConcreteIterator(Aggregate<T>&);
protected:
   Aggregate<T>*     m_aggregate;
   int               m_current;
  };
//+------------------------------------------------------------------+
//| constructor                                                      |
//+------------------------------------------------------------------+
template<typename T> ConcreteIterator::ConcreteIterator(Aggregate<T>& aggregate):
   m_aggregate(&aggregate),
   m_current(0)
  {
  }
//+------------------------------------------------------------------+
//| first                                                            |
//+------------------------------------------------------------------+
template<typename T>
void ConcreteIterator::First(void)
  {
   m_current=0;
   Print("first iteration of aggregate");
  }
//+------------------------------------------------------------------+
//| next                                                             |
//+------------------------------------------------------------------+
template<typename T>
void ConcreteIterator::Next(void)
  {
   m_current++;
   if(!IsDone())
     {
      Print("next iteration of aggregate");
     }
  }
//+------------------------------------------------------------------+
//| is done                                                          |
//+------------------------------------------------------------------+
template<typename T>
bool ConcreteIterator::IsDone(void)
  {
   return m_current>=m_aggregate.Count();
  }
//+------------------------------------------------------------------+
//| current item                                                     |
//+------------------------------------------------------------------+
template<typename T>
string ConcreteIterator::CurrentItem(void)
  {
   if(IsDone())
     {
      SetUserError(ERR_ITERATOR_OUT_OF_BOUNDS);
      return NULL;
     }
   return m_aggregate[m_current];
  }
//+------------------------------------------------------------------+
