//+------------------------------------------------------------------+
//|                                             PatternOrganizer.mqh |
//|                                    2019-2020, dimitri pecheritsa |
//|                                                 792112@gmail.com |
//+------------------------------------------------------------------+
//| 23 design patterns                                               |
//+------------------------------------------------------------------+
//   design patterns: elements of reusable object-oriented software
//   gof > erich gamma, richard helm, ralph johnson, john vlissides 
//   published in 1994
//+------------------------------------------------------------------+
//| classification                                                   |
//+------------------------------------------------------------------+
//   purpose > creational > 5
//      abstract factory, builder, factory method, prototype, singleton
//   purpose > structural > 7
//      adapter, bridge, composite, decorator, facade, flyweight, proxy
//   purpose > behavioral > 11
//      chain of responsibility, command, interpreter, iterator, mediator
//      memento, observer, state, strategy, template method, visitor
//   scope > class > 3 > factory method, interpreter, template method
//   scope > object > 20 > all other
//+------------------------------------------------------------------+
//| relationships                                                    |
//+------------------------------------------------------------------+
//
//                       +-------------->|memento|      |proxy|
//                       |                   ^           |adapter|
//                  saving state             |            |bridge |
//                  of iteration          avoiding
//                       |               hysteresis
//    |builder|      |iterator|<---+         |        |   chain of   |
//        ^              ^         |     |command|    |responsibility|
//        |              |         |         |               |
//     creating     enumerating    |      composed        defining
//    composites      children     |       using         the chain
//        |              |         |         |               |
//        +---------|composite|<---|---------+---------------+
//        |              |         |                         |
//     adding            |     defining------------+      defining
// responsibilities      |    traversals           |      grammar
//   to objects          |                         |         |
//        |              +--------adding------>|visitor|     |
//        v              |      operations                   |
//   |decorator|      sharing       |                        |
//        ^          composites     +--------|interpreter|---+
//        |              |                         |
//        |              v             sharing     |
//  changing skin     |flyweight|<-----terminal----+
//    vs. guts               ^         symbols          |observer|
//        |       sharing    |                              |
//        |     strategies---+---sharing                    |
//        v          |           states                  complex
//   |strategy|------+             |     |mediator|<----dependency
//        ^                     |state|                 management
//        |
//     sharing
//   algorithm's----------|template method|----often uses---+
//      steps                                               |
//                                                          |
//   |prototype|<--+                                        |
//                 |                                        v
//         configure factory          implement---->|factory method|
//            dynamically               using
//                 |                      |
//         |abstract factory|---+---------+
//                              |
//                           single
//   |singleton|<-----------instance------------|facade|
//
//+------------------------------------------------------------------+
//| code refactoring                                                 |
//+------------------------------------------------------------------+
//   create objects < explicitly > create indirectly
//      abstract factory, factory method, prototype
//   dependence > specific operations > avoid > hard-coded requests
//      chain of responsibility, command
//   dependence > hardware and software > limit 
//      abstract factory, bridge
//   dependence > object representations/implementations
//      hide from clients > keep changes from cascading
//      abstract factory, bridge, memento, proxy
//   algorithmic dependencies > isolate > algorithms that may change
//      builder, iterator, strategy, template method, visitor
//   tight coupling > decouple < abstract coupling and layering
//      abstract factory, bridge, chain of responsibility,
//      command, facade, mediator, observer
//   extending functionality < subclassing 
//      composition/delegation > combine behavior
//      bridge, chain of responsibility, composite, decorator,
//      observer, strategy
//   inability to alter classes conveniently > adapter, decorator, visitor
//+------------------------------------------------------------------+
//| interface for patterns                                           |
//+------------------------------------------------------------------+
interface ClientExample //pattern client
  {
   string Output(void); //returns header
   void Run(void); //execute the pattern client
  };
//+------------------------------------------------------------------+
//| interface for patterns                                           |
//+------------------------------------------------------------------+
void Run(ClientExample* client) //launches a pattern
  {
   printf("---\n%s",client.Output()); //print pattern header
   client.Run(); //execute client collaborations
   delete client; //exit
  }
//+------------------------------------------------------------------+
//| include > patterns                                               |
//+------------------------------------------------------------------+
namespace Structural
{
#include "Structural\Composite.mqh"
}
//+------------------------------------------------------------------+
