//---collection of 23 design patterns---------------------------------
//---purpose > creational > 5
//   abstract factory, builder, factory method, prototype, singleton
//---purpose > structural > 7
//   adapter, bridge, composite, decorator, facade, flyweight, proxy
//---purpose > behavioral > 11
//   chain of responsibility, command, interpreter, iterator, mediator,
//   memento, observer, state, strategy, template method, visitor
//---scope > class > 3 > factory method, interpreter, template method
//---scope > object > 20 > all other
//---structural > adapter---------------------------------------------
//   convert one interface into another expected interface
//   classes with incompatible interfaces can work together
//---structural > adapter > class adapter
//   
//   |Client|------>| Target  |         |     Adaptee     |
//                  |---------|         |-----------------|
//                  |Request()|         |SpecificRequest()|
//                       ^                       ^
//                       |                       |
//                       +--------+    +---------+
//                                |    | implementation
//                        |      Adapter      |
//                        |-------------------|
//                        |Request()          |
//                        | SpecificRequest() |
//
//---structural > adapter > object adapter
//   
//   |Client|----->|  Target |            +-->|     Adaptee     |
//                 |---------|            |   |-----------------|
//                 |Request()|            |   |SpecificRequest()|
//                      ^                 |
//                      |                 |
//        |          Adapter          |---+
//        |---------------------------|
//        |Request()                  |
//        | adaptee.SpecificRequest() |
//   
//---patterns > load
#include "PatternOrganizer.mqh"
//---structural > run-------------------------------------------------
void OnStart() //launch pattern clients one by one and check result
  {
   Run(new Structural::AdapterClass::Client);
   Run(new Structural::AdapterObject::Client);
  }
//---Structural::AdapterClass::Client::Output-------------------------
//   Operation requested from adapter: re-directing to adaptee...
//   Adaptee is executing the specific request
//---Structural::AdapterObject::Client::Output------------------------
//   Operation requested: Now re-directing to...
//   Specific Request
//+------------------------------------------------------------------+
