//+------------------------------------------------------------------+
//|                                                     LSTMTest.mq5 |
//|                       Copyright 2018, Mukachi Financial Services |
//|                                              https://www.mfs.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2018, Mukachi Financial Services"
#property link      "https://www.mfs.com"
#property version   "1.00"
//+------------------------------------------------------------------+
#include <Machine Learning\LSTMNetwork\LSTMNetwork.mqh>
//+------------------------------------------------------------------+
int rpc_handle=INVALID_HANDLE;
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
   int inputs=1;
   int patterns=1;
   int timesteps=21;
   int slope_period=14;

   rpc_handle=iCustom(Symbol(),Period(),"Simple RPC",
                      slope_period,PRICE_CLOSE);

   if(rpc_handle==INVALID_HANDLE)
     {
      Print("Failed to create Simple RPC");
      return;
     }

   double in[];
   double rpc[];
   
   int copied=timesteps*2;
   
   ArrayResize(in,inputs*timesteps);
   ArrayInitialize(in,0.0);

   double norm_rpc[];
   
   ArrayResize(norm_rpc,copied);
   ArrayInitialize(norm_rpc,0.0);

   double tg[];
   ArrayResize(tg,timesteps);
   ArrayInitialize(tg,0.0);

   if(CopyBuffer(rpc_handle,2,1,copied,rpc)==copied)
     {
      double max=rpc[ArrayMaximum(rpc)];
      double min=rpc[ArrayMinimum(rpc)];

      for(int i=0;i<copied;i++)
         norm_rpc[i]=(rpc[i]-min)/(max-min);

      int count=0;

      for(int t=0;t<timesteps;t++)
        {
         for(int i=0;i<inputs;i++)
           {
            double slope=lr_slope(slope_period,norm_rpc,t);
            in[count++]=norm_rpc[t+1];
            tg[t]=norm_rpc[t];
           }
        }
     }

   Print("\nLearning started ....");

   double mse=1.0e-8;

   CLSTMNetwork *net=new CLSTMNetwork(patterns,inputs,timesteps);

   net.Learn(in,tg,mse,500000);

   Print("MSE = ",net.MSE());
   Print("Epochs = ",net.Epochs());
   Print("Out = ",net.Calculate(in));

   IndicatorRelease(rpc_handle);

   delete(net);
  }
//+------------------------------------------------------------------+
//| Linear regression slope                                          |
//+------------------------------------------------------------------+
double lr_slope(int period,double &x[],int bar)
  {
   double sum=0.0;
   double wsum=0.0;
   int lookback=period+bar-1;

   int size=ArraySize(x);

   for(int i=lookback;i>=bar;i--)
     {
      sum+=x[i];
      wsum+=x[i]*(period+1-i);
     }
   double lrs1;
   lrs1=6.*(2.*wsum/(period+1)/sum-1.)/(period-1); // normalize to SMA
//---lrs=6.*(1.0-(period+1)*sum/2./wsum)/(period-1); // normalize to LWMA
   return(lrs1*100000.); // convert to parts period 100k
  }
//+------------------------------------------------------------------+
