//+------------------------------------------------------------------+
//|                           Williams_Accumulation_Distribution.mq5 |
//|                      Copyright  2007, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright  2007, MetaQuotes Software Corp."
//---    
#property link      "http://www.metaquotes.net"
//---   
#property version   "1.00"
//---     
#property indicator_separate_window
//---   
#property indicator_buffers 1
//---     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//---     
#property indicator_type1   DRAW_LINE
//---        LightSeaGreen 
#property indicator_color1 clrLightSeaGreen
//---   -  
#property indicator_style1  STYLE_SOLID
//---     2
#property indicator_width1  2
//---   
#property indicator_label1  "Williams_Accumulation_Distribution"
//+-----------------------------------+
//|         |
//+-----------------------------------+                  
input int Shift=0; //      
//+-----------------------------------+
//---   ,   
//---      
double IndBuffer[];
//---      
int  min_rates_total;
//+------------------------------------------------------------------+    
//| Williams_Accumulation_Distribution indicator initialization      |
//+------------------------------------------------------------------+  
void OnInit()
  {
//---     
   min_rates_total=2;
//---      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//---       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"Williams_Accumulation_Distribution");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
  }
//+------------------------------------------------------------------+  
//| Williams_Accumulation_Distribution iteration function            |
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(0);
//---   
   int first,bar;
   double TRH,TRL,AD;
//---
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      first=min_rates_total; //      
      IndBuffer[first-1]=close[first-1];
     }
   else first=prev_calculated-1; //      
//---    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      TRH=MathMax(high[bar],close[bar-1]);
      TRL=MathMin(low[bar],close[bar-1]);
      if(close[bar]>close[bar-1]+_Point) AD=close[bar]-TRL;
      else if(close[bar]<close[bar-1]-_Point) AD=close[bar]-TRH;
      else AD=0;      
      IndBuffer[bar]=IndBuffer[bar-1]+AD;
     }
//---+    
   return(rates_total);
  }
//+------------------------------------------------------------------+
