//+------------------------------------------------------------------+
//|                                              TradeAlgorithms.mqh |
//|                               Copyright  2012, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "2011,   Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.10"
//+------------------------------------------------------------------+
//|                     |
//+------------------------------------------------------------------+  
class CIsNewBar
  {
   //----
public:
   //----      
   bool IsNewBar(string symbol,ENUM_TIMEFRAMES timeframe)
     {
      //----     
      datetime TNew=datetime(SeriesInfoInteger(symbol,timeframe,SERIES_LASTBAR_DATE));

      if(TNew!=m_TOld && TNew) //     
        {
         m_TOld=TNew;
         return(true); //   !
        }
      //----
      return(false); //    !
     };

   //----      
                     CIsNewBar(){m_TOld=-1;};

protected: datetime m_TOld;
   //---- 
  };
//+==================================================================+
//|                                      |
//+==================================================================+

//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+
bool BuyPositionOpen
(
 bool &BUY_Signal,           //    
 const string symbol,        //   
 const datetime &TimeLevel,  // ,        
 double Money_Management,    // MM
 int Margin_Mode,            //    
 uint deviation,             // 
 int StopLoss,               //   
 int Takeprofit              //   
 )
//BuyPositionOpen(BUY_Signal,symbol,TimeLevel,Money_Management,deviation,Margin_Mode,StopLoss,Takeprofit);
  {
//----
   if(!BUY_Signal) return(true);

   ENUM_POSITION_TYPE PosType=POSITION_TYPE_BUY;
//----           
   if(!TradeTimeLevelCheck(symbol,PosType,TimeLevel)) return(true);

//----      
   if(PositionSelect(symbol)) return(true);

//----
   double volume=BuyLotCount(symbol,Money_Management,Margin_Mode,StopLoss,deviation);
   if(volume<=0)
     {
      Print(__FUNCTION__,"():      ");
      return(false);
     }

//----        
   MqlTradeRequest request;
   MqlTradeResult result;
//----       
   MqlTradeCheckResult check;

//----  
   ZeroMemory(request);
   ZeroMemory(result);
   ZeroMemory(check);
//----
   int digit=int(SymbolInfoInteger(symbol,SYMBOL_DIGITS));
   double point=SymbolInfoDouble(symbol,SYMBOL_POINT);
   double Ask=SymbolInfoDouble(symbol,SYMBOL_ASK);
   if(!digit || !point || !Ask) return(true);

//----     MqlTradeRequest   BUY 
   request.type   = ORDER_TYPE_BUY;
   request.price  = Ask;
   request.action = TRADE_ACTION_DEAL;
   request.symbol = symbol;
   request.volume = volume;

//----        
   if(StopLoss)
     {
      if(!StopCorrect(symbol,StopLoss))return(false);
      double dStopLoss=StopLoss*point;
      request.sl=NormalizeDouble(request.price-dStopLoss,digit);
     }
   else request.sl=0.0;

//----       
   if(Takeprofit)
     {
      if(!StopCorrect(symbol,Takeprofit))return(false);
      double dTakeprofit=Takeprofit*point;
      request.tp=NormalizeDouble(request.price+dTakeprofit,digit);
     }
   else request.tp=0.0;

//----
   request.deviation=deviation;
   request.type_filling=ORDER_FILLING_FOK;

//----     
   if(!OrderCheck(request,check))
     {
      Print(__FUNCTION__,"():      !");
      Print(__FUNCTION__,"(): OrderCheck(): ",ResultRetcodeDescription(check.retcode));
      return(false);
     }

   string comment="";
   StringConcatenate(comment,"<<< ============ ",__FUNCTION__,"():  Buy   ",symbol," ============ >>>");
   Print(comment);

//----  BUY       
   if(!OrderSend(request,result) || result.retcode!=TRADE_RETCODE_DONE)
     {
      Print(__FUNCTION__,"():   !");
      Print(__FUNCTION__,"(): OrderSend(): ",ResultRetcodeDescription(result.retcode));
      return(false);
     }
   else
   if(result.retcode==TRADE_RETCODE_DONE)
     {
      TradeTimeLevelSet(symbol,PosType,TimeLevel);
      BUY_Signal=false;
      comment="";
      //StringConcatenate(comment,"<<< ============ ",__FUNCTION__,"(): Buy   ",symbol,"  ============ >>>");
      //Print(comment);
     }
   else
     {
      Print(__FUNCTION__,"():   !");
      Print(__FUNCTION__,"(): OrderSend(): ",ResultRetcodeDescription(result.retcode));
     }
//----
   return(true);
  }
//+------------------------------------------------------------------+
//|                                          |
//+------------------------------------------------------------------+
bool SellPositionOpen
(
 bool &SELL_Signal,          //    
 const string symbol,        //   
 const datetime &TimeLevel,  // ,        
 double Money_Management,    // MM
 int Margin_Mode,            //    
 uint deviation,             // 
 int StopLoss,               //   
 int Takeprofit              //   
 )
//SellPositionOpen(SELL_Signal,symbol,TimeLevel,Money_Management,deviation,Margin_Mode,StopLoss,Takeprofit);
  {
//----
   if(!SELL_Signal) return(true);

   ENUM_POSITION_TYPE PosType=POSITION_TYPE_SELL;
//----           
   if(!TradeTimeLevelCheck(symbol,PosType,TimeLevel)) return(true);

//----      
   if(PositionSelect(symbol)) return(true);

//----
   double volume=BuyLotCount(symbol,Money_Management,Margin_Mode,StopLoss,deviation);
   if(volume<=0)
     {
      Print(__FUNCTION__,"():      ");
      return(false);
     }

//----        
   MqlTradeRequest request;
   MqlTradeResult result;
//----       
   MqlTradeCheckResult check;

//----  
   ZeroMemory(request);
   ZeroMemory(result);
   ZeroMemory(check);
//----
   int digit=int(SymbolInfoInteger(symbol,SYMBOL_DIGITS));
   double point=SymbolInfoDouble(symbol,SYMBOL_POINT);
   double Bid=SymbolInfoDouble(symbol,SYMBOL_BID);
   if(!digit || !point || !Bid) return(true);

//----     MqlTradeRequest   BUY 
   request.type   = ORDER_TYPE_SELL;
   request.price  = Bid;
   request.action = TRADE_ACTION_DEAL;
   request.symbol = symbol;
   request.volume = volume;

//----        
   if(StopLoss!=0)
     {
      if(!StopCorrect(symbol,StopLoss))return(false);
      double dStopLoss=StopLoss*point;
      request.sl=NormalizeDouble(request.price+dStopLoss,digit);
     }
   else request.sl=0.0;

//----       
   if(Takeprofit!=0)
     {
      if(!StopCorrect(symbol,Takeprofit))return(false);
      double dTakeprofit=Takeprofit*point;
      request.tp=NormalizeDouble(request.price-dTakeprofit,digit);
     }
   else request.tp=0.0;
//----
   request.deviation=deviation;
   request.type_filling=ORDER_FILLING_FOK;

//----     
   if(!OrderCheck(request,check))
     {
      Print(__FUNCTION__,"():      !");
      Print(__FUNCTION__,"(): OrderCheck(): ",ResultRetcodeDescription(check.retcode));
      return(false);
     }

   string comment="";
   StringConcatenate(comment,"<<< ============ ",__FUNCTION__,"():  Sell   ",symbol," ============ >>>");
   Print(comment);

//----  SELL       
   if(!OrderSend(request,result) || result.retcode!=TRADE_RETCODE_DONE)
     {
      Print(__FUNCTION__,"():   !");
      Print(__FUNCTION__,"(): OrderSend(): ",ResultRetcodeDescription(result.retcode));
      return(false);
     }
   else
   if(result.retcode==TRADE_RETCODE_DONE)
     {
      TradeTimeLevelSet(symbol,PosType,TimeLevel);
      SELL_Signal=false;
      comment="";
      //StringConcatenate(comment,"<<< ============ ",__FUNCTION__,"(): Sell   ",symbol,"  ============ >>>");
      //Print(comment);
     }
   else
     {
      Print(__FUNCTION__,"():   !");
      Print(__FUNCTION__,"(): OrderSend(): ",ResultRetcodeDescription(result.retcode));
     }
//----
   return(true);
  }
//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+
bool BuyPositionOpen
(
 bool &BUY_Signal,           //    
 const string symbol,        //   
 const datetime &TimeLevel,  // ,        
 double Money_Management,    // MM
 int Margin_Mode,            //    
 uint deviation,             // 
 double dStopLoss,           //     
 double dTakeprofit          //     
 )
//BuyPositionOpen(BUY_Signal,symbol,TimeLevel,Money_Management,deviation,Margin_Mode,StopLoss,Takeprofit);
  {
//----
   if(!BUY_Signal) return(true);

   ENUM_POSITION_TYPE PosType=POSITION_TYPE_BUY;
//----           
   if(!TradeTimeLevelCheck(symbol,PosType,TimeLevel)) return(true);

//----      
   if(PositionSelect(symbol)) return(true);

//----        
   MqlTradeRequest request;
   MqlTradeResult result;
//----       
   MqlTradeCheckResult check;

//----  
   ZeroMemory(request);
   ZeroMemory(result);
   ZeroMemory(check);
//----
   int digit=int(SymbolInfoInteger(symbol,SYMBOL_DIGITS));
   double point=SymbolInfoDouble(symbol,SYMBOL_POINT);
   double Ask=SymbolInfoDouble(symbol,SYMBOL_ASK);
   if(!digit || !point || !Ask) return(false);

//----          
   if(!dStopCorrect(symbol,dStopLoss,dTakeprofit,PosType)) return(false);
   int StopLoss=int((Ask-dStopLoss)/point);
//----
   double volume=BuyLotCount(symbol,Money_Management,Margin_Mode,StopLoss,deviation);
   if(volume<=0)
     {
      Print(__FUNCTION__,"():      ");
      return(false);
     }

//----     MqlTradeRequest   BUY 
   request.type   = ORDER_TYPE_BUY;
   request.price  = Ask;
   request.action = TRADE_ACTION_DEAL;
   request.symbol = symbol;
   request.volume = volume;
   request.sl=dStopLoss;
   request.tp=dTakeprofit;
   request.deviation=deviation;
   request.type_filling=ORDER_FILLING_FOK;

//----     
   if(!OrderCheck(request,check))
     {
      Print(__FUNCTION__,"():      !");
      Print(__FUNCTION__,"(): OrderCheck(): ",ResultRetcodeDescription(check.retcode));
      return(false);
     }

   string comment="";
   StringConcatenate(comment,"<<< ============ ",__FUNCTION__,"():  Buy   ",symbol," ============ >>>");
   Print(comment);

//----  BUY       
   if(!OrderSend(request,result) || result.retcode!=TRADE_RETCODE_DONE)
     {
      Print(__FUNCTION__,"():   !");
      Print(__FUNCTION__,"(): OrderSend(): ",ResultRetcodeDescription(result.retcode));
      return(false);
     }
   else
   if(result.retcode==TRADE_RETCODE_DONE)
     {
      TradeTimeLevelSet(symbol,PosType,TimeLevel);
      BUY_Signal=false;
      comment="";
      //StringConcatenate(comment,"<<< ============ ",__FUNCTION__,"(): Buy   ",symbol,"  ============ >>>");
      //Print(comment);
     }
   else
     {
      Print(__FUNCTION__,"():   !");
      Print(__FUNCTION__,"(): OrderSend(): ",ResultRetcodeDescription(result.retcode));
     }
//----
   return(true);
  }
//+------------------------------------------------------------------+
//|                                          |
//+------------------------------------------------------------------+
bool SellPositionOpen
(
 bool &SELL_Signal,          //    
 const string symbol,        //   
 const datetime &TimeLevel,  // ,        
 double Money_Management,    // MM
 int Margin_Mode,            //    
 uint deviation,             // 
 double dStopLoss,           //     
 double dTakeprofit          //     
 )
//SellPositionOpen(SELL_Signal,symbol,TimeLevel,Money_Management,deviation,Margin_Mode,StopLoss,Takeprofit);
  {
//----
   if(!SELL_Signal) return(true);

   ENUM_POSITION_TYPE PosType=POSITION_TYPE_SELL;
//----           
   if(!TradeTimeLevelCheck(symbol,PosType,TimeLevel)) return(true);

//----      
   if(PositionSelect(symbol)) return(true);

//----        
   MqlTradeRequest request;
   MqlTradeResult result;
//----       
   MqlTradeCheckResult check;

//----  
   ZeroMemory(request);
   ZeroMemory(result);
   ZeroMemory(check);
//----
   int digit=int(SymbolInfoInteger(symbol,SYMBOL_DIGITS));
   double point=SymbolInfoDouble(symbol,SYMBOL_POINT);
   double Bid=SymbolInfoDouble(symbol,SYMBOL_BID);
   if(!digit || !point || !Bid) return(true);

//----          
   if(!dStopCorrect(symbol,dStopLoss,dTakeprofit,PosType)) return(false);
   int StopLoss=int((dStopLoss-Bid)/point);
//----
   double volume=SellLotCount(symbol,Money_Management,Margin_Mode,StopLoss,deviation);
   if(volume<=0)
     {
      Print(__FUNCTION__,"():      ");
      return(false);
     }

//----     MqlTradeRequest   BUY 
   request.type   = ORDER_TYPE_SELL;
   request.price  = Bid;
   request.action = TRADE_ACTION_DEAL;
   request.symbol = symbol;
   request.volume = volume;
   request.deviation=deviation;
   request.type_filling=ORDER_FILLING_FOK;

//----     
   if(!OrderCheck(request,check))
     {
      Print(__FUNCTION__,"(): OrderCheck():      !");
      Print(__FUNCTION__,"(): OrderCheck(): ",ResultRetcodeDescription(check.retcode));
      return(false);
     }

   string comment="";
   StringConcatenate(comment,"<<< ============ ",__FUNCTION__,"():  Sell   ",symbol," ============ >>>");
   Print(comment);

//----  SELL       
   if(!OrderSend(request,result) || result.retcode!=TRADE_RETCODE_DONE)
     {
      Print(__FUNCTION__,"(): OrderSend():   !");
      Print(__FUNCTION__,"(): OrderSend(): ",ResultRetcodeDescription(result.retcode));
      return(false);
     }
   else
   if(result.retcode==TRADE_RETCODE_DONE)
     {
      TradeTimeLevelSet(symbol,PosType,TimeLevel);
      SELL_Signal=false;
      comment="";
      //StringConcatenate(comment,"<<< ============ ",__FUNCTION__,"(): Sell   ",symbol,"  ============ >>>");
      //Print(comment);
     }
   else
     {
      Print(__FUNCTION__,"(): OrderSend():   !");
      Print(__FUNCTION__,"(): OrderSend(): ",ResultRetcodeDescription(result.retcode));
     }
//----
   return(true);
  }
//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+
bool BuyPositionClose
(
 bool &Signal,         //    
 const string symbol,  //   
 uint deviation        // 
 )
  {
//----
   if(!Signal) return(true);

//----        
   MqlTradeRequest request;
   MqlTradeResult result;
//----       
   MqlTradeCheckResult check;

//----  
   ZeroMemory(request);
   ZeroMemory(result);
   ZeroMemory(check);

//----     BUY 
   if(PositionSelect(symbol))
     {
      if(PositionGetInteger(POSITION_TYPE)!=POSITION_TYPE_BUY) return(false);
     }
   else return(false);

//----     
   double volume=PositionGetDouble(POSITION_VOLUME);
   double MaxLot=SymbolInfoDouble(symbol,SYMBOL_VOLUME_MAX);
   double Bid=SymbolInfoDouble(symbol,SYMBOL_BID);
   if(!volume || !MaxLot || !Bid) return(false);

//----             
   if(volume>MaxLot) volume=MaxLot;

//----     MqlTradeRequest   BUY 
   request.type   = ORDER_TYPE_SELL;
   request.price  = Bid;
   request.action = TRADE_ACTION_DEAL;
   request.symbol = symbol;
   request.volume = volume;
   request.sl = 0.0;
   request.tp = 0.0;
   request.deviation=deviation;
   request.type_filling=ORDER_FILLING_FOK;

//----     
   if(!OrderCheck(request,check))
     {
      Print(__FUNCTION__,"():      !");
      Print(__FUNCTION__,"(): OrderCheck(): ",ResultRetcodeDescription(check.retcode));
      return(false);
     }
//----     
   string comment="";
   StringConcatenate(comment,"<<< ============ ",__FUNCTION__,"():  Buy   ",symbol," ============ >>>");
   Print(comment);

//----        
   if(!OrderSend(request,result) || result.retcode!=TRADE_RETCODE_DONE)
     {
      Print(__FUNCTION__,"():   !");
      Print(__FUNCTION__,"(): OrderSend(): ",ResultRetcodeDescription(result.retcode));
      return(false);
     }
   else
   if(result.retcode==TRADE_RETCODE_DONE)
     {
      Signal=false;
      comment="";
      //StringConcatenate(comment,"<<< ============ ",__FUNCTION__,"(): Buy   ",symbol,"  ============ >>>");
      //Print(comment);
     }
   else
     {
      Print(__FUNCTION__,"():   !");
      Print(__FUNCTION__,"(): OrderSend(): ",ResultRetcodeDescription(result.retcode));
     }
//----
   return(true);
  }
//+------------------------------------------------------------------+
//|                                          |
//+------------------------------------------------------------------+
bool SellPositionClose
(
 bool &Signal,         //    
 const string symbol,  //   
 uint deviation        // 
 )
  {
//----
   if(!Signal) return(true);

//----        
   MqlTradeRequest request;
   MqlTradeResult result;
//----       
   MqlTradeCheckResult check;

//----  
   ZeroMemory(request);
   ZeroMemory(result);
   ZeroMemory(check);

//----     BUY 
   if(PositionSelect(symbol))
     {
      if(PositionGetInteger(POSITION_TYPE)!=POSITION_TYPE_SELL)return(false);
     }
   else return(false);

//----     
   double volume=PositionGetDouble(POSITION_VOLUME);
   double MaxLot=SymbolInfoDouble(symbol,SYMBOL_VOLUME_MAX);
   double Ask=SymbolInfoDouble(symbol,SYMBOL_ASK);
   if(!volume || !MaxLot || !Ask) return(false);

//----             
   if(volume>MaxLot) volume=MaxLot;

//----     MqlTradeRequest   SELL 
   request.type   = ORDER_TYPE_BUY;
   request.price  = Ask;
   request.action = TRADE_ACTION_DEAL;
   request.symbol = symbol;
   request.volume = volume;
   request.sl = 0.0;
   request.tp = 0.0;
   request.deviation=deviation;
   request.type_filling=ORDER_FILLING_FOK;

//----     
   if(!OrderCheck(request,check))
     {
      Print(__FUNCTION__,"():      !");
      Print(__FUNCTION__,"(): OrderCheck(): ",ResultRetcodeDescription(check.retcode));
      return(false);
     }
//----    
   string comment="";
   StringConcatenate(comment,"<<< ============ ",__FUNCTION__,"():  Sell   ",symbol," ============ >>>");
   Print(comment);

//----        
   if(!OrderSend(request,result) || result.retcode!=TRADE_RETCODE_DONE)
     {
      Print(__FUNCTION__,"():   !");
      Print(__FUNCTION__,"(): OrderSend(): ",ResultRetcodeDescription(result.retcode));
      return(false);
     }
   else
   if(result.retcode==TRADE_RETCODE_DONE)
     {
      Signal=false;
     }
   else
     {
      Print(__FUNCTION__,"():   !");
      Print(__FUNCTION__,"(): OrderSend(): ",ResultRetcodeDescription(result.retcode));
      comment="";
      //StringConcatenate(comment,"<<< ============ ",__FUNCTION__,"(): Sell   ",symbol,"  ============ >>>");
      //Print(comment);
     }
//----
   return(true);
  }
//+------------------------------------------------------------------+
//|                                        |
//+------------------------------------------------------------------+
bool BuyPositionModify
(
 bool &Modify_Signal,        //   
 const string symbol,        //   
 uint deviation,             // 
 int StopLoss,               //   
 int Takeprofit              //   
 )
//BuyPositionModify(Modify_Signal,symbol,deviation,StopLoss,Takeprofit);
  {
//----
   if(!Modify_Signal) return(true);

   ENUM_POSITION_TYPE PosType=POSITION_TYPE_BUY;

//----      
   if(!PositionSelect(symbol)) return(true);

//----        
   MqlTradeRequest request;
   MqlTradeResult result;

//----       
   MqlTradeCheckResult check;

//----  
   ZeroMemory(request);
   ZeroMemory(result);
   ZeroMemory(check);
//----
   int digit=int(SymbolInfoInteger(symbol,SYMBOL_DIGITS));
   double point=SymbolInfoDouble(symbol,SYMBOL_POINT);
   double Ask=SymbolInfoDouble(symbol,SYMBOL_ASK);
   if(!digit || !point || !Ask) return(true);

//----     MqlTradeRequest   BUY 
   request.type   = ORDER_TYPE_BUY;
   request.price  = Ask;
   request.action = TRADE_ACTION_SLTP;
   request.symbol = symbol;

//----        
   if(StopLoss)
     {
      if(!StopCorrect(symbol,StopLoss))return(false);
      double dStopLoss=StopLoss*point;
      request.sl=NormalizeDouble(request.price-dStopLoss,digit);
      if(request.sl<PositionGetDouble(POSITION_SL)) request.sl=PositionGetDouble(POSITION_SL);
     }
   else request.sl=PositionGetDouble(POSITION_SL);

//----       
   if(Takeprofit)
     {
      if(!StopCorrect(symbol,Takeprofit))return(false);
      double dTakeprofit=Takeprofit*point;
      request.tp=NormalizeDouble(request.price+dTakeprofit,digit);
      if(request.tp<PositionGetDouble(POSITION_TP)) request.tp=PositionGetDouble(POSITION_TP);
     }
   else request.tp=PositionGetDouble(POSITION_TP);

//----   
   if(request.tp==PositionGetDouble(POSITION_TP) && request.sl==PositionGetDouble(POSITION_SL)) return(true);
   request.deviation=deviation;
   request.type_filling=ORDER_FILLING_FOK;

//----     
   if(!OrderCheck(request,check))
     {
      Print(__FUNCTION__,"():      !");
      Print(__FUNCTION__,"(): OrderCheck(): ",ResultRetcodeDescription(check.retcode));
      return(false);
     }

   string comment="";
   StringConcatenate(comment,"<<< ============ ",__FUNCTION__,"():  Buy   ",symbol," ============ >>>");
   Print(comment);

//----  BUY       
   if(!OrderSend(request,result) || result.retcode!=TRADE_RETCODE_DONE)
     {
      Print(__FUNCTION__,"():   !");
      Print(__FUNCTION__,"(): OrderSend(): ",ResultRetcodeDescription(result.retcode));
      return(false);
     }
   else
   if(result.retcode==TRADE_RETCODE_DONE)
     {
      Modify_Signal=false;
      comment="";
      //StringConcatenate(comment,"<<< ============ ",__FUNCTION__,"(): Buy   ",symbol,"  ============ >>>");
      //Print(comment);
     }
   else
     {
      Print(__FUNCTION__,"():   !");
      Print(__FUNCTION__,"(): OrderSend(): ",ResultRetcodeDescription(result.retcode));
     }
//----
   return(true);
  }
//+------------------------------------------------------------------+
//|                                       |
//+------------------------------------------------------------------+
bool SellPositionModify
(
 bool &Modify_Signal,        //   
 const string symbol,        //   
 uint deviation,             // 
 int StopLoss,               //   
 int Takeprofit              //   
 )
//SellPositionModify(Modify_Signal,symbol,deviation,StopLoss,Takeprofit);
  {
//----
   if(!Modify_Signal) return(true);

   ENUM_POSITION_TYPE PosType=POSITION_TYPE_SELL;

//----      
   if(!PositionSelect(symbol)) return(true);

//----        
   MqlTradeRequest request;
   MqlTradeResult result;

//----       
   MqlTradeCheckResult check;

//----  
   ZeroMemory(request);
   ZeroMemory(result);
   ZeroMemory(check);
//----
   int digit=int(SymbolInfoInteger(symbol,SYMBOL_DIGITS));
   double point=SymbolInfoDouble(symbol,SYMBOL_POINT);
   double Bid=SymbolInfoDouble(symbol,SYMBOL_BID);
   if(!digit || !point || !Bid) return(true);

//----     MqlTradeRequest   BUY 
   request.type   = ORDER_TYPE_SELL;
   request.price  = Bid;
   request.action = TRADE_ACTION_SLTP;
   request.symbol = symbol;

//----        
   if(StopLoss!=0)
     {
      if(!StopCorrect(symbol,StopLoss))return(false);
      double dStopLoss=StopLoss*point;
      request.sl=NormalizeDouble(request.price+dStopLoss,digit);
      double laststop=PositionGetDouble(POSITION_SL);
      if(request.sl>laststop && laststop) request.sl=PositionGetDouble(POSITION_SL);
     }
   else request.sl=PositionGetDouble(POSITION_SL);

//----       
   if(Takeprofit!=0)
     {
      if(!StopCorrect(symbol,Takeprofit))return(false);
      double dTakeprofit=Takeprofit*point;
      request.tp=NormalizeDouble(request.price-dTakeprofit,digit);
      double lasttake=PositionGetDouble(POSITION_TP);
      if(request.tp>lasttake && lasttake) request.tp=PositionGetDouble(POSITION_TP);
     }
   else request.tp=PositionGetDouble(POSITION_TP);

//----   
   if(request.tp==PositionGetDouble(POSITION_TP) && request.sl==PositionGetDouble(POSITION_SL)) return(true);
   request.deviation=deviation;
   request.type_filling=ORDER_FILLING_FOK;

//----     
   if(!OrderCheck(request,check))
     {
      Print(__FUNCTION__,"():      !");
      Print(__FUNCTION__,"(): OrderCheck(): ",ResultRetcodeDescription(check.retcode));
      return(false);
     }

   string comment="";
   StringConcatenate(comment,"<<< ============ ",__FUNCTION__,"():  Sell   ",symbol," ============ >>>");
   Print(comment);

//----  SELL       
   if(!OrderSend(request,result) || result.retcode!=TRADE_RETCODE_DONE)
     {
      Print(__FUNCTION__,"():   !");
      Print(__FUNCTION__,"(): OrderSend(): ",ResultRetcodeDescription(result.retcode));
      return(false);
     }
   else
   if(result.retcode==TRADE_RETCODE_DONE)
     {
      Modify_Signal=false;
      comment="";
      //StringConcatenate(comment,"<<< ============ ",__FUNCTION__,"(): Sell   ",symbol,"  ============ >>>");
      //Print(comment);
     }
   else
     {
      Print(__FUNCTION__,"():   !");
      Print(__FUNCTION__,"(): OrderSend(): ",ResultRetcodeDescription(result.retcode));
     }
//----
   return(true);
  }
//+------------------------------------------------------------------+
//| GetTimeLevelName() function                                      |
//+------------------------------------------------------------------+
string GetTimeLevelName(string symbol,ENUM_POSITION_TYPE trade_operation)
  {
//----
   string G_Name_;
//----  
   if(MQL5InfoInteger(MQL5_TESTING)
      || MQL5InfoInteger(MQL5_OPTIMIZATION)
      || MQL5InfoInteger(MQL5_DEBUGGING))
      StringConcatenate(G_Name_,"TimeLevel_",AccountInfoInteger(ACCOUNT_LOGIN),"_",symbol,"_",trade_operation,"_Test_");
   else StringConcatenate(G_Name_,"TimeLevel_",AccountInfoInteger(ACCOUNT_LOGIN),"_",symbol,"_",trade_operation);
//----
   return(G_Name_);
  }
//+------------------------------------------------------------------+
//| TradeTimeLevelCheck() function                                   |
//+------------------------------------------------------------------+
bool TradeTimeLevelCheck
(
 string symbol,
 ENUM_POSITION_TYPE trade_operation,
 datetime TradeTimeLevel
 )
  {
//----
   if(TradeTimeLevel>0)
     {
      //----    
      //    
      string G_Name_=GetTimeLevelName(symbol,trade_operation);

      //----         
      if(TimeCurrent()<GlobalVariableGet(G_Name_)) return(false);
     }
//----
   return(true);
  }
//+------------------------------------------------------------------+
//| TradeTimeLevelSet() function                                     |
//+------------------------------------------------------------------+
void TradeTimeLevelSet
(
 string symbol,
 ENUM_POSITION_TYPE trade_operation,
 datetime TradeTimeLevel
 )
  {
//----    
//    
   string G_Name_=GetTimeLevelName(symbol,trade_operation);
   GlobalVariableSet(GetTimeLevelName(symbol,trade_operation),TradeTimeLevel);
//----
  }
//+------------------------------------------------------------------+
//| TradeTimeLevelSet() function                                     |
//+------------------------------------------------------------------+
datetime TradeTimeLevelGet
(
 string symbol,
 ENUM_POSITION_TYPE trade_operation
 )
  {
//----
   return(datetime(GlobalVariableGet(GetTimeLevelName(symbol,trade_operation))));
  }
//+------------------------------------------------------------------+
//| TimeLevelGlobalVariableDel() function                            |
//+------------------------------------------------------------------+
void TimeLevelGlobalVariableDel
(
 string symbol,
 ENUM_POSITION_TYPE trade_operation
 )
  {
//----
   if(MQL5InfoInteger(MQL5_TESTING)
      || MQL5InfoInteger(MQL5_OPTIMIZATION)
      || MQL5InfoInteger(MQL5_DEBUGGING))
      GlobalVariableDel(GetTimeLevelName(symbol,trade_operation));
//----
  }
//+------------------------------------------------------------------+
//| GlobalVariableDel_() function                                    |
//+------------------------------------------------------------------+
void GlobalVariableDel_(string symbol)
  {
//----
   TimeLevelGlobalVariableDel(symbol,POSITION_TYPE_BUY);
   TimeLevelGlobalVariableDel(symbol,POSITION_TYPE_SELL);
//----
  }
//+------------------------------------------------------------------+
//|                               |  
//+------------------------------------------------------------------+
/*                                                                   |
    Margin_Mode      | 
                                                                 |
 0 - MM                                   |
 1 - MM                                       |
 2 - MM                            |
 3 - MM                              |
   - MM                        |
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
  Money_Management  ,        | 
            |
    Money_Management.                      |
*///                                                                 |
//+------------------------------------------------------------------+
double BuyLotCount_
(
 string symbol,
 double Money_Management,
 int Margin_Mode,
 int STOPLOSS,
 uint Slippage_
 )
// (string symbol, double Money_Management, int Margin_Mode, int STOPLOSS)
  {
//----
   double margin,Lot;

//---1+ ר     
   if(Money_Management<0) Lot=MathAbs(Money_Management);
   else
   switch(Margin_Mode)
     {
      //----       
      case  0:
         margin=AccountInfoDouble(ACCOUNT_FREEMARGIN)*Money_Management;
         if(!margin) return(-1);  
         Lot=GetLotForOpeningPos(symbol,POSITION_TYPE_BUY,margin);
         break;

         //----       
      case  1:
         margin=AccountInfoDouble(ACCOUNT_BALANCE)*Money_Management;
         if(!margin) return(-1); 
         Lot=GetLotForOpeningPos(symbol,POSITION_TYPE_BUY,margin); 
         break;

         //----                      
      case  2:
        {
         if(STOPLOSS<=0)
           {
            Print(__FUNCTION__,":  !!!");
            STOPLOSS=0;
           }
         if(!StopCorrect(symbol,STOPLOSS)) return(-1);
         double TICKSIZE=SymbolInfoDouble(symbol,SYMBOL_TRADE_TICK_SIZE);         
         double TICKLOSS=SymbolInfoDouble(symbol,SYMBOL_TRADE_TICK_VALUE_LOSS);
         margin=AccountInfoDouble(ACCOUNT_FREEMARGIN)*Money_Management;     
         if(!TICKSIZE || !TICKLOSS || !margin) return(-1);        
         //----         
         Lot=margin*TICKSIZE/(TICKLOSS*STOPLOSS);
         break;
        }

      //----         
      case  3:
        {
         if(STOPLOSS<=0)
           {
            Print(__FUNCTION__,":  !!!");
            STOPLOSS=0;
           }
         //---- 
         if(!StopCorrect(symbol,STOPLOSS))return(-1);
         double TICKSIZE=SymbolInfoDouble(symbol,SYMBOL_TRADE_TICK_SIZE);         
         double TICKLOSS=SymbolInfoDouble(symbol,SYMBOL_TRADE_TICK_VALUE_LOSS);
         margin=AccountInfoDouble(ACCOUNT_BALANCE)*Money_Management;        
         if(!TICKSIZE || !TICKLOSS || !margin) return(-1);        
         //----         
         Lot=margin*TICKSIZE/(TICKLOSS*STOPLOSS);
         break;
        }

      //----         
      default:
        {
         margin=AccountInfoDouble(ACCOUNT_FREEMARGIN)*Money_Management;
         if(!margin) return(-1); 
         Lot=GetLotForOpeningPos(symbol,POSITION_TYPE_BUY,margin);
        }
     }
//---1+    

//----        
   if(!LotCorrect(symbol,Lot,POSITION_TYPE_BUY)) return(-1);
//----
   return(Lot);
  }
//+------------------------------------------------------------------+
//|                               |  
//+------------------------------------------------------------------+
/*                                                                   |
    Margin_Mode      | 
                                                                 |
 0 - MM                                   |
 1 - MM                                       |
 2 - MM                            |
 3 - MM                              |
   - MM                        |
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
  Money_Management  ,        | 
            |
    Money_Management.                      |
*///                                                                 |
//+------------------------------------------------------------------+
double SellLotCount_
(
 string symbol,
 double Money_Management,
 int Margin_Mode,
 int STOPLOSS,
 uint Slippage_
 )
// (string symbol, double Money_Management, int Margin_Mode, int STOPLOSS)
  {
//----
   double margin,Lot;

//---1+ ר     
   if(Money_Management<0) Lot=MathAbs(Money_Management);
   else
   switch(Margin_Mode)
     {
      //----       
      case  0:
         margin=AccountInfoDouble(ACCOUNT_FREEMARGIN)*Money_Management;
         if(!margin) return(-1); 
         Lot=GetLotForOpeningPos(symbol,POSITION_TYPE_SELL,margin);
         break;

         //----       
      case  1:
         margin=AccountInfoDouble(ACCOUNT_BALANCE)*Money_Management;
         if(!margin) return(-1); 
         Lot=GetLotForOpeningPos(symbol,POSITION_TYPE_SELL,margin);
         break;

         //----                      
      case  2:
        {
         if(STOPLOSS<=0)
           {
            Print(__FUNCTION__,":  !!!");
            STOPLOSS=0;
           }
         //---- 
         if(!StopCorrect(symbol,STOPLOSS))return(-1);
         double TICKSIZE=SymbolInfoDouble(symbol,SYMBOL_TRADE_TICK_SIZE);         
         double TICKLOSS=SymbolInfoDouble(symbol,SYMBOL_TRADE_TICK_VALUE_LOSS);
         int SPREAD=int(SymbolInfoInteger(symbol,SYMBOL_SPREAD));
         margin=AccountInfoDouble(ACCOUNT_FREEMARGIN)*Money_Management;     
         if(!TICKSIZE || !TICKLOSS || !margin || !SPREAD) return(-1);        
         //----         
         Lot=margin*TICKSIZE/(TICKLOSS*(STOPLOSS+SPREAD));
         break;
        }

      //----         
      case  3:
        {
         if(STOPLOSS<=0)
           {
            Print(__FUNCTION__,":  !!!");
            STOPLOSS=0;
           }
         //----
         if(!StopCorrect(symbol,STOPLOSS))return(-1);
         double TICKSIZE=SymbolInfoDouble(symbol,SYMBOL_TRADE_TICK_SIZE);         
         double TICKLOSS=SymbolInfoDouble(symbol,SYMBOL_TRADE_TICK_VALUE_LOSS);
         int SPREAD=int(SymbolInfoInteger(symbol,SYMBOL_SPREAD));
         margin=AccountInfoDouble(ACCOUNT_BALANCE)*Money_Management;   
         if(!TICKSIZE || !TICKLOSS || !margin || !SPREAD) return(-1);        
         //----         
         Lot=margin*TICKSIZE/(TICKLOSS*(STOPLOSS+SPREAD));
         break;
        }

      //----         
      default:
        {
         margin=AccountInfoDouble(ACCOUNT_FREEMARGIN)*Money_Management;
         if(!margin) return(-1); 
         Lot=GetLotForOpeningPos(symbol,POSITION_TYPE_SELL,margin);
        }
     }
//---1+ 

//----        
   if(!LotCorrect(symbol,Lot,POSITION_TYPE_SELL)) return(-1);
//----
   return(Lot);
  }
//+------------------------------------------------------------------+
//|                               |   
//+------------------------------------------------------------------+
/*                                                                   |
    Margin_Mode      | 
                                                                 |
 0 - MM                                   |
 1 - MM                                       |
 2 - MM                            |
 3 - MM                              |
 4 -    0  2                                     |
 5 -    1  3                                     |
   - MM                        |
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
  Money_Management  ,        | 
            |
    Money_Management.                      |
*///                                                                 |
//+------------------------------------------------------------------+                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    //+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
double BuyLotCount
(
 string symbol,
 double Money_Management,
 int Margin_Mode,
 int STOPLOSS,
 int Slippage_
 )
// BuyLotCount(string symbol, double Money_Management, int Margin_Mode, int STOPLOSS)
  {
//----
   if(Money_Management<0) return(BuyLotCount_(symbol,Money_Management,0,0,0));
//----
   double LotA,LotB;
   int MarModeA,MarModeB;
//----
   switch(Margin_Mode)
     {
      case 4:
         MarModeA = 0;
         MarModeB = 2;
         break;
         //----
      case 5:
         MarModeA = 1;
         MarModeB = 3;
         break;
         //----                                                                 
      default: return(BuyLotCount_(symbol,Money_Management,Margin_Mode,STOPLOSS,Slippage_));
     }

   LotA=BuyLotCount_(symbol,Money_Management,MarModeA,STOPLOSS,Slippage_);
   if(LotA==-1) return(-1);
//----          
   LotB=BuyLotCount_(symbol,Money_Management,MarModeB,STOPLOSS,Slippage_);
   if(LotB==-1) return(-1);
//----              
   if(LotA<LotB)
      return(LotA);
   else return(LotB);
//----
  }
//+------------------------------------------------------------------+
//|                               |  
//+------------------------------------------------------------------+   
/*                                                                   |
    Margin_Mode      | 
                                                                 |
 0 - MM                                   |
 1 - MM                                       |
 2 - MM                            |
 3 - MM                              |
 4 -    0  2                                     |
 5 -    1  3                                     |
   - MM                        |
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
  Money_Management  ,        | 
            |
    Money_Management.                      |
*///                                                                 |
//+------------------------------------------------------------------+                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    //+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
double SellLotCount
(
 string symbol,
 double Money_Management,
 int Margin_Mode,
 int STOPLOSS,
 int Slippage_
 )
// (string symbol, double Money_Management, int Margin_Mode, int STOPLOSS)
  {
//----
   if(Money_Management<0) return(SellLotCount_(symbol,Money_Management,0,0,0));
//----
   double LotA,LotB;
   int MarModeA,MarModeB;
//----
   switch(Margin_Mode)
     {
      case 4:
         MarModeA = 0;
         MarModeB = 2;
         break;
         //----
      case 5:
         MarModeA = 1;
         MarModeB = 3;
         break;
         //----                                                                 
      default: return(SellLotCount_(symbol,Money_Management,Margin_Mode,STOPLOSS,Slippage_));
     }

   LotA=SellLotCount_(symbol,Money_Management,MarModeA,STOPLOSS,Slippage_);
   if(LotA==-1) return(-1);
//----          
   LotB=SellLotCount_(symbol,Money_Management,MarModeB,STOPLOSS,Slippage_);
   if(LotB==-1) return(-1);
//----              
   if(LotA<LotB)
      return(LotA);
   else return(LotB);
//----
  }
//+------------------------------------------------------------------+
//|            |
//+------------------------------------------------------------------+
bool StopCorrect(string symbol,int &Stop)
  {
//----
   int Extrem_Stop=int(SymbolInfoInteger(symbol,SYMBOL_TRADE_STOPS_LEVEL));
   if(!Extrem_Stop) return(false);
   if(Stop<Extrem_Stop) Stop=Extrem_Stop;
//----
   return(true);
  }
//+------------------------------------------------------------------+
//|            |
//+------------------------------------------------------------------+
bool dStopCorrect
(
 string symbol,
 double &dStopLoss,
 double &dTakeprofit,
 ENUM_POSITION_TYPE trade_operation
 )
// dStopCorrect(symbol,dStopLoss,dTakeprofit,trade_operation)
  {
//----
   if(!dStopLoss && !dTakeprofit) return(true);

   if(dStopLoss<0)
     {
      Print(__FUNCTION__,"():   !");
      return(false);
     }

   if(dTakeprofit<0)
     {
      Print(__FUNCTION__,"():   !");
      return(false);
     }

   int Stop,digit;
   double point,dStop,ExtrStop,ExtrTake;

//----       
   Stop=0;
   if(!StopCorrect(symbol,Stop))return(false);

//----
   digit=int(SymbolInfoInteger(symbol,SYMBOL_DIGITS));
   point=SymbolInfoDouble(symbol,SYMBOL_POINT);
   if(!digit || !point) return(true);
   dStop=Stop*point;

//----      
   if(trade_operation==POSITION_TYPE_BUY)
     {
      double Ask=SymbolInfoDouble(symbol,SYMBOL_ASK);
      if(!Ask) return(false);

      ExtrStop=NormalizeDouble(Ask-dStop,digit);
      ExtrTake=NormalizeDouble(Ask+dStop,digit);

      if(dStopLoss>ExtrStop) dStopLoss=ExtrStop;
      if(dTakeprofit<ExtrTake) dTakeprofit=ExtrTake;
     }

//----      
   if(trade_operation==POSITION_TYPE_SELL)
     {
      double Bid=SymbolInfoDouble(symbol,SYMBOL_BID);
      if(!Bid) return(false);

      ExtrStop=NormalizeDouble(Bid+dStop,digit);
      ExtrTake=NormalizeDouble(Bid-dStop,digit);

      if(dStopLoss<ExtrStop) dStopLoss=ExtrStop;
      if(dTakeprofit>ExtrTake) dTakeprofit=ExtrTake;
     }
//----
   return(true);
  }
//+------------------------------------------------------------------+
//|               |
//+------------------------------------------------------------------+
bool LotCorrect
(
 string symbol,
 double &Lot,
 ENUM_POSITION_TYPE trade_operation
 )
//LotCorrect(string symbol, double& Lot, ENUM_POSITION_TYPE trade_operation)
  {
//----      
   double Step=SymbolInfoDouble(symbol,SYMBOL_VOLUME_STEP);
   double MaxLot=SymbolInfoDouble(symbol,SYMBOL_VOLUME_MAX);
   double MinLot=SymbolInfoDouble(symbol,SYMBOL_VOLUME_MIN);
   if(!Step || !MaxLot || !MinLot) return(false);

//----        
   Lot=Step*MathFloor(Lot/Step);

//----      
   if(Lot<MinLot) Lot=MinLot;
//----             
   if(Lot>MaxLot) Lot=MaxLot;

//----    
   if(!LotFreeMarginCorrect(symbol,Lot,trade_operation))return(false);
//----
   return(true);
  }
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+
bool LotFreeMarginCorrect
(
 string symbol,
 double &Lot,
 ENUM_POSITION_TYPE trade_operation
 )
//(string symbol, double& Lot, ENUM_POSITION_TYPE trade_operation)
  {
//----    
   double freemargin=AccountInfoDouble(ACCOUNT_FREEMARGIN);
   if(freemargin<=0) return(false);

//----      
   double Step=SymbolInfoDouble(symbol,SYMBOL_VOLUME_STEP);
   double MaxLot=SymbolInfoDouble(symbol,SYMBOL_VOLUME_MAX);
   double MinLot=SymbolInfoDouble(symbol,SYMBOL_VOLUME_MIN);
   if(!Step || !MaxLot || !MinLot) return(false);

   double ExtremLot=GetLotForOpeningPos(symbol,trade_operation,freemargin);
//----        
   ExtremLot=Step*MathFloor(ExtremLot/Step);

   if(ExtremLot<MinLot) return(false); //      !
   if(Lot>ExtremLot) Lot=ExtremLot; //     ,    !
   if(Lot>MaxLot) Lot=MaxLot; //      
//----
   return(true);
  }
//+------------------------------------------------------------------+
//|         lot_margin    |
//+------------------------------------------------------------------+
double GetLotForOpeningPos(string symbol,ENUM_POSITION_TYPE direction,double lot_margin)
  {
//----
   double price=0.0,n_margin;
   if(direction==POSITION_TYPE_BUY)  price=SymbolInfoDouble(symbol,SYMBOL_ASK);
   if(direction==POSITION_TYPE_SELL) price=SymbolInfoDouble(symbol,SYMBOL_BID);
   if(!price) return(NULL);
   
   if(!OrderCalcMargin(ENUM_ORDER_TYPE(direction),symbol,1,price,n_margin) || !n_margin) return(0);
   double lot=lot_margin/n_margin;

//----   
   double LOTSTEP=SymbolInfoDouble(symbol,SYMBOL_VOLUME_STEP);
   double MaxLot=SymbolInfoDouble(symbol,SYMBOL_VOLUME_MAX);
   double MinLot=SymbolInfoDouble(symbol,SYMBOL_VOLUME_MIN);
   if(!LOTSTEP || !MaxLot || !MinLot) return(0);
   
//----        
   lot=LOTSTEP*MathFloor(lot/LOTSTEP);

//----      
   if(lot<MinLot) lot=0;
//----             
   if(lot>MaxLot) lot=MaxLot;
//----
   return(lot);
  }
//+------------------------------------------------------------------+
//|             |
//+------------------------------------------------------------------+
string ResultRetcodeDescription_(int retcode)
  {
   string str;
//----
   switch(retcode)
     {
      case TRADE_RETCODE_REQUOTE: str=""; break;
      case TRADE_RETCODE_REJECT: str=" "; break;
      case TRADE_RETCODE_CANCEL: str="  "; break;
      case TRADE_RETCODE_PLACED: str=" "; break;
      case TRADE_RETCODE_DONE: str=" "; break;
      case TRADE_RETCODE_DONE_PARTIAL: str="  "; break;
      case TRADE_RETCODE_ERROR: str="  "; break;
      case TRADE_RETCODE_TIMEOUT: str="    ";break;
      case TRADE_RETCODE_INVALID: str=" "; break;
      case TRADE_RETCODE_INVALID_VOLUME: str="   "; break;
      case TRADE_RETCODE_INVALID_PRICE: str="   "; break;
      case TRADE_RETCODE_INVALID_STOPS: str="   "; break;
      case TRADE_RETCODE_TRADE_DISABLED: str=" "; break;
      case TRADE_RETCODE_MARKET_CLOSED: str=" "; break;
      case TRADE_RETCODE_NO_MONEY: str="      "; break;
      case TRADE_RETCODE_PRICE_CHANGED: str=" "; break;
      case TRADE_RETCODE_PRICE_OFF: str="    "; break;
      case TRADE_RETCODE_INVALID_EXPIRATION: str="     "; break;
      case TRADE_RETCODE_ORDER_CHANGED: str="  "; break;
      case TRADE_RETCODE_TOO_MANY_REQUESTS: str="  "; break;
      case TRADE_RETCODE_NO_CHANGES: str="   "; break;
      case TRADE_RETCODE_SERVER_DISABLES_AT: str="  "; break;
      case TRADE_RETCODE_CLIENT_DISABLES_AT: str="   "; break;
      case TRADE_RETCODE_LOCKED: str="   "; break;
      case TRADE_RETCODE_FROZEN: str="   "; break;
      case TRADE_RETCODE_INVALID_FILL: str="       "; break;
      case TRADE_RETCODE_CONNECTION: str="    "; break;
      case TRADE_RETCODE_ONLY_REAL: str="     "; break;
      case TRADE_RETCODE_LIMIT_ORDERS: str="     "; break;
      case TRADE_RETCODE_LIMIT_VOLUME: str="         "; break;
      default: str=" ";
     }
//----
   return(str);
  }
//+------------------------------------------------------------------+
//|             |
//+------------------------------------------------------------------+
string ResultRetcodeDescription(int retcode)
  {
   string str;
//----
   switch(retcode)
     {
      case TRADE_RETCODE_REQUOTE: str="Requote"; break;
      case TRADE_RETCODE_REJECT: str="Request rejected"; break;
      case TRADE_RETCODE_CANCEL: str="Request canceled by      case TRADEr"; break;
      case TRADE_RETCODE_PLACED: str="Order placed"; break;
      case TRADE_RETCODE_DONE: str="Request completed"; break;
      case TRADE_RETCODE_DONE_PARTIAL: str="Only part of the request was completed"; break;
      case TRADE_RETCODE_ERROR: str="Request processing error"; break;
      case TRADE_RETCODE_TIMEOUT: str="Request canceled by timeout"; break;
      case TRADE_RETCODE_INVALID: str="Invalid request"; break;
      case TRADE_RETCODE_INVALID_VOLUME: str="Invalid volume in the request"; break;
      case TRADE_RETCODE_INVALID_PRICE: str="Invalid price in the request"; break;
      case TRADE_RETCODE_INVALID_STOPS: str="Invalid stops in the request"; break;
      case TRADE_RETCODE_TRADE_DISABLED: str="Trade is disabled"; break;
      case TRADE_RETCODE_MARKET_CLOSED: str="Market is closed"; break;
      case TRADE_RETCODE_NO_MONEY: str="There is not enough money to complete the request"; break;
      case TRADE_RETCODE_PRICE_CHANGED: str="Prices changed"; break;
      case TRADE_RETCODE_PRICE_OFF: str="There are no quotes to process the request"; break;
      case TRADE_RETCODE_INVALID_EXPIRATION: str="Invalid order expiration date in the request"; break;
      case TRADE_RETCODE_ORDER_CHANGED: str="Order state changed"; break;
      case TRADE_RETCODE_TOO_MANY_REQUESTS: str="Too frequent requests"; break;
      case TRADE_RETCODE_NO_CHANGES: str="No changes in request"; break;
      case TRADE_RETCODE_SERVER_DISABLES_AT: str="Autotrading disabled by server"; break;
      case TRADE_RETCODE_CLIENT_DISABLES_AT: str="Autotrading disabled by client terminal"; break;
      case TRADE_RETCODE_LOCKED: str="Request locked for processing"; break;
      case TRADE_RETCODE_FROZEN: str="Order or position frozen"; break;
      case TRADE_RETCODE_INVALID_FILL: str="Invalid order filling type"; break;
      case TRADE_RETCODE_CONNECTION: str="No connection with the      case TRADE server"; break;
      case TRADE_RETCODE_ONLY_REAL: str="Operation is allowed only for live accounts"; break;
      case TRADE_RETCODE_LIMIT_ORDERS: str="The number of pending orders has reached the limit"; break;
      case TRADE_RETCODE_LIMIT_VOLUME: str="The volume of orders and positions for the symbol has reached the limit"; break;
     }
//----
   return(str);
  }
//+------------------------------------------------------------------+
