//+------------------------------------------------------------------+ 
//|                                           ColorZerolagStochs.mq5 | 
//|                             Copyright  2011,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
//---  
#property copyright "Copyright  2011, Nikolay Kositsin"
//---    
#property link "farria@mail.redcom.ru"
//---   
#property version   "1.00"
//---     
#property indicator_separate_window
//---    2
#property indicator_buffers 4 
//---    
#property indicator_plots   3
//+-----------------------------------+
//|       |
//+-----------------------------------+
//---     
#property indicator_type1   DRAW_LINE
//---       - 
#property indicator_color1 SpringGreen
//---   -  
#property indicator_style1  STYLE_SOLID
//---     1
#property indicator_width1  1
//---   
#property indicator_label1 "FastTrendLine"

//---     
#property indicator_type2   DRAW_LINE
//---       - 
#property indicator_color2 BlueViolet
//---   -  
#property indicator_style2  STYLE_SOLID
//---     1
#property indicator_width2  1
//---   
#property indicator_label2 "SlowTrendLine"
//+-----------------------------------+
//|          |
//+-----------------------------------+
//---        
#property indicator_type3   DRAW_FILLING
//---           
#property indicator_color3  Blue, Red
//---   
#property indicator_label3 "ZerolagStochs"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input int    Slowing=3;
input int    smoothing=15;
input ENUM_MA_METHOD MA_Method=MODE_SMA;
input ENUM_STO_PRICE Price_field=STO_LOWHIGH;
//Signal_filling
//---
input double Factor1=0.05;
input int    Kperiod1 = 8;
input int    Dperiod1 = 3;
//---
input double Factor2=0.10;
input int    Kperiod2 = 21;
input int    Dperiod2 = 5;
//---
input double Factor3=0.16;
input int    Kperiod3 = 34;
input int    Dperiod3 = 8;
//---
input double Factor4=0.26;
input int    Kperiod4 = 55;
input int    Dperiod4 = 13;
//---
input double Factor5=0.43;
input int    Kperiod5 = 89;
input int    Dperiod5 = 21;
//+-----------------------------------+
//---      
int StartBar;
//---     
double smoothConst;
//---  
double FastBuffer[];
double SlowBuffer[];
double FastBuffer_[];
double SlowBuffer_[];
//---      
int STO1_Handle,STO2_Handle,STO3_Handle,STO4_Handle,STO5_Handle;
//+------------------------------------------------------------------+    
//| ZerolagStochs indicator initialization function                  | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---  
   smoothConst=(smoothing-1.0)/smoothing;
//--- 
   int PeriodBuffer[5];
//---   
   PeriodBuffer[0] = Kperiod1 + Dperiod1;
   PeriodBuffer[1] = Kperiod2 + Dperiod2;
   PeriodBuffer[2] = Kperiod3 + Dperiod3;
   PeriodBuffer[3] = Kperiod4 + Dperiod4;
   PeriodBuffer[4] = Kperiod5 + Dperiod5;
//---
   StartBar=PeriodBuffer[ArrayMaximum(PeriodBuffer,0,WHOLE_ARRAY)]+1;
//---    iStochastic1
   STO1_Handle=iStochastic(NULL,0,Kperiod1,Dperiod1,Slowing,MA_Method,Price_field);
   if(STO1_Handle==INVALID_HANDLE)
     {
      Print("      iStochastic1");
      return(INIT_FAILED);
     }
//---    iStochastic2
   STO2_Handle=iStochastic(NULL,0,Kperiod2,Dperiod2,Slowing,MA_Method,Price_field);
   if(STO2_Handle==INVALID_HANDLE)
     {
      Print("      iStochastic2");
      return(INIT_FAILED);
     }
//---    iStochastic3
   STO3_Handle=iStochastic(NULL,0,Kperiod3,Dperiod3,Slowing,MA_Method,Price_field);
   if(STO3_Handle==INVALID_HANDLE)
     {
      Print("      iStochastic3");
      return(INIT_FAILED);
     }
//---    iStochastic4
   STO4_Handle=iStochastic(NULL,0,Kperiod4,Dperiod4,Slowing,MA_Method,Price_field);
   if(STO4_Handle==INVALID_HANDLE)
     {
      Print("      iStochastic4");
      return(INIT_FAILED);
     }
//---    iStochastic5
   STO5_Handle=iStochastic(NULL,0,Kperiod5,Dperiod5,Slowing,MA_Method,Price_field);
   if(STO5_Handle==INVALID_HANDLE)
     {
      Print("      iStochastic5");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,FastBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,StartBar);
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,"FastTrendLine");
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(FastBuffer,true);
//---      
   SetIndexBuffer(1,SlowBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,StartBar);
//---      DataWindow
   PlotIndexSetString(1,PLOT_LABEL,"SlowTrendLine");
//---   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(SlowBuffer,true);
//---      
   SetIndexBuffer(2,FastBuffer_,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,StartBar);
//---      DataWindow
   PlotIndexSetString(2,PLOT_LABEL,"FastTrendLine");
//---   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(FastBuffer_,true);
//---      
   SetIndexBuffer(3,SlowBuffer_,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,StartBar);
//---      DataWindow
   PlotIndexSetString(3,PLOT_LABEL,"SlowTrendLine");
//---   ,      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(SlowBuffer_,true);
//---      
   string shortname="ZerolagStochs";
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| ZerolagStochs iteration function                                 | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(STO1_Handle)<rates_total
      || BarsCalculated(STO2_Handle)<rates_total
      || BarsCalculated(STO3_Handle)<rates_total
      || BarsCalculated(STO4_Handle)<rates_total
      || BarsCalculated(STO5_Handle)<rates_total
      || rates_total<StartBar)
      return(0);
//---       
   double Sto1,Sto2,Sto3,Sto4,Sto5,FastTrend,SlowTrend;
   double Stoch1[],Stoch2[],Stoch3[],Stoch4[],Stoch5[];
//---   
   int limit,to_copy,bar;
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-StartBar-2; //      
      to_copy=rates_total; //    
     }
   else //      
     {
      limit=rates_total-prev_calculated;  //       
      to_copy=rates_total-prev_calculated+1;
     }
//---         
   ArraySetAsSeries(Stoch1,true);
   ArraySetAsSeries(Stoch2,true);
   ArraySetAsSeries(Stoch3,true);
   ArraySetAsSeries(Stoch4,true);
   ArraySetAsSeries(Stoch5,true);
//---      
   if(CopyBuffer(STO1_Handle,0,0,to_copy,Stoch1)<=0) return(0);
   if(CopyBuffer(STO2_Handle,0,0,to_copy,Stoch2)<=0) return(0);
   if(CopyBuffer(STO3_Handle,0,0,to_copy,Stoch3)<=0) return(0);
   if(CopyBuffer(STO4_Handle,0,0,to_copy,Stoch4)<=0) return(0);
   if(CopyBuffer(STO5_Handle,0,0,to_copy,Stoch5)<=0) return(0);
//---     ,
//---   limit    
//---    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      Sto1 = Factor1 * Stoch1[limit+1];
      Sto2 = Factor2 * Stoch2[limit+1];
      Sto3 = Factor2 * Stoch3[limit+1];
      Sto4 = Factor4 * Stoch4[limit+1];
      Sto5 = Factor5 * Stoch5[limit+1];

      FastTrend=Sto1+Sto2+Sto3+Sto4+Sto5;
      FastBuffer[limit+1]=FastTrend;
      FastBuffer_[limit+1]=FastTrend;
      SlowBuffer[limit+1]=FastTrend/smoothing;
      SlowBuffer_[limit+1]=SlowBuffer[limit+1];
     }
//---    
   for(bar=limit; bar>=0; bar--)
     {
      Sto1 = Factor1 * Stoch1[bar];
      Sto2 = Factor2 * Stoch2[bar];
      Sto3 = Factor2 * Stoch3[bar];
      Sto4 = Factor4 * Stoch4[bar];
      Sto5 = Factor5 * Stoch5[bar];
      //---
      FastTrend = Sto1 + Sto2 + Sto3 + Sto4 + Sto5;
      SlowTrend = FastTrend / smoothing + SlowBuffer[bar + 1] * smoothConst;
      //---
      SlowBuffer[bar]=SlowTrend;
      FastBuffer[bar]=FastTrend;
      //---
      SlowBuffer_[bar]=SlowTrend;
      FastBuffer_[bar]=FastTrend;
     }
//---    
   return(rates_total);
  }
//+------------------------------------------------------------------+
