//     mqh  Pricest_Copy.mqh

#include "Pricest_Base.mqh"

#ifndef PRICEST_NAME
  #define PRICEST_NAME HIGHEST
#endif // PRICEST_NAME

#ifndef PRICEST_ARRAY_MAXMIN
  #define PRICEST_ARRAY_MAXMIN ::ArrayMaximum
#endif // PRICEST_ARRAY_MAXMIN

#ifndef PRICEST_COMPARE_SIGN
  #define PRICEST_COMPARE_SIGN >
#endif // PRICEST_COMPARE_SIGN

#ifndef PRICEST_COMPARE_SIGN2
  #define PRICEST_COMPARE_SIGN2 >=
#endif // PRICEST_COMPARE_SIGN2

#ifndef PRICEST_INIT_VALUE
  #define PRICEST_INIT_VALUE (-DBL_MAX)
#endif // PRICEST_INIT_VALUE

#ifndef PRICEST_TICK_PRICE
  #define PRICEST_TICK_PRICE bid
#endif // PRICEST_TICK_PRICE

struct PRICEST_NAME : public PRICEST_BASE
{
private:
  int ArrayMaxMin( int EndPos, const int Pos ) const
  {
    int Res = -1;

    if (EndPos >= 0)
    {
      if (Pos > EndPos)
      #ifdef __MQL5__
        Res = PRICEST_ARRAY_MAXMIN(this.Prices, EndPos, Pos - EndPos);
      #else // __MQL5__
        Res = PRICEST_ARRAY_MAXMIN(this.Prices, Pos - EndPos, EndPos);
      #endif // __MQL5__
    }
    else
    {
      double MaxMin = PRICEST_INIT_VALUE;

      if (Pos > 0)
      {
      #ifdef __MQL5__
        Res = PRICEST_ARRAY_MAXMIN(this.Prices, 0, Pos);
      #else // __MQL5__
        Res = PRICEST_ARRAY_MAXMIN(this.Prices, Pos);
      #endif // __MQL5__

        MaxMin = this.Prices[Res];
      }

      EndPos += MAX_BARS;

    #ifdef __MQL5__
      const int i = PRICEST_ARRAY_MAXMIN(this.Prices, EndPos);
    #else // __MQL5__
      const int i = PRICEST_ARRAY_MAXMIN(this.Prices, WHOLE_ARRAY, EndPos);
    #endif // __MQL5__

      if (this.Prices[i] PRICEST_COMPARE_SIGN MaxMin)
        Res = i;
    }

    return(Res);
  }

  bool FullCalculate( void )
  {
    bool Res = false;

    if (++this.PricePos >= this.period)
    {
      this.Price = this.Current;
      this.PricePos = 0;

      const int i = this.ArrayMaxMin(this.CurrentPos - this.period + 1, this.CurrentPos);

      if ((i >= 0) && (this.Prices[i]) PRICEST_COMPARE_SIGN this.Price)
      {
        this.Price = this.Prices[i];

        this.PricePos = (this.CurrentPos - i + MAX_BARS) % MAX_BARS;
      }

      Res = true;
    }

    return(Res);
  }

  bool PartCalculate( const MqlTick &Tick )
  {
    bool Res;

    this.Current = Tick.PRICEST_TICK_PRICE;

    if (this.Current PRICEST_COMPARE_SIGN2 this.Price)
    {
      this.Price = this.Current;
      this.PricePos = 0;

      Res = true;
    }
    else
      Res = this.FullCalculate();

    return(Res);
  }

public:
  PRICEST_NAME( void )
  {
    ::ArrayInitialize(this.Prices, PRICEST_INIT_VALUE);

    this.Price = PRICEST_INIT_VALUE;
    this.Current = PRICEST_INIT_VALUE;
  }

  PRICEST_NAME( const int iPeriod ) : PRICEST_BASE(iPeriod)
  {
    ::ArrayInitialize(this.Prices, PRICEST_INIT_VALUE);

    this.Price = PRICEST_INIT_VALUE;
    this.Current = PRICEST_INIT_VALUE;
  }

  bool NewTick( const MqlTick &Tick )
  {
    bool Res = false;

    if (Tick.time >= this.NextBarTime)
    {
      this.NextBarTime = this.GetNextTime(Tick);

      this.Prices[CurrentPos] = this.Current;
      this.CurrentPos = (this.CurrentPos + 1) % MAX_BARS;

      Res = this.PartCalculate(Tick);
    }
    else if (Tick.PRICEST_TICK_PRICE PRICEST_COMPARE_SIGN this.Current)
      Res = this.PartCalculate(Tick);
    else
      Res = this.FullCalculate();

    return(Res);
  }

  bool NewTick( void )
  {
    static MqlTick Tick;

    return(::SymbolInfoTick(_Symbol, Tick) && this.NewTick(Tick));
  }

  bool NewTick( const MqlTick &Ticks[] )
  {
    bool Res = false;

    const int Size = ::ArraySize(Ticks);

    for (int i = 0; i < Size; i++)
      Res |= this.NewTick(Ticks[i]);

    return(Res);
  }

  double Get( const int NewPeriod ) const
  {
    double Res;

    if ((NewPeriod > this.PricePos) && (NewPeriod <= this.period))
      Res = this.Price;
    else
    {
      int Pos;
      int EndPos;

      if (NewPeriod > this.period)
      {
        Res = this.Price;

        Pos = (this.CurrentPos - this.PricePos + MAX_BARS) % MAX_BARS;
        EndPos = Pos - NewPeriod + this.PricePos + 1;
      }
      else
      {
        Res = this.Current;

        Pos = this.CurrentPos;
        EndPos = Pos - NewPeriod + 1;
      }

      const int i = this.ArrayMaxMin(EndPos, Pos);

      if ((i >= 0) && (this.Prices[i] PRICEST_COMPARE_SIGN Res))
        Res = this.Prices[i];
    }

    return(Res);
  }

  void SetPeriod( int NewPeriod )
  {
    NewPeriod = (NewPeriod < 1) ? 1 : ((NewPeriod > MAX_BARS) ? MAX_BARS : NewPeriod);

    if ((NewPeriod > this.period) || (NewPeriod <= this.PricePos))
    {
      int Pos;
      int EndPos;

      if (NewPeriod > this.period)
      {
        Pos = (this.CurrentPos - this.PricePos + MAX_BARS) % MAX_BARS;

        EndPos = Pos - NewPeriod + this.PricePos + 1;
      }
      else
      {
        this.Price = this.Current;
        this.PricePos = 0;

        Pos = this.CurrentPos;
        EndPos = Pos - NewPeriod + 1;
      }

      const int i = this.ArrayMaxMin(EndPos, Pos);

      if ((i >= 0) && this.Prices[i] PRICEST_COMPARE_SIGN this.Price)
      {
        this.Price = this.Prices[i];

        this.PricePos = (this.CurrentPos - i + MAX_BARS) % MAX_BARS;
      }
    }

    this.period = NewPeriod;

    return;
  }

  bool operator +=( const MqlTick &Ticks[] )
  {
    return(this.NewTick(Ticks));
  }

  bool operator +=( const MqlTick &Tick )
  {
    return(this.NewTick(Tick));
  }

  double operator []( const int Pos ) const
  {
    const double Res = Pos ? this.Prices[(this.CurrentPos - Pos + MAX_BARS) % MAX_BARS] : this.Current;

    return((Res == PRICEST_INIT_VALUE) ? 0 : Res);
  }
};

#undef PRICEST_TICK_PRICE
#undef PRICEST_INIT_VALUE
#undef PRICEST_COMPARE_SIGN2
#undef PRICEST_COMPARE_SIGN
#undef PRICEST_ARRAY_MAXMIN
#undef PRICEST_NAME