// #define PRICECHANNEL_HIGH_PRICE bid // bid/ask/last  High 
// #define PRICECHANNEL_LOW_PRICE bid  // bid/ask/last  Low 

#ifdef PRICECHANNEL_HIGH_PRICE
  #define PRICEST_TICK_PRICE PRICECHANNEL_HIGH_PRICE
#endif // PRICECHANNEL_HIGH_PRICE

#include "Highest.mqh"

#ifdef PRICECHANNEL_LOW_PRICE
  #define PRICEST_TICK_PRICE PRICECHANNEL_LOW_PRICE
#endif // PRICECHANNEL_LOW_PRICE

#include "Lowest.mqh"

struct PRICECHANNEL
{
private:
  HIGHEST Highest;
  LOWEST Lowest;

public:
  PRICECHANNEL( void )
  {
  }

  PRICECHANNEL( const int iPeriod ) : Highest(iPeriod), Lowest(iPeriod)
  {
  }

  bool NewTick( const MqlTick &Tick )
  {
    const bool Res1 = this.Highest.NewTick(Tick);
    const bool Res2 = this.Lowest.NewTick(Tick);

    return(Res1 || Res2);
  }

  bool NewTick( void )
  {
    static MqlTick Tick;

    return(::SymbolInfoTick(_Symbol, Tick) && this.NewTick(Tick));
  }

  bool NewTick( const MqlTick &Ticks[] )
  {
    const bool Res1 = this.Highest.NewTick(Ticks);
    const bool Res2 = this.Lowest.NewTick(Ticks);

    return(Res1 || Res2);
  }

  void SetPeriod( const int NewPeriod )
  {
    this.Highest.SetPeriod(NewPeriod);
    this.Lowest.SetPeriod(NewPeriod);

    return;
  }

  const MqlTick Get( const int NewPeriod ) const
  {
    MqlTick Tick = {0};

    Tick.bid = this.Highest.Get(NewPeriod);
    Tick.ask = this.Lowest.Get(NewPeriod);

    return(Tick);
  }

  const MqlTick Get( void ) const
  {
    MqlTick Tick = {0};

    Tick.bid = this.Highest.Get();
    Tick.ask = this.Lowest.Get();

    return(Tick);
  }

  int GetPeriod( void ) const
  {
    return(this.Highest.GetPeriod());
  }

  double GetHigh( void ) const
  {
    return(this.Highest.Get());
  }

  double GetHigh( const int NewPeriod ) const
  {
    return(this.Highest.Get(NewPeriod));
  }

  double GetLow( void ) const
  {
    return(this.Lowest.Get());
  }

  double GetLow( const int NewPeriod ) const
  {
    return(this.Lowest.Get(NewPeriod));
  }

  const MqlTick operator []( const int Pos ) const
  {
    MqlTick Tick = {0};

    Tick.bid = this.Highest[Pos];
    Tick.ask = this.Lowest[Pos];

    return(Tick);
  }

  bool operator +=( const MqlTick &Ticks[] )
  {
    return(this.NewTick(Ticks));
  }

  bool operator +=( const MqlTick &Tick )
  {
    return(this.NewTick(Tick));
  }

  int GetBarInterval( void ) const
  {
    return(this.Highest.GetBarInterval());
  }

  void SetBarInterval( const int iBarInterval )
  {
    this.Highest.SetBarInterval(iBarInterval);
    this.Lowest.SetBarInterval(iBarInterval);

    return;
  }
};