#ifdef __MQL4__

#property strict

// https://www.mql5.com/ru/docs/files/fileload
template <typename T>
long FileLoad( const string FileName, T &Buffer[], const int CommonFlag = 0 )
{
  long Res = -1;

  const int handle = FileOpen(FileName, FILE_READ | FILE_BIN | CommonFlag);

  if (handle != INVALID_HANDLE)
  {
    if (!(Res = FileReadArray(handle, Buffer)))
      Res = -1;

    FileClose(handle);
  }

  return(Res);
}

// https://www.mql5.com/ru/docs/files/filesave
template <typename T>
bool FileSave( const string FileName, const T &Buffer[], const int CommonFlag = 0 )
{
  const int handle = FileOpen(FileName, FILE_WRITE | FILE_BIN | CommonFlag);

  const bool Res = (handle != INVALID_HANDLE) && FileWriteArray(handle, Buffer);

  if (handle != INVALID_HANDLE)
    FileClose(handle);

  return(Res);
}

#endif // __MQL4__
