#define ACCURATETIMER
// #define ACCURATETIMER_FRAME_MODE //    ,   Frame-

class ACCURATE_TIMER
{
private:
  static uint TimerMs;
  static ulong StartTime;

  static const ushort EventCustom;
  static const bool IsFrame;

  static ulong GetNextTime( const long NowTime )
  {
    return(NowTime - (NowTime - (long)ACCURATE_TIMER::StartTime) % ACCURATE_TIMER::TimerMs + ACCURATE_TIMER::TimerMs);
  }

  static bool IsMyEvent( const int id )
  {
    return(id == ACCURATE_TIMER::EventCustom + CHARTEVENT_CUSTOM);
  }

  static bool SendMyEvent( void )
  {
    return(::EventChartCustom(0, ACCURATE_TIMER::EventCustom, 0, 0, NULL));
  }

public:
  static bool EventSetMillisecondTimer2( const int Milliseconds )
  {
    const bool Res = (ACCURATE_TIMER::IsFrame && ACCURATE_TIMER::SendMyEvent()) || ::EventSetMillisecondTimer(Milliseconds);

    if (Res)
    {
      ACCURATE_TIMER::TimerMs = Milliseconds * 1000;

      ACCURATE_TIMER::StartTime = ::GetMicrosecondCount() + ACCURATE_TIMER::TimerMs;
    }

    return(Res);
  }

  static bool OnTimer2( void )
  {
    bool Res = false;

    if (ACCURATE_TIMER::TimerMs)
    {
      const ulong NowTime = ::GetMicrosecondCount();

      if (!ACCURATE_TIMER::IsFrame)
        ACCURATE_TIMER::StartTime = ACCURATE_TIMER::GetNextTime(NowTime);

      const long NewTimerMs = ((long)ACCURATE_TIMER::StartTime - (long)NowTime) / 1000;

      Res = (NewTimerMs > 0) ? (!ACCURATE_TIMER::IsFrame && ::EventSetMillisecondTimer((int)NewTimerMs))
                             : (ACCURATE_TIMER::IsFrame && (bool)(ACCURATE_TIMER::StartTime = ACCURATE_TIMER::GetNextTime(NowTime)));
    }

    return(Res);
  }

  static void EventKillTimer2( void )
  {
    ::EventKillTimer();

    ACCURATE_TIMER::TimerMs = 0;

    return;
  }

  static bool OnChartEvent2( const int id )
  {
    return(ACCURATE_TIMER::IsFrame && ACCURATE_TIMER::TimerMs && ACCURATE_TIMER::IsMyEvent(id) && ACCURATE_TIMER::SendMyEvent() && ACCURATE_TIMER::OnTimer2());
  }
};

static uint ACCURATE_TIMER::TimerMs = 0;
static ulong ACCURATE_TIMER::StartTime = 0;

static const ushort ACCURATE_TIMER::EventCustom = 123;
static const bool ACCURATE_TIMER::IsFrame = ::MQLInfoInteger(MQL_FRAME_MODE);

void OnTimer( void )
{
  static const bool IsTester = (::MQLInfoInteger(MQL_TESTER) || ::MQLInfoInteger(MQL_OPTIMIZATION) || ::MQLInfoInteger(MQL_FRAME_MODE));

  if (!IsTester)
    ACCURATE_TIMER::OnTimer2();

  OnTimer2();

  return;
}

#ifdef ACCURATETIMER_FRAME_MODE
  void OnChartEvent( const int id, const long& lparam, const double& dparam, const string& sparam )
  {
    if (ACCURATE_TIMER::OnChartEvent2(id))
      OnTimer2();

    OnChartEvent2(id, lparam, dparam, sparam);

    return;
  }

  #define OnChartEvent OnChartEvent2
#endif // ACCURATETIMER_FRAME_MODE

#define OnTimer OnTimer2
#define EventSetMillisecondTimer ACCURATE_TIMER::EventSetMillisecondTimer2
#define EventSetTimer(A) EventSetMillisecondTimer((A) * 1000)
#define EventKillTimer ACCURATE_TIMER::EventKillTimer2