#include <AccurateTimer.mqh> //    

input int Timer = 1000; //     

#define TOSTRING(A) #A + " = " + (string)(A) + " ms.\n"

const bool Init = EventSetMillisecondTimer(Timer);

//           
void OnTimer()
{
  static ulong StartTime = 0;
  static int Count = 0;
  static int Sum = 0;

  if (StartTime)
  {
    const int RunTime = (int)(GetMicrosecondCount() - StartTime) / 1000;
    const int Error = RunTime - Timer * Count;

    Sum += Error;

    Comment(TOSTRING(Timer) + TimeToString(RunTime / 1000, TIME_SECONDS) + "\n" +
            TOSTRING(Error) + TOSTRING((double)Sum / Count));
  }
  else
    StartTime = GetMicrosecondCount();

//  Sleep(900); //   

  Count++;
}