//+------------------------------------------------------------------+
//|                                         GlobalChartFunctions.mqh |
//|                        Copyright 2017, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2017, MetaQuotes Software Corp."
#property link      "https://www.mql5.com"
#property strict
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool CreateHorizontalLine(const long     chart_ID=0,// chart's ID
                          const string          name="HLine",      // line name
                          const int             sub_window=0,      // subwindow index
                          double                price=0,// line price
                          const color           clr=clrRed,        // line color
                          const ENUM_LINE_STYLE style=STYLE_SOLID, // line style
                          const int             width=1,           // line width
                          const bool            back=false,        // in the background
                          const bool            selection=true,    // highlight to move
                          const bool            hidden=false,// hidden in the object list
                          const long            z_order=0) // priority for mouse click
  {

   if(!price) price=SymbolInfoDouble(Symbol(),SYMBOL_BID);

   ResetLastError();

   if(!ObjectCreate(chart_ID,name,OBJ_HLINE,sub_window,0,price))
     {
      Print(__FUNCTION__,": failed to create a horizontal line! Error code = ",GetLastError());
      return(false);
     }

   ObjectSetInteger(chart_ID,name,OBJPROP_COLOR,clr);

   ObjectSetInteger(chart_ID,name,OBJPROP_STYLE,style);

   ObjectSetInteger(chart_ID,name,OBJPROP_WIDTH,width);

   ObjectSetInteger(chart_ID,name,OBJPROP_BACK,back);
//--- enable (true) or disable (false) the mode of moving the line by mouse
//--- when creating a graphical object using ObjectCreate function, the object cannot be
//--- highlighted and moved by default. Inside this method, selection parameter
//--- is true by default making it possible to highlight and move the object
   ObjectSetInteger(chart_ID,name,OBJPROP_SELECTABLE,selection);
   ObjectSetInteger(chart_ID,name,OBJPROP_SELECTED,selection);
//--- hide (true) or display (false) graphical object name in the object list
   ObjectSetInteger(chart_ID,name,OBJPROP_HIDDEN,hidden);
//--- set the priority for receiving the event of a mouse click in the chart
   ObjectSetInteger(chart_ID,name,OBJPROP_ZORDER,z_order);
//--- successful execution
   return(true);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool DeleteLine(const long chart_ID=0,const string name="HLine",bool boolReportError=True)
  {
   bool boolRet=False;

   if(ObjectFind(chart_ID,name)>=0)
     {
      boolRet=ObjectDelete(chart_ID,name);
      if(!boolRet)
        {
         if(boolReportError) Print(__FUNCTION__,": failed to delete the line: ",name," Error code = ",GetLastError());
         return(false);
        }
     }

   return(boolRet);
  }
//+------------------------------------------------------------------+
