//+------------------------------------------------------------------+
//|                                       C_Trade_BasicExample_1.mq4 |
//|                                     Copyright 2017, Mark Wilson. |
//|                          https://www.mql5.com/en/users/balrog100 |
//+------------------------------------------------------------------+
#include <C_Trade.mqh>

#property copyright "Copyright 2017, Mark Wilson"
#property link      "https://www.mql5.com/en/users/balrog100"
#property version   "1.00"
#property strict


//+------------------------------------------------------------------+
//| Inputs                                                           |
//+------------------------------------------------------------------+
input E_BS  I_BuyOrSell=BUY;                                               //Buy or Sell
input int I_HiddenStopLossInPoints=15;                                     //Stoploss (points)
input int I_HiddenTakeProfitInPoints=15;                                   //TakeProfit (points)
input int I_LiveSpreadInPoints=40;                                         //Extra spread for live sl/tp.
input double I_Volume=0.1;                                                 //Volume/Lots
input int I_Slippage=5;                                                    //Slippage
input bool I_DrawLines=True;                                               //Draw Hidden SL/TP on chart

//+------------------------------------------------------------------+
//| Global Variables                                                 |
//+------------------------------------------------------------------+
C_Trade *g_objTrade;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+


int OnInit()
  {

//This system works by using a class that contains a hidden stoploss and take profit.   When the trade is added, an actual stoploss
//and takeprofit are added to the live trade that is bigger than the hidden stoploss or take profit:
//Bid:   LiveStopLoss=HiddenStopLoss-LiveSpread    LiveTakeProfit=HiddenTakeProfit+LiveSpread
//Ask:   LiveStopLoss=HiddenStopLoss+LiveSpread    LiveTakeProfit=HiddenTakeProfit-LiveSpread.
//However in addition to this, if the StopLevel and/or FreezeLevel are big enough, it may increase the live stoploss/takeprofit to 
//ensure that the trade is valid.   It also ensures they are >=0.

//The rest of this code creates a new trade using the C_Trade class and its associated g_objTrade object.

   Print(__FILE__+" "+__FUNCTION__,"   START-------------------------------------------------");

//Get the actual live spread.
   double dblLiveSpread=I_LiveSpreadInPoints*Point();

//Get a suitable spot, sl and tp
   RefreshRates();
   double dblSpot,dblHiddenStopLoss,dblHiddenTakeProfit;
   if(I_BuyOrSell==BUY)
     {
      dblSpot=Ask;
      dblHiddenStopLoss=dblSpot-I_HiddenStopLossInPoints*Point();
      dblHiddenTakeProfit=dblSpot+I_HiddenTakeProfitInPoints*Point();
     }
   else
     {
      dblSpot=Bid;
      dblHiddenStopLoss=dblSpot+I_HiddenStopLossInPoints*Point();
      dblHiddenTakeProfit=dblSpot-I_HiddenTakeProfitInPoints*Point();
     }

//Create a new trade class and create the trade using the over-ridden OrderSend function.
   g_objTrade=NULL;
   g_objTrade= new C_Trade(Symbol(),I_BuyOrSell,I_Volume,dblSpot,dblHiddenStopLoss,dblHiddenTakeProfit,"",0,dblLiveSpread,I_DrawLines);
   if(!g_objTrade.OrderSend(dblSpot,I_Slippage))
     {
      //Trade Entry Error Processing could be added here.

      //Destroy the class
      delete g_objTrade;
      g_objTrade=NULL;
     }

//Print out the details
   string strPrint=g_objTrade.Description();
   Comment(strPrint);
   Print(__FILE__+" "+__FUNCTION__," ",strPrint);

   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {

//If the EA has been shut down, destroy g_objTrade.
   if(g_objTrade!=NULL)
     {
      //Annoying, I wanted to destroy the trade in the destructor, but it kept making MetaTrader hang.
      if(g_objTrade.TradeIsLive())
        {
         RefreshRates();
         double dblSpot=Bid;
         if(g_objTrade.GetType()==SELL) dblSpot=Ask;
         g_objTrade.OrderClose(dblSpot,I_Slippage,clrRed);

         //Trade Close Error Processing could be added here.
        }
      delete g_objTrade;
     }

   Print(__FILE__+" "+__FUNCTION__,"   END---------------------------------------------------");

  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {

//Run this with every tick to see if the trade has been closed.
   if(g_objTrade!=NULL)
     {
      if(g_objTrade.TradeIsLive())
        {
         if(g_objTrade.ScanWithEveryTick(I_Slippage))
           {  //Ensure trade is closed.
            delete g_objTrade;
            g_objTrade=NULL;
           }
        }
     }

  }
//+------------------------------------------------------------------+
