//+------------------------------------------------------------------+ 
//|                                                   Volatility.mq5 | 
//|                   Copyright  2009, Trofimov Evgeniy Vitalyevich | 
//|                                     http://TrofimovVBA.narod.ru/ | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2009, Trofimov Evgeniy Vitalyevich"
#property link      "http://TrofimovVBA.narod.ru/"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window 
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----        Red 
#property indicator_color1 clrRed
//----   -  
#property indicator_style1  STYLE_SOLID
//----     1
#property indicator_width1  1
//----   
#property indicator_label1  "Volatility"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint N=12; //   
input int Shift=0; //      
//+-----------------------------------+
//----  
double IndBuffer[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+    
//| Volatility indicator initialization function                     | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=int(N);

//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(IndBuffer,true);

//----      
   string shortname="Volatility("+string(N)+")";
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
  }
//+------------------------------------------------------------------+  
//| Volatility iteration function                                    | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----       
   double HH,LL;
//----   
   int limit;

//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
        limit=rates_total-min_rates_total-1; //      
   else limit=rates_total-prev_calculated;  //       

//----         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);   
   
//----    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      HH=high[ArrayMaximum(high,bar,N)];
      LL=low [ArrayMinimum(low, bar,N)];
      IndBuffer[bar]=(HH-LL)/(_Point*N); 
     }
//----        
   return(rates_total);
  }
//+------------------------------------------------------------------+
