// MQL4&5-code

#include <fxsaber\Math\Math.mqh>

#include <Math_To_MQL4.mqh>
#include <Math\Stat\Normal.mqh>

bool MathCorrelationPearsonSLOW( const double &Signal[], const double &Pattern[], double &Corr[] )
{
  const int PatternLen = ArraySize(Pattern);
  const int SignalLen = ArraySize(Signal);

  ArrayResize(Corr, SignalLen);
  ArrayFill(Corr, 0, PatternLen, 0);

  double Window[];

  for (int i = PatternLen - 1; (i < SignalLen) && (!IsStopped()); i++)
  {
    ArrayCopy(Window, Signal, 0, i - PatternLen + 1, PatternLen);

    MathCorrelationPearson(Window, Pattern, Corr[i]);
  }

  return(!IsStopped());
}

bool  MathCorrelationPearsonSLOW2(const double &Signal[],const double &Pattern[],double &Corr[])
  {
   const int PatternLen= ArraySize(Pattern);
   const int SignalLen = ArraySize(Signal);
   ArrayResize(Corr,SignalLen);
   ArrayFill(Corr,0,PatternLen,0);
   double Window[];
   double v=1.0/(double)PatternLen;
   double r=0;
   double xmean=0;
   double ymean=0;
   double s=0;
   double xv=0;
   double yv=0;
   double old_value=0;
   double y1[];
   ArrayResize(y1,PatternLen);
   bool first_calc=true;
   for(int i=PatternLen-1; (i<SignalLen) && (!IsStopped()); i++)
     {
      int position=i-PatternLen+1;
      if(first_calc==true)
        {
         xmean=0;
         ymean=0;
         s=0;
         xv=0;
         yv=0;
         for(int j=0; j<PatternLen; j++)
           {
            xmean+=Signal[position+j]*v;
            ymean+=Pattern[j]*v;
           }
         s=0;
         for(int j=0; j<PatternLen; j++)
           {
            double t1=Signal[position+j]-xmean;
            double t2=Pattern[j]-ymean;
            y1[j]=t2;
            xv+=t1*t1;
            yv+=t2*t2;
            s+=t1*t2;
           }
         r=s/MathSqrt(xv*yv);
         old_value=Signal[position];
         first_calc=false;
        }
      else
        {
         double new_value=Signal[position+PatternLen-1];
         xmean-=old_value*v;
         xmean+=new_value*v;
         xv=0;
         s=0;
         for(int j=0; j<PatternLen; j++)
           {
            double t1=Signal[position+j]-xmean;
            xv+=t1*t1;
            s+=t1*y1[j];
           }
         r=s/MathSqrt(xv*yv);
         old_value=Signal[position];
        }
      Corr[i]=r;
     }
   return(!IsStopped());
  }

#define TOSTRING(A) #A + " = " + (string)(A) + "\n"

#define BENCHMARK(A)                                    \
{                                                                   \
  const ulong StartTime = GetMicrosecondCount();                    \
                                                                    \
  Print(TOSTRING(A) + TOSTRING(GetMicrosecondCount() - StartTime)); \
}

bool CalculateBenchmarkCorrelationPearson( const double Mu = 2, const double Sigma = 8, const int Size = 1000000, const int Size2 = 20000 )
{
  double Random[];

  if (MathRandomNormal(Mu, Sigma, Size, Random))
  {
    double Pattern[];
    ArrayCopy(Pattern, Random, 0, Size - Size2);

    double Corr1[];
    BENCHMARK(MathCorrelationPearson(Random, Pattern, Corr1))

    Print(TOSTRING(Corr1[Size - 1]) + TOSTRING(Corr1[Size - 2]));

    double Corr2[];
    BENCHMARK(MathCorrelationPearsonSLOW(Random, Pattern, Corr2))

    Print(TOSTRING(Corr2[Size - 1]) + TOSTRING(Corr2[Size - 2]));

    double Corr3[];
    BENCHMARK(MathCorrelationPearsonSLOW2(Random, Pattern, Corr3))

    Print(TOSTRING(Corr3[Size - 1]) + TOSTRING(Corr3[Size - 2]));

    double SumError = 0;

    for (int i = 0; i < Size; i++)
      SumError += MathAbs(Corr1[i] - Corr2[i]);

    Print(TOSTRING(SumError));
  }

  return(!IsStopped());
}

void CalculateBenchmarks( const string PackageName )
{
  Print("Unit tests for Package " + PackageName);

  BENCHMARK(CalculateBenchmarkCorrelationPearson())
}

void OnStart( void )
{
  CalculateBenchmarks("Statistic Benchmark");
}
