// MQL4&5-code

#property strict

// https://www.mql5.com/ru/code/10612
class DEJAVU
{
private:
  double Pattern[];

  double StDevs[], Means[];
  double Var;

  static void RealFFT( double& a[], int tnn, bool inversefft = false )
  {
    double twr, twi, twpr, twpi, twtemp;
    double ttheta, theta = M_PI;
    int i, j, m;
    int i1, i2, i3, i4;
    double h1r, h1i, h2r, h2i;
    double wrs, wis;
    int n = tnn, nn = n >> 1;
    int mmax = 2, istep = 4;
    double wtemp, wr, wi, wpr, wpi;
    double tempr, tempi;
    int TmpINT;
    double TmpDOUBLE, Tmp1, Tmp2, Tmp3, Tmp4;

    if (tnn == 1)
      return;

    if (!inversefft)
    {
      j = 1;

      for(i = 1; i < n; i += 2)
      {
        if (j > i)
        {
          tempr = a[j-1];
          tempi = a[j];

          a[j-1] = a[i-1];
          a[j] = a[i];

          a[i-1] = tempr;
          a[i] = tempi;
        }

        m = nn;

        while ((m >= 2) && (j > m))
        {
          j -= m;
          m >>= 1;
        }

        j += m;
      }

      while (n > mmax)
      {
        TmpDOUBLE = MathSin(theta / 2);
        wpr = -2.0 * TmpDOUBLE * TmpDOUBLE;
        wpi = MathSin(theta);
        wr = 1.0;
        wi = 0.0;

        TmpINT = mmax + 1;

        for (m = 1; m < mmax; m += 2)
        {
          j = TmpINT;

          for(i = m; i <= n; i += istep)
          {
            Tmp1 = a[j - 1];
            Tmp2 = a[j];

            tempr = wr * Tmp1 - wi * Tmp2;
            tempi = wr * Tmp2 + wi * Tmp1;

            a[j-1] = a[i-1] - tempr;
            a[j] = a[i] - tempi;
            a[i - 1] += tempr;
            a[i] += tempi;

            j += istep;
          }

          wtemp = wr;
          wr = wr * wpr - wi * wpi + wr;
          wi = wi * wpr + wtemp * wpi + wi;

          TmpINT += 2;
        }

        mmax = istep;
        istep <<= 1;
        theta /= 2;
      }

      TmpDOUBLE = MathSin(theta / 2);

      twpr = -2.0 * TmpDOUBLE * TmpDOUBLE;
      twpi = MathSin(2.0 * M_PI / tnn);
      twr = 1.0 + twpr;
      twi = twpi;

      i2 = 3;
      i3 = tnn - 2;
      i4 = tnn - 1;

      for (i1 = 2; i1 <= nn; i1 += 2, i2 += 2, i3 -= 2, i4 -= 2)
      {
        wrs = twr;
        wis = twi;

        Tmp1 = a[i1];
        Tmp2 = a[i2];
        Tmp3 = a[i3];
        Tmp4 = a[i4];

        h1r = Tmp1 + Tmp3;
        h1i = Tmp2 - Tmp4;
        h2r = Tmp2 + Tmp4;
        h2i = Tmp3 - Tmp1;

        a[i1] = h1r + wrs * h2r - wis * h2i;
        a[i2] = h1i + wrs * h2i + wis * h2r;
        a[i3] = h1r - wrs * h2r + wis * h2i;
        a[i4] = wrs * h2i + wis * h2r - h1i;

        twtemp = twr;
        twr = twr * twpr - twi * twpi + twr;
        twi = twi * twpr + twtemp * twpi + twi;
      }

      h1r = a[0];
      a[0] = (h1r + a[1]) * 2;
      a[1] = (h1r - a[1]) * 2;
    }
    else
    {
      ttheta = -2.0 * M_PI / tnn;
      TmpDOUBLE = MathSin(ttheta / 2);

      twpr = -2.0 * TmpDOUBLE * TmpDOUBLE;
      twpi = MathSin(ttheta);
      twr = 1.0 + twpr;
      twi = twpi;

      i2 = 3;
      i3 = tnn - 2;
      i4 = tnn - 1;

      for (i1 = 2; i1 <= nn; i1 += 2, i2 += 2, i3 -= 2, i4 -= 2)
      {
        wrs = twr;
        wis = twi;

        Tmp1 = a[i1];
        Tmp2 = a[i2];
        Tmp3 = a[i3];
        Tmp4 = a[i4];

        h1r = Tmp1 + Tmp3;
        h1i = Tmp2 - Tmp4;
        h2r = -Tmp2 - Tmp4;
        h2i = Tmp1 - Tmp3;

        a[i1] = h1r + wrs * h2r - wis * h2i;
        a[i2] = h1i + wrs * h2i + wis * h2r;
        a[i3] = h1r - wrs * h2r + wis * h2i;
        a[i4] = -h1i + wrs * h2i + wis * h2r;

        twtemp = twr;
        twr = twr * twpr - twi * twpi + twr;
        twi = twi * twpr + twtemp * twpi + twi;
      }

      h1r = a[0];
      a[0] = h1r + a[1];
      a[1] = h1r - a[1];

      j = 1;

      for (i = 1; i < n; i += 2)
      {
        if (j > i)
        {
          tempr = a[j - 1];
          tempi = a[j];

          a[j - 1] = a[i - 1];
          a[j] = a[i];

          a[i - 1] = tempr;
          a[i] = tempi;
        }

        m = nn;

        while ((m >= 2) && (j > m))
        {
          j -= m;
          m >>= 1;
        }

        j += m;
      }

      theta = -theta;

      while (n > mmax)
      {
        TmpDOUBLE = MathSin(theta / 2);
        wpr = -2.0 * TmpDOUBLE * TmpDOUBLE;
        wpi = MathSin(theta);
        wr = 1.0;
        wi = 0.0;

        TmpINT = mmax + 1;

        for (m = 1; m < mmax; m += 2)
        {
          j = TmpINT;

          for (i = m; i <= n; i += istep)
          {
            Tmp1 = a[j - 1];
            Tmp2 = a[j];

            tempr = wr * Tmp1 - wi * Tmp2;
            tempi = wr * Tmp2 + wi * Tmp1;

            a[j - 1] = a[i - 1] - tempr;
            a[j] = a[i] - tempi;
            a[i - 1] += tempr;
            a[i] += tempi;

            j += istep;
          }

          wtemp = wr;
          wr = wr*wpr-wi*wpi+wr;
          wi = wi*wpr+wtemp*wpi+wi;

          TmpINT += 2;
        }

        mmax = istep;
        istep <<= 1;
        theta /= 2;
      }
    }
  }

  double a1[], a2[];
  int nl;

  void GetCorrelationFFT( const double &Signal[], double &Corr[], bool FlagChange = true )
  {
    const int SignalLen = ArraySize(Signal);
    const int PatternLen = ::ArraySize(this.Pattern);

    int i = 1;

    if ((this.nl < SignalLen + PatternLen) || ((this.nl >> 1) >=  SignalLen + PatternLen))
    {
      this.nl = SignalLen + PatternLen;

      while(i < this.nl)
        i <<= 1;

      this.nl = i;

      FlagChange = true;
    }

    if (FlagChange)
    {
      if (i > 1)
      {
        ArrayResize(this.a1, this.nl);
        ArrayResize(this.a2, this.nl);
      }

      ArrayInitialize(this.a1, 0);
      ArrayCopy(this.a1, Signal, 0, 0, SignalLen);

      DEJAVU::RealFFT(this.a1, this.nl, false);
    }

    ArrayInitialize(this.a2, 0);
    ArrayCopy(this.a2, this.Pattern);

    DEJAVU::RealFFT(this.a2, this.nl, false);

    this.a2[0] *= this.a1[0];
    this.a2[1] *= this.a1[1];

    for(i = 2; i < this.nl - 1; i += 2)
    {
      const double t1 = this.a1[i];
      const double t2 = this.a1[i + 1];
      const double t3 = this.a2[i];
      const double t4 = this.a2[i + 1];

      this.a2[i] = t1 * t3 + t2 * t4;
      this.a2[i + 1] = t2 * t3 - t1 * t4;
    }

    DEJAVU::RealFFT(this.a2, this.nl, true);

    ::ArrayFill(Corr, 0, PatternLen, 0);

    const ulong Tmp = (ulong)(this.nl << 2) * PatternLen;

    for (i = 0; i <= SignalLen - PatternLen; i++)
      if (this.StDevs[i + PatternLen - 1] == 0)
        Corr[i + PatternLen - 1] = 0;
      else
      {
        const int j = i + PatternLen - 1;

        Corr[j] = this.a2[i] / (this.StDevs[j] * Tmp);

        if (Corr[j] > 1)
          Corr[j] = 1;
        else if (Corr[j] < -1)
          Corr[j] = -1;
      }

    return;
  }

  double GetCorr( const double &Signal[], int Pos ) const
  {
    int Size = ::ArraySize(this.Pattern);
    const double StDevSignal = this.StDevs[Pos];

    if (StDevSignal == 0)
      return(0);

    Pos -= Size - 1;

    double Sum = 0;

    for (int i = 0; i < Size; i++)
      Sum += Signal[Pos + i] * this.Pattern[i];

    return(Sum / (StDevSignal * Size));
  }

  void GetCorrelationClassic( const double &Signal[], double &Corr[] ) const
  {
    const int PatternLen = ::ArraySize(this.Pattern);

    ::ArrayFill(Corr, 0, PatternLen, 0);

    const int SignalLen = ::ArraySize(Signal);

    for (int i = PatternLen - 1; i < SignalLen; i++)
      Corr[i] = GetCorr(Signal, i);

    return;
  }

  void GetStDev( const double &Vector[], const int Pos, const int Len )
  {
    double Tmp = 0;

    this.Var = 0;

    for (int i = Pos; i > Pos - Len; i--)
      Tmp += Vector[i];

    Tmp /= Len;

    this.Means[Pos] = Tmp;

    for (int i = Pos; i > Pos - Len; i--)
    {
      const double Tmp2 = Vector[i] - Tmp;

      this.Var += Tmp2 * Tmp2;
    }

    this.Var /= Len;

    this.StDevs[Pos] = ::MathSqrt(this.Var);

    return;
  }

  void GetNextStDev( const double &Vector[], const int Pos, const int Len )
  {
    const int Pos2 = Pos - Len;

    const double Tmp1 = (Vector[Pos2] - Vector[Pos]) / Len;
    const double Tmp = this.Means[Pos -1] - Tmp1;
    this.Means[Pos] = Tmp;

    const double Tmp2 = Vector[Pos] - Tmp;
    const double Tmp3 = Vector[Pos2] - Tmp;

    this.Var += Tmp1 * Tmp1 + (Tmp2 * Tmp2 - Tmp3 * Tmp3) / Len;

    if (this.Var < 0)
      this.Var = 0;

    this.StDevs[Pos] = ::MathSqrt(this.Var);

    return;
  }

  static void NormalizeVector( double &Vector[] )
  {
    double Mean = 0;
    double StDev = 0;

    const int SizeVector = ::ArraySize(Vector);

    for (int i = 0; i < SizeVector; i++)
      Mean += Vector[i];

    Mean /= SizeVector;

    for (int i = 0; i < SizeVector; i++)
    {
      Vector[i] -= Mean;

      StDev += Vector[i] * Vector[i];
    }

    if (StDev != 0)
    {
      StDev = ::MathSqrt(StDev / SizeVector);

      for (int i = 0; i < SizeVector; i++)
        Vector[i] /= StDev;
    }

    return;
  }

  static double Bench( const int SignalLen, const int PatternLen )
  {
      const double Koef = 7;
      const int Tmp = SignalLen + PatternLen;
      int i = 1, Count = 0;

      while (i < Tmp)
      {
        Count++;
        i <<= 1;
      }

      return((SignalLen <= PatternLen) ? 1 : Koef * Count * i / ((ulong)PatternLen * (SignalLen - PatternLen)));
  }

public:
  DEJAVU( const double &dPattern[] ) : nl(2)
  {
    ::ArrayCopy(this.Pattern, dPattern);

    DEJAVU::NormalizeVector(this.Pattern);
  }

  void GetCorrelation( const double &Signal[] , double &Corr[])
  {
    const int Size = ::ArraySize(Signal);

    ::ArrayResize(Corr, Size);

    ::ArrayResize(this.Means, Size);
    ::ArrayResize(this.StDevs, Size);

    const int NewSize = ::ArraySize(this.Pattern);

    this.GetStDev(Signal, NewSize - 1, NewSize);

    for (int i = NewSize; i < Size; i++)
      this.GetNextStDev(Signal, i, NewSize);

    if (DEJAVU::Bench(Size, NewSize) < 1)
      this.GetCorrelationFFT(Signal, Corr);
    else
      this.GetCorrelationClassic(Signal, Corr);

    return;
  }
};