//+---------------------------------------------------------------------+ 
//|                                              StochasticDiff_HTF.mq5 | 
//|                                  Copyright  2016, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\MQL5\Include         |
//+---------------------------------------------------------------------+ 
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.60"
//----     
#property indicator_separate_window
//----    2
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                         //        
#define INDICATOR_NAME "StochasticDiff"        //    
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_COLOR_HISTOGRAM
//----     
#property indicator_color1 clrLime,clrDeepSkyBlue,clrGray,clrMagenta,clrRed
//----   -  
#property indicator_style1  STYLE_SOLID
//----     3
#property indicator_width1  3
//----   
#property indicator_label1  INDICATOR_NAME
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Smooth_Method
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;// 
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int KPeriod=5;
input int DPeriod=3;
input int Slowing=3;
input ENUM_MA_METHOD iMA_Method=MODE_SMA;
input ENUM_STO_PRICE Price_field=STO_LOWHIGH;
input Smooth_Method XMA_Method=MODE_T3;        //  
input uint XLength=13;                         //                     
input int XPhase=15;                           // ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input int Shift=0;                             //     
//+----------------------------------------------+
//----   ,    
//      
double IndBuffer[],ColorIndBuffer[];
//----  
string Symbol_,Word;
//----      
int min_rates_total;
//----      
int Ind_Handle;
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("    StochasticDiff       ");
      return(INIT_FAILED);
     }

//----   
   min_rates_total=2;
   Symbol_=Symbol();
   Word=INDICATOR_NAME+" : "+Symbol_+StringSubstr(EnumToString(_Period),7,-1);

//----    StochasticDiff
   Ind_Handle=iCustom(Symbol_,TimeFrame,"StochasticDiff",KPeriod,DPeriod,Slowing,iMA_Method,Price_field,XMA_Method,XLength,XPhase,0);
   if(Ind_Handle==INVALID_HANDLE)
    {
     Print("      StochasticDiff");
     return(INIT_FAILED);
    }

//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(IndBuffer,true);

//----     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorIndBuffer,true);

//---           
   IndicatorSetString(INDICATOR_SHORTNAME,INDICATOR_NAME);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,6);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);

//----    
   double Ind[1],Col[1];
   int limit,bar;
   datetime IndTime[1];
   static double LastInd=0.0;
   static uint LastCountBar;

//----      
//  limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      LastCountBar=rates_total;
     }
   else limit=int(LastCountBar)+rates_total-prev_calculated; //       

//----         
   ArraySetAsSeries(time,true);

//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----      
      IndBuffer[bar]=EMPTY_VALUE;

      //----       IndTime
      if(CopyTime(Symbol_,TimeFrame,time[bar],1,IndTime)<=0) return(RESET);
      
      if(time[bar]>=IndTime[0] && time[bar+1]<IndTime[0])
        {
         LastCountBar=bar;
         
         //----      
         if(CopyBuffer(Ind_Handle,0,time[bar],1,Ind)<=0) return(RESET);
         if(CopyBuffer(Ind_Handle,1,time[bar],1,Col)<=0) return(RESET);
         
         IndBuffer[bar]=Ind[0];
         ColorIndBuffer[bar]=Col[0]; 
        }
      else
        {
         IndBuffer[bar]=IndBuffer[bar+1];
         ColorIndBuffer[bar]=ColorIndBuffer[bar+1]; 
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
