//+---------------------------------------------------------------------+ 
//|                                                      dTrend_HTF.mq5 | 
//|                                  Copyright  2016, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\MQL5\Include         |
//+---------------------------------------------------------------------+ 
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.60"
//----     
#property indicator_separate_window
//----    4
#property indicator_buffers 4 
//----     
#property indicator_plots   2
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                             //        
#define INDICATOR_NAME "dTrend"             //    
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_plots   2
//----      
#property indicator_type1   DRAW_COLOR_HISTOGRAM
#property indicator_type2   DRAW_COLOR_HISTOGRAM
#property indicator_color1  clrGreen,clrLime
#property indicator_color2  clrPurple,clrMagenta
#property indicator_width1  2
#property indicator_width2  2
#property indicator_label1  "dTrend Upper"
#property indicator_label2  "dTrend Lower"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;// 
input uint Rasrad=16;
input uint Level=15;                      // 
input int Shift=0;                        //     
//+----------------------------------------------+
//----   ,    
//      
double IndBuffer1[],ColorIndBuffer1[];
double IndBuffer2[],ColorIndBuffer2[];
//----  
string Symbol_,Word;
//----      
int min_rates_total;
//----      
int Ind_Handle;
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("    dTrend       ");
      return(INIT_FAILED);
     }

//----   
   min_rates_total=2;
   Symbol_=Symbol();
   Word=INDICATOR_NAME+" : "+Symbol_+StringSubstr(EnumToString(_Period),7,-1);

//----    dTrend
   Ind_Handle=iCustom(Symbol_,TimeFrame,"dTrend",Rasrad,Level,0);
   if(Ind_Handle==INVALID_HANDLE)
    {
     Print("      dTrend");
     return(INIT_FAILED);
    }

//----      
   SetIndexBuffer(0,IndBuffer1,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(IndBuffer1,true);

//----     ,     
   SetIndexBuffer(1,ColorIndBuffer1,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorIndBuffer1,true);
   
//----      
   SetIndexBuffer(2,IndBuffer2,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(IndBuffer2,true);

//----     ,     
   SetIndexBuffer(3,ColorIndBuffer2,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorIndBuffer2,true);

//---           
   IndicatorSetString(INDICATOR_SHORTNAME,INDICATOR_NAME);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);

//----      2  
   IndicatorSetInteger(INDICATOR_LEVELS,2);
//----       
   IndicatorSetDouble(INDICATOR_LEVELVALUE,0,+Level);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,1,-Level);
//----             
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,clrBlue);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,clrRed);
//----       -  
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,STYLE_DASHDOTDOT);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);

//----    
   double Ind[1],Col[1];
   int limit,bar;
   datetime IndTime[1];
   static double LastInd=0.0;
   static uint LastCountBar;

//----      
//  limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      LastCountBar=rates_total;
     }
   else limit=int(LastCountBar)+rates_total-prev_calculated; //       

//----         
   ArraySetAsSeries(time,true);

//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----      
      IndBuffer1[bar]=EMPTY_VALUE;
      IndBuffer2[bar]=EMPTY_VALUE;

      //----       IndTime
      if(CopyTime(Symbol_,TimeFrame,time[bar],1,IndTime)<=0) return(RESET);
      
      if(time[bar]>=IndTime[0] && time[bar+1]<IndTime[0])
        {
         LastCountBar=bar;
         
         //----      
         if(CopyBuffer(Ind_Handle,0,time[bar],1,Ind)<=0) return(RESET);
         if(CopyBuffer(Ind_Handle,1,time[bar],1,Col)<=0) return(RESET);        
         IndBuffer1[bar]=Ind[0];
         ColorIndBuffer1[bar]=Col[0]; 
         
         //----      
         if(CopyBuffer(Ind_Handle,2,time[bar],1,Ind)<=0) return(RESET);
         if(CopyBuffer(Ind_Handle,3,time[bar],1,Col)<=0) return(RESET);
         
         IndBuffer2[bar]=Ind[0];
         ColorIndBuffer2[bar]=Col[0]; 
        }
      else
        {
         IndBuffer1[bar]=IndBuffer1[bar+1];
         ColorIndBuffer1[bar]=ColorIndBuffer1[bar+1];
         
         IndBuffer2[bar]=IndBuffer2[bar+1];
         ColorIndBuffer2[bar]=ColorIndBuffer2[bar+1];  
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
