//+------------------------------------------------------------------+
//|                                                       dTrend.mq5 |
//|                                                     Yuriy Tokman |
//|                                            yuriytokman@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Yuriy Tokman"
#property link      "yuriytokman@gmail.com"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window 
//----   
#property indicator_buffers 4 
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_plots   2
//----      
#property indicator_type1   DRAW_COLOR_HISTOGRAM
#property indicator_type2   DRAW_COLOR_HISTOGRAM
#property indicator_color1  clrGreen,clrLime
#property indicator_color2  clrPurple,clrMagenta
#property indicator_width1  2
#property indicator_width2  2
#property indicator_label1  "dTrend Upper"
#property indicator_label2  "dTrend Lower"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint Rasrad=16;
input uint Level=15; //  
input int Shift=0;   //      
//+-----------------------------------+
//----  
double UpColorsBuffer[];
double LoColorsBuffer[];
double UpperBuffer[];
double LowerBuffer[];

int min_rates_total; 
//+------------------------------------------------------------------+    
//| Momentum indicator initialization function                       | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=int(Rasrad)+1;
//----   
   SetIndexBuffer(0,UpperBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,UpColorsBuffer,INDICATOR_COLOR_INDEX);
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   SetIndexBuffer(2,LowerBuffer,INDICATOR_DATA);
   SetIndexBuffer(3,LoColorsBuffer,INDICATOR_COLOR_INDEX);
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----      
   string shortname;
   StringConcatenate(shortname,"dTrend(Rasrad=",Rasrad,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);  
//----      2  
   IndicatorSetInteger(INDICATOR_LEVELS,2);
//----       
   IndicatorSetDouble(INDICATOR_LEVELVALUE,0,+Level);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,1,-Level);
//----             
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,clrBlue);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,clrRed);
//----       -  
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,STYLE_DASHDOTDOT);
//----  
  }
//+------------------------------------------------------------------+  
//| Momentum iteration function                                      | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----       
   double price;
//----        
   int first,bar,count;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_total; //      
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      price=high[bar];
      if(price>high[bar-1])
        {
         count=1;
         while(price>high[bar-count])
           {
            count++;
            if(count>int(Rasrad)) break;
           }
         UpperBuffer[bar]=count-1;
        }
      else UpperBuffer[bar]=NULL; 

      price=low[bar];

      if(price<low[bar-1])
        {
         count=1;
         while(price<low[bar-count])
           {
            count++;
            if(count>int(Rasrad)) break;
           }
         LowerBuffer[bar]=1-count;
        }
      else LowerBuffer[bar]=NULL;
      //----     
      if(UpperBuffer[bar]>=+Level) UpColorsBuffer[bar]=1;
      else UpColorsBuffer[bar]=0; 
      //----
      if(LowerBuffer[bar]<=-Level) LoColorsBuffer[bar]=1;
      else LoColorsBuffer[bar]=0; 
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+ 
