//+------------------------------------------------------------------+
//|                                                    TPEHEP_MM.mq4 |
//|                                                   Copyright 2016.|
//+------------------------------------------------------------------+
#property link      "Fedor10_10@mail.ru"
#property version   "1.02"
#property strict
#property indicator_chart_window
#property description " TPEHEP_MM    "
#property description "       "
#property description " , ,     Excel."
#property description "   :  'B'- BUY,  'S'- SELL,  'C'- CLOSE"
#property description "                                   F12  Step-    1 "
#property description "                                   '<'-  , '>'-  "
#property description "                                   'P'-   "
extern string K="+:+:+:+";     //  
input bool    Traid=true;      ///
input double  Lots=0.01;       //   
extern double Risk=0.0;        // %  StopLoss. 0-  
input double  LotsMax=10.0;    // 
extern double StopLoss=100.0;  //StopLoss ( 5-)
extern double TakeProfit=100.0;//TakeProfit ( 5-)
extern double Money=100.0;     // 
extern double Spread=0.0;      // ( 5-) 0 -  
extern double Freeze=0.0;      // ( 5-) 0 -  
extern string M="+:+:+:+";     //
input bool    Color=true;      // /
input bool    Vertical=true;   ///  
input bool    Alerts=false;    // 
input bool    Gluk=false;      //   Exel
input int     Step=46;         //    1 
color  Zone,OpBUY,OpSELL,ClsAll,TakePr,StopLs;
int    tik,bar0,Ordr,Tr,SH,file;
double Ask0,Ask1,Bid0,Bid1,Lev,LevOrd,LevUp,LevDn,lott,MaxLot,MinLot;
string FileName,FileNamo,Namo,Uplev,Oplev,Dnlev;
long   result,resold;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   if(Color)// 
     {
      Zone=clrSilver;      //   
      OpBUY=clrSteelBlue;  //  BUY
      OpSELL=clrPlum;      //  SELL
      ClsAll=clrDarkOrange;//   
      TakePr=clrLimeGreen; //    TakeProfit
      StopLs=clrYellow;    //    StopLoss
        }else{// 
      Zone=clrDimGray;     //   
      OpBUY=clrLightSkyBlue;//  BUY
      OpSELL=clrLightPink; //  SELL
      ClsAll=clrKhaki;     //   
      TakePr=clrPaleGreen; //    TakeProfit
      StopLs=clrYellow;    //    StopLoss
     }
   FileName=Symbol()+"."+IntegerToString(Period())+" ";//    
   if(Traid)//    
     {
      if(Spread==0.0) Spread=MarketInfo(Symbol(),MODE_SPREAD);//
      if(Spread==0.0) Alert("Spread "," ");
      Spread=NormalizeDouble((Spread*Point),Digits);//
      if(Freeze==0.0) Freeze=MarketInfo(Symbol(),MODE_FREEZELEVEL);// 
      if(Freeze==0.0) Alert("  "," ");
      Freeze=NormalizeDouble((Freeze*Point),Digits);// 
      Lev=NormalizeDouble((MarketInfo(Symbol(),MODE_STOPLEVEL)*Point),Digits);// 
      if(Lev==0.0) Alert("STOPLEVEL "," ");
      else
        {
         if(StopLoss<Lev) {StopLoss=Lev; Alert("StopLoss=",StopLoss/Point);}
         if(TakeProfit<Lev) {TakeProfit=Lev; Alert("TakeProfit=",TakeProfit/Point);}
        }
      TakeProfit=NormalizeDouble((TakeProfit*Point),Digits);//TakeProfit
      StopLoss=NormalizeDouble((StopLoss*Point),Digits);//StopLoss
      Risk=(Risk/100)/(StopLoss/Point);//   MM
      MinLot=NormalizeDouble((MarketInfo(Symbol(),MODE_MINLOT)),Digits);// 
      if(MinLot>0.0) MinLot=fmax(Lots,MinLot); else MinLot=Lots;
      MaxLot=NormalizeDouble((MarketInfo(Symbol(),MODE_MAXLOT)),Digits);// 
      if(MaxLot>0.0) MaxLot=fmin(LotsMax,MaxLot); else MaxLot=LotsMax;
      lott=Lot();
      Comment("Spread=",IntegerToString(int(Spread/Point)),"\n","Freeze=",IntegerToString(int(Freeze)),"\n",
              "StopLoss=",IntegerToString(int(StopLoss/Point)),"\n","TakeProfit=",
              IntegerToString(int(TakeProfit/Point)),"\n","MINLOT=",MinLot,"\n","MAXLOT=",MaxLot);
      ChartGetInteger(0,CHART_WIDTH_IN_PIXELS,0,result);//   
      ObjectCreate("Show1",OBJ_LABEL,0,0,0); //   
      ObjectSet("Show1",OBJPROP_XDISTANCE,result/2-200);
      ObjectSet("Show1",OBJPROP_YDISTANCE,0);
      ObjectSet("Show1",OBJPROP_CORNER,0);
      ObjectSetText("Show1",":          :               :               ",14,"Arial",clrDarkGray);//
      ObjectCreate("Show2",OBJ_LABEL,0,0,0); //   
      ObjectSet("Show2",OBJPROP_XDISTANCE,result/2-155);
      ObjectSet("Show2",OBJPROP_YDISTANCE,0);
      ObjectSet("Show2",OBJPROP_CORNER,0);
      ObjectSetText("Show2",DoubleToString(lott,2),14,"Arial",clrBlueViolet);//
      ObjectCreate("Show3",OBJ_LABEL,0,0,0); //   
      ObjectSet("Show3",OBJPROP_XDISTANCE,result/2-15);
      ObjectSet("Show3",OBJPROP_YDISTANCE,0);
      ObjectSet("Show3",OBJPROP_CORNER,0);
      ObjectSetText("Show3",DoubleToString(0.0,2),14,"Arial",clrBlueViolet);//
      ObjectCreate("Show4",OBJ_LABEL,0,0,0); //   
      ObjectSet("Show4",OBJPROP_XDISTANCE,result/2+140);
      ObjectSet("Show4",OBJPROP_YDISTANCE,0);
      ObjectSet("Show4",OBJPROP_CORNER,0);
      ObjectSetText("Show4",DoubleToString(Money,2),14,"Arial",clrBlueViolet);//
      resold=result;
      file=FileOpen(FileName,FILE_WRITE|FILE_SHARE_READ|FILE_TXT);
      FileWrite(file,"  Ticket\tOpnDate\tOpnTime\t    Type\t    Size\t   Item\t  Price\tClsDate\tClsTime\t  Price\tTradeP/L\t  Equity");
     }
   ObjectCreate("Zona",OBJ_TREND,0,Time[0],(Close[0]-StopLoss),Time[0],(Close[0]+StopLoss));//   
   ObjectSet("Zona",OBJPROP_STYLE,DRAW_LINE);
   ObjectSet("Zona",OBJPROP_WIDTH,8);
   ObjectSet("Zona",OBJPROP_COLOR,Zone);
   ObjectSet("Zona",OBJPROP_BACK,true);
   ObjectSet("Zona",OBJPROP_RAY_RIGHT,false);
   ObjectSet("Zona",OBJPROP_TIME1,Time[0]);//
   ObjectSet("Zona",OBJPROP_PRICE1,(Close[0]-StopLoss));//
   ObjectSet("Zona",OBJPROP_TIME2,Time[0]);//
   ObjectSet("Zona",OBJPROP_PRICE2,(Close[0]+StopLoss));//
   ChartRedraw(); //
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   if(Traid) FileClose(file);//  
   ObjectDel();
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   return(rates_total);//
  }
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,         //  
                  const long& lparam,   //    long
                  const double& dparam, //    double
                  const string& sparam) //    string
  {
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
   if(CHARTEVENT_CHART_CHANGE)
     {
      ChartGetInteger(0,CHART_WIDTH_IN_PIXELS,0,result);//   
      if(result!=resold) Show(result);
     }
   if(Traid && Ordr!=0)
     {
      if(id==CHARTEVENT_OBJECT_DRAG)
        {
         if(sparam==Uplev)//  
            if(LevUp!=ObjectGet(Uplev,OBJPROP_PRICE1))
               LevUp=MouseUp();//  
         if(sparam==Dnlev)//  
            if(LevDn!=ObjectGet(Dnlev,OBJPROP_PRICE1))
               LevDn=MouseDn();//  
        }
     }
   if(id==CHARTEVENT_KEYDOWN)
     {
      switch(int(lparam))
        {
         case 37: Alert("  "); break;//KEY_LEFT_ARROW
         case 39: Alert("   F12"); break;//KEY_RIGHT_ARROW  F12
         case 66: if(Traid)
           {
            if(Ordr==0)//KEY_BUY
              {
               Ordr=bar0;
               Levl("BUY");//    
               if(Vertical) Vert("BUY",OpBUY);//   BUY
              }
            else Alert("  ");
           }
         else if(Tr!=1){Tr=1; Vert("BUY",OpBUY);}//   BUY
         else Alert("   ");
         tik++; if(tik==1) {Namo=TimeToString(Time[Bar()],TIME_DATE); Comment("");}
         break;
         case 67: if(Traid)
           {
            if(Ordr!=0)//KEY_CLOSE
              {
               if(Freez()) break;//  
               if(Vertical) Vert("CL",ClsAll);//   Cls
               Profit("CL",Ordr);// 
               Ordr=0; if(Traid) Delet();// 
              }
            else Alert(" ");
           }
         else if(Tr!=0) {Tr=0; Vert("CL",ClsAll);}//   Cls
         else Alert("  ");
         break;
         case 80:
            if(tik<1)// 
              {
               ObjectsDeleteAll();  Comment("");
               if(ChartSaveTemplate(0,FileName+"."))
                  Alert(" ",FileName," "); break;
              }
            else
              {
               ObjectDel();
               FileNamo=FileName+Namo+"-"+TimeToString(Time[Bar()],TIME_DATE);
               if(Traid)//  
                 {
                  FileFlush(file); FileClose(file);
                  if(FileMove(FileName,0,FileNamo+".xls",FILE_REWRITE))
                     Alert(" ",FileNamo," ");
                  if(ChartSaveTemplate(0,FileNamo+"."))//  
                     Alert(" ",FileNamo," "); break;
                 }
               else//  
                 {
                  if(ChartSaveTemplate(0,FileNamo+"."))
                     Alert(" ",FileNamo," "); break;
                 }
              }
         case 83: if(Traid)
           {
            if(Ordr==0)//KEY_SELL
              {
               Ordr=-bar0;
               Levl("SEL");//    
               if(Vertical) Vert("SEL",OpSELL);//   SELL
              }
            else Alert("  ");
           }
         else if(Tr!=-1) {Tr=-1; Vert("SEL",OpSELL);}//   SELL
         else Alert("   ");
         tik++; if(tik==1) {Namo=TimeToString(Time[Bar()],TIME_DATE); Comment("");}
         break;
         case 188: SH++;//KEY_LEFT
         if(SH>WindowBarsPerChart()){Alert("   "); SH=WindowBarsPerChart();}
         break;//   
         case 190: SH--;//KEY_RIGHT
         if(SH<0){Alert("   "); SH=0;}
         break;//    
         default: if(lparam==Step) {ChartNavigate(0,CHART_CURRENT_POS,1); break;}//KEY_Shift
         else Alert("   ",(lparam));
        }
     }
   if(Bar()<=0) {if(tik>0) Alert("  "); return;}//  
   bar0=Bar()+SH;//    
   if(Time[bar0]!=ObjectGet("Zona",OBJPROP_TIME1))//  
     {
      Bid0=Close[bar0]; Ask0=Close[bar0]+Spread;//   
      Bid1=Open[bar0-1]; Ask1=Open[bar0-1]+Spread;//   
      LevStop();//    
      Prof();// 
      ObjectSet("Zona",OBJPROP_TIME1,Time[bar0]);//   
      ObjectSet("Zona",OBJPROP_PRICE1,(Close[bar0]-StopLoss+Spread));//    
      ObjectSet("Zona",OBJPROP_TIME2,Time[bar0]);//   
      ObjectSet("Zona",OBJPROP_PRICE2,(Close[bar0]+StopLoss-Spread));//    
      ChartRedraw();//
     }
  }
//+------------------------------------------------------------------+
//|                                                        |
//+------------------------------------------------------------------+
void LevStop()//   
  {
   if(Ordr>0)// BUY
     {
      if(Low[bar0]<=LevDn)//   
        {
         if(Vertical) Vert("SL",StopLs);
         if(Traid) {Profit("SL",Ordr); Delet();}
         if(Alerts) Alert(" StopLoss");
         Ordr=0;
        }
      if(High[bar0]>=LevUp)//   
        {
         if(Vertical) Vert("TP",TakePr);
         if(Traid) {Profit("TP",Ordr); Delet();}
         if(Alerts) Alert(" TakeProfit");
         Ordr=0;
        }
     }
   if(Ordr<0)// SELL
     {
      if(High[bar0]+Spread>=LevUp)//   
        {
         if(Vertical) Vert("SL",StopLs);
         if(Traid) {Profit("SL",Ordr); Delet();}
         if(Alerts) Alert(" StopLoss");
         Ordr=0;
        }
      if(Low[bar0]+Spread<=LevDn)//   
        {
         if(Vertical) Vert("TP",TakePr);
         if(Traid) {Profit("TP",Ordr); Delet();}
         if(Alerts) Alert(" TakeProfit");
         Ordr=0;
        }
     }
  }
//+------------------------------------------------------------------+
double Lot()//MoneyManagement
  {
   if(Risk>0.0)
     {
      double LotResult=Money*Risk;// 
      LotResult=fmax(LotResult,MinLot);// 
      LotResult=fmin(LotResult,MaxLot);//  
      return(LotResult);// 
     }
   else return(MinLot);
  }
//+------------------------------------------------------------------+
void Profit(string cmd,int ord)//
  {
   if(ord>0)// BUY   Bid-Ask
     {
      if(cmd=="CL") Write("CL_BUY",ord,Time[bar0-1],Bid1,NormalizeDouble(Bid1-LevOrd,Digits));//Man
      if(cmd=="SL") Write("SL_BUY",ord,Time[bar0],LevDn,NormalizeDouble(LevDn-LevOrd,Digits));//SL
      if(cmd=="TP") Write("TP_BUY",ord,Time[bar0],LevUp,NormalizeDouble(LevUp-LevOrd,Digits));//TP
     }
   if(ord<0)// SELL  Ask-Bid
     {
      if(cmd=="CL") Write("CL_SEL",ord,Time[bar0-1],Ask1,NormalizeDouble(LevOrd-Ask1,Digits));//Man
      if(cmd=="SL") Write("SL_SEL",ord,Time[bar0],LevUp,NormalizeDouble(LevOrd-LevUp,Digits));//SL
      if(cmd=="TP") Write("TP_SEL",ord,Time[bar0],LevDn,NormalizeDouble(LevOrd-LevDn,Digits));//TP
     }
  }
//+------------------------------------------------------------------+
void Write(string cmd,int ord,datetime tm,double cls,double pip)//  
  {
   Money+=NormalizeDouble(lott*(pip/Point),2);//   
   FileWrite(file,tik,"\t",Dat(TimeToStr(Time[fabs(ord)],TIME_DATE)),"\t",TimeToStr(Time[fabs(ord)],TIME_SECONDS),
             "\t",cmd,"\t",Rus(DoubleToString(lott,2)),"\t",Symbol(),"\t",Rus(DoubleToString(LevOrd,Digits)),
             "\t",Dat(TimeToStr(tm,TIME_DATE)),"\t",TimeToStr(tm,TIME_SECONDS),"\t",Rus(DoubleToString(cls,Digits)),
             "\t",Rus(DoubleToString(lott*(pip/Point),2)),"\t",Rus(DoubleToString(Money,2)));
   lott=Lot();// 
   ObjectSetText("Show2",DoubleToString(lott,2),14,"Arial",clrBlueViolet);
   Trend(cmd,ord,pip); Metca(cmd,ord);// 
  }
//+------------------------------------------------------------------+
void Trend(string cmd,int ord,double pip)//     
  {
   string name="Trl"+IntegerToString(tik);
   color clr=clrBlue; if(pip<0) clr=clrRed;
   if(cmd=="CL_BUY") Tr(name, ord,Bid1,Time[bar0-1],clr);//Man
   if(cmd=="SL_BUY") Tr(name, ord,LevDn,Time[bar0], clr);//SL
   if(cmd=="TP_BUY") Tr(name, ord,LevUp,Time[bar0], clr);//TP
   if(cmd=="CL_SEL") Tr(name,-ord,Ask1,Time[bar0-1],clr);//Man
   if(cmd=="SL_SEL") Tr(name,-ord,LevUp,Time[bar0], clr);//SL
   if(cmd=="TP_SEL") Tr(name,-ord,LevDn,Time[bar0], clr);//TP
  }
//+------------------------------------------------------------------+
void Tr(string cmd,int ord,double pr,datetime tm,color clr)//     
  {
   ObjectCreate(cmd,OBJ_TREND,0,Time[ord-1],LevOrd,tm,pr);
   ObjectSetInteger(0,cmd,OBJPROP_RAY_RIGHT,false);// (false)   
   ObjectSet(cmd,OBJPROP_STYLE,STYLE_DOT);
   ObjectSet(cmd,OBJPROP_COLOR,clr);
   ChartRedraw();//
  }
//+------------------------------------------------------------------+
void Metca(string cmd,int ord)//  
  {
   if(cmd=="CL_BUY")
     {
      Met("OP_BUY"+IntegerToString(tik),LevOrd+5*Point,Time[ord-1],OpBUY);//Open BUY
      Met("CL_BUY"+IntegerToString(tik),Bid1+5*Point,Time[bar0-1],ClsAll);//Man BUY
     }
   if(cmd=="SL_BUY")
     {
      Met("OP_BUY"+IntegerToString(tik),LevOrd+5*Point,Time[ord-1],OpBUY);//Open BUY
      Met("SL_BUY"+IntegerToString(tik),LevDn+5*Point,Time[bar0],StopLs);//SL BUY
     }
   if(cmd=="TP_BUY")
     {
      Met("OP_BUY"+IntegerToString(tik),LevOrd+5*Point,Time[ord-1],OpBUY);//Open BUY
      Met("TP_BUY"+IntegerToString(tik),LevUp+5*Point,Time[bar0],TakePr);//TP BUY
     }
   if(cmd=="CL_SEL")
     {
      Met("OP_SELL"+IntegerToString(tik),LevOrd+5*Point,Time[-ord-1],OpSELL);//Open SELL
      Met("CL_SELL"+IntegerToString(tik),Ask1+5*Point,Time[bar0-1],ClsAll);//Man SELL
     }
   if(cmd=="SL_SEL")
     {
      Met("OP_SELL"+IntegerToString(tik),LevOrd+5*Point,Time[-ord-1],OpSELL);//Open SELL
      Met("SL_SELL"+IntegerToString(tik),LevUp+5*Point,Time[bar0],StopLs);//SL SELL
     }
   if(cmd=="TP_SEL")
     {
      Met("OP_SELL"+IntegerToString(tik),LevOrd+5*Point,Time[-ord-1],OpSELL);//Open SELL
      Met("TP_SELL"+IntegerToString(tik),LevDn+5*Point,Time[bar0],TakePr);//TP SELL
     }
  }
//+------------------------------------------------------------------+
void Met(string cmd,double pr,datetime tm,color clr)//  
  {
   ObjectCreate(cmd,OBJ_ARROW_LEFT_PRICE,0,tm,pr);
   ObjectSet(cmd,OBJPROP_ARROWCODE,119);
   ObjectSet(cmd,OBJPROP_STYLE,STYLE_SOLID);
   ObjectSet(cmd,OBJPROP_COLOR,clr);
   ChartRedraw();//
  }
//+------------------------------------------------------------------+
void Vert(string cmd,color clr)//  
  {
   cmd+=IntegerToString(tik);
   ObjectCreate(cmd,OBJ_VLINE,0,Time[bar0],0);
   ObjectSet(cmd,OBJPROP_STYLE,STYLE_DASH);
   ObjectSet(cmd,OBJPROP_COLOR,clr);
   ObjectSet(cmd,OBJPROP_BACK,true);
   ChartRedraw();//
  }
//+------------------------------------------------------------------+
void Levl(string cmd)//   
  {
   Oplev=cmd;
   if(cmd=="BUY")
     {
      LevOrd=Ask1;// Ask 
      Uplev="TakeProfit"; LevUp=LevOrd+TakeProfit;// Bid StopLoss  
      Dnlev="StopLoss"; LevDn=LevOrd-StopLoss;// Bid TakeProfit  
     }
   if(cmd=="SEL")
     {
      LevOrd=Bid1;// Bid 
      Uplev="StopLoss"; LevUp=LevOrd+StopLoss;// Ask TakeProfit  
      Dnlev="TakeProfit"; LevDn=LevOrd-TakeProfit;// Ask StopLoss  
     }
   ObjectCreate(Uplev,OBJ_HLINE,0,0,LevUp);
   ObjectSet(Uplev,OBJPROP_STYLE,STYLE_DASHDOT);
   ObjectSet(Uplev,OBJPROP_COLOR,clrOrangeRed);
   ObjectSetInteger(0,Uplev,OBJPROP_BACK,true);
   ObjectCreate(Oplev,OBJ_HLINE,0,0,LevOrd);
   ObjectSet(Oplev,OBJPROP_STYLE,STYLE_DASHDOT);
   ObjectSet(Oplev,OBJPROP_COLOR,clrLimeGreen);
   ObjectSetInteger(0,Oplev,OBJPROP_BACK,true);
   ObjectCreate(Dnlev,OBJ_HLINE,0,0,LevDn);
   ObjectSet(Dnlev,OBJPROP_STYLE,STYLE_DASHDOT);
   ObjectSet(Dnlev,OBJPROP_COLOR,clrOrangeRed);
   ObjectSetInteger(0,Dnlev,OBJPROP_BACK,true);
   ChartRedraw();//
  }
//+------------------------------------------------------------------+
string Rus(string ru)// (.)(,)  Excel
  {
   if(Gluk) StringReplace(ru,".",",");
   return ru;
  }
//+------------------------------------------------------------------+
string Dat(string dt)// (.)(,)  Excel
  {
   if(Gluk) StringReplace(dt,"."," ");
   return dt;
  }
//+------------------------------------------------------------------+
void Prof()// 
  {
   double rezalt;
   if(Ordr>0)
     {
      rezalt=lott*(Bid1-LevOrd)/Point;//      
      if(Money+rezalt<0.0 || Money+lott*(Low[bar0]-LevOrd)/Point<0.0) End();// 
     }
   else if(Ordr<0)
     {
      rezalt=lott*(LevOrd-Ask1)/Point;//      
      if(Money+rezalt<0.0 || Money+lott*(LevOrd-High[bar0]+Spread)/Point<0.0) End();// 
     }
   else rezalt=0.0;
   color Cl=clrBlueViolet; if(rezalt<0.0) Cl=clrCrimson;// 
   ObjectSetText("Show3",DoubleToString(rezalt,2),14,"Arial",Cl);//
   ObjectSetText("Show4",DoubleToString((Money+rezalt),2),14,"Arial",clrBlueViolet);// 
  }
//+------------------------------------------------------------------+
bool Freez()//
  {
   if(Ordr>0)
     {
      if(LevUp<=Bid0+Freeze)
        {
         Alert("TakeProfit   ");
         return(true);
        }
      if(LevDn>=Bid0-Freeze)
        {
         Alert("StopLoss   ");
         return(true);
        }
     }
   if(Ordr<0)
     {
      if(LevUp<=Ask0+Freeze)
        {
         Alert("StopLoss   ");
         return(true);
        }
      if(LevDn>=Ask0-Freeze)
        {
         Alert("TakeProfit   ");
         return(true);
        }
     }
   return(false);
  }
//+------------------------------------------------------------------+
int Bar()//     .
  {
   long res=0;//  
   res+=ChartGetInteger(0,CHART_FIRST_VISIBLE_BAR,0,res);//    
   res-=WindowBarsPerChart()+1;//   
   return(int(res));//---    
  }
//+------------------------------------------------------------------+
void Delet()// 
  {
   ObjectDelete(Uplev);//  
   ObjectDelete(Oplev);//  
   ObjectDelete(Dnlev);//  
   ChartRedraw();//
  }
//+------------------------------------------------------------------+
double MouseUp()
  {
   if(Freez()) ObjectSet(Uplev,OBJPROP_PRICE1,LevUp);//    
   else
     {
      if(Ordr>0 && ObjectGet(Uplev,OBJPROP_PRICE1)<=Ask0+Lev)//    
        {
         Alert("TakeProfit= ",Lev,"+1");
         ObjectSet(Uplev,OBJPROP_PRICE1,(Ask0+Lev+Point));// TakeProfit  
        }
      if(Ordr<0 && ObjectGet(Uplev,OBJPROP_PRICE1)<=Bid0+Lev)//    
        {
         Alert("StopLoss= ",Lev,"+1");
         ObjectSet(Uplev,OBJPROP_PRICE1,(Bid0+Lev+Point));// StopLoss  
        }
     }
// ObjectSetInteger(0,Uplev,OBJPROP_SELECTED,false);//
   ChartRedraw();//
   return(ObjectGet(Uplev,OBJPROP_PRICE1));//   
  }
//+------------------------------------------------------------------+
double MouseDn()
  {
   if(Freez()) ObjectSet(Dnlev,OBJPROP_PRICE1,LevDn);//    
   else
     {
      if(Ordr>0 && ObjectGet(Dnlev,OBJPROP_PRICE1)>=Ask0-Lev)//    
        {
         Alert("StopLoss= ",Lev,"+1");
         ObjectSet(Dnlev,OBJPROP_PRICE1,(Ask0-Lev-Point));// StopLoss  
        }
      if(Ordr<0 && ObjectGet(Dnlev,OBJPROP_PRICE1)>=Bid0-Lev)//    
        {
         Alert("StopLoss= ",Lev,"+1");
         ObjectSet(Dnlev,OBJPROP_PRICE1,(Bid0-Lev-Point));// TakeProfit  
        }
     }
//ObjectSetInteger(0,Dnlev,OBJPROP_SELECTED,false);//
   ChartRedraw();//
   return(ObjectGet(Dnlev,OBJPROP_PRICE1));//   
  }
//+------------------------------------------------------------------+
void Show(long res)//   
  {
   ObjectSet("Show1",OBJPROP_XDISTANCE,res/2-200);
   ObjectSet("Show2",OBJPROP_XDISTANCE,res/2-155);
   ObjectSet("Show3",OBJPROP_XDISTANCE,res/2-15);
   ObjectSet("Show4",OBJPROP_XDISTANCE,res/2+140);
   ChartRedraw();//
   resold=result;
  }
//+------------------------------------------------------------------+
void End()//
  {
   ObjectDel();
   ObjectCreate("Show7",OBJ_LABEL,0,0,0); //   
   ObjectSet("Show7",OBJPROP_XDISTANCE,result/2-275);
   ObjectSet("Show7",OBJPROP_YDISTANCE,350);
   ObjectSet("Show7",OBJPROP_CORNER,0);
   ObjectSetText("Show7","  ()    !",14,"Arial",clrDarkGray);// GAME OVER
   ObjectCreate("Show8",OBJ_LABEL,0,0,0); //   
   ObjectSet("Show8",OBJPROP_XDISTANCE,result/2-500);
   ObjectSet("Show8",OBJPROP_YDISTANCE,50);
   ObjectSet("Show8",OBJPROP_CORNER,0);
   ObjectSetText("Show8","GAME OVER",125,"Arial",clrBrown);// GAME OVER
  }
//+------------------------------------------------------------------+
void ObjectDel()
  {
   ObjectDelete("Zona");
   ObjectDelete("Show1");
   ObjectDelete("Show2");
   ObjectDelete("Show3");
   ObjectDelete("Show4");
   ObjectDelete("Show5");
   ObjectDelete("Show6");
   ChartRedraw();//
  }
//+------------------------------------------------------------------+
