//+---------------------------------------------------------------------+ 
//|                                                    WmiVol_Pluse.mq5 | 
//|                                     Copyright 2014, Murad Ismayilov | 
//|                                  http://www.mql4.com/ru/users/wmlab | 
//+---------------------------------------------------------------------+ 
#property copyright "Copyright 2014, Murad Ismayilov"
#property link      "http://www.mql4.com/ru/users/wmlab" 
//----   
#property version   "1.00"
//----     
#property indicator_separate_window 
//----    2
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//----      
#property indicator_color1 clrDodgerBlue,clrMagenta
//----   - 
#property indicator_style1 STYLE_SOLID
//----     2
#property indicator_width1 2
//----   
#property indicator_label1 "WmiVol_Pluse"

#property indicator_maximum    1.1
#property indicator_minimum    0.0
//+-----------------------------------+
//|         |
//+-----------------------------------+
input ENUM_TIMEFRAMES TimeFrame=PERIOD_D1;         //
//+-----------------------------------+
//----      
int min_rates_total;
//----   ,    
//      
double IndBuffer[],ColorIndBuffer[];
double barVols[],avgVol;
int barsInDay,barCounts[];
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| WmiVol_Pluse indicator initialization function                   | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   if(Period()>=TimeFrame) 
     {
      Print(__FUNCTION__+"():     ,  "+GetStringTimeframe(TimeFrame));
      Print(__FUNCTION__+"():           <<TimeFrame>>!");
      return(INIT_FAILED);
     }
   barsInDay=PeriodSeconds(TimeFrame)/(PeriodSeconds(PERIOD_CURRENT));
   if(!barsInDay) return(INIT_FAILED);
   min_rates_total=barsInDay;

//----       
   if(ArrayResize(barCounts,barsInDay)<barsInDay) 
     {
      Print("      barCounts[]");
      return(INIT_FAILED);
     }
   if(ArrayResize(barVols,barsInDay)<barsInDay)
     {
      Print("      barVols[]");
      return(INIT_FAILED);
     }
//----   
   ArrayInitialize(barCounts,0);
   ArrayInitialize(barVols,0.0);

//----    IndBuffer   
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);

//----      
   string shortname;
   StringConcatenate(shortname,"WmiVol_Pluse(",GetStringTimeframe(TimeFrame),")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
   
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,2);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| WmiVol_Pluse iteration function                                  | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);

///----    
   int first,bar;
   double;

//----    first          OnCalculate 
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=0;
      for(bar=rates_total-1; bar>0; bar--)
        {
         int barOfDay=iBarOfDay(time[bar]);
         barVols[barOfDay]+=high[bar]-low[bar];
         barCounts[barOfDay]++;
        }
      for(bar=0; bar<barsInDay; bar++) if(barCounts[bar]) barVols[bar]/=barCounts[bar];
      double minVol=barVols[ArrayMinimum(barVols)];
      double maxVol=barVols[ArrayMaximum(barVols)];
      avgVol=0.0;
      for(bar=0; bar<barsInDay; bar++) if(maxVol>minVol) avgVol+=barVols[bar]=(barVols[bar]-minVol)/(maxVol-minVol);
      avgVol/=barsInDay;  
     }
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      int barOfDay=iBarOfDay(time[bar]);
      double vol=barVols[barOfDay];
      IndBuffer[bar]=vol;
      if(vol>=avgVol) ColorIndBuffer[bar]=0;
      else ColorIndBuffer[bar]=1;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|  iBarOfDay()                                                     |
//+------------------------------------------------------------------+
int iBarOfDay(datetime timeOpenBar) 
  {
//----
   int minutesInPeriod=PeriodSeconds()/60;
   double minutesSinceMidnight=MathMod(timeOpenBar/60,PeriodSeconds(TimeFrame)/60);
   int barsSinceMidnight=(int)MathFloor(minutesSinceMidnight/minutesInPeriod);
//----
   return (barsSinceMidnight);
  }
//+------------------------------------------------------------------+
