#property copyright "Roffild  2013"
#property link      "http://www.mql5.com/ru/code/1583"
#property version   "1.0"
#property library

class CObjectEmul
{
private:
   struct stObjectTP
   {
      datetime time;
      double price;
   };

   struct stObjectLevel
   {
      double level;
      ENUM_LINE_STYLE style;
      color clr;
      int width;
      string descr;
   };

   struct stObjectPropDouble
   {
      ENUM_OBJECT_PROPERTY_DOUBLE prop;
      double value;
   };

   struct stObjectPropInterger
   {
      ENUM_OBJECT_PROPERTY_INTEGER prop;
      long value;
   };

   struct stObjectPropString
   {
      ENUM_OBJECT_PROPERTY_STRING prop;
      string value;
   };

   class stObject
   {
public:
      long                 chart_id;
      string               name;
      ENUM_OBJECT          type;
      int                  sub_window;
      stObjectTP           tp[];
      stObjectLevel        level[];
      stObjectPropDouble   propDouble[];
      stObjectPropInterger propInterger[];
      stObjectPropString   propString[];
   };

   stObject *objs[];

   void ObjctCreateFill(stObjectTP &tp[], int ind, datetime time, double price)
   {
      ArrayResize(tp, ind, (ind == 1 ? 1 : 0));
      tp[ind - 1].time = time;
      tp[ind - 1].price = price;
   }

public:
   string FileName;
   bool   SaveAuto;

   CObjectEmul(string fname = "")
   {
      FileName = (fname != "") ? fname : _Symbol + " " + EnumToString(_Period) + ".objs";
      SaveAuto = MQL5InfoInteger(MQL5_TESTER);
   }

   ~CObjectEmul()
   {
      if (SaveAuto) SaveFile("", true);
      ReleaseAll();
   }

   int Count()
   {
      return(ArraySize(objs));
   }

   void ReleaseAll()
   {
      for (int x = Count() - 1; x > -1; x--)
         delete(objs[x]);
      ArrayResize(objs, 0, 10);
   }

   bool LoadFile(string fname = "", bool print_error = false)
   {
      int hFile = FileOpen((fname != "") ? fname : FileName, FILE_READ | FILE_TXT | FILE_COMMON);
      if (hFile != INVALID_HANDLE)
      {
         ReleaseAll();
         int x = -1;
         while (!FileIsEnding(hFile))
         {
            string fline[];
            StringSplit(FileReadString(hFile), '\t', fline);
            if (ArraySize(fline) == 0) continue;
            if (fline[0] == "Object")
            {
               ObjctCreate((long)fline[1], fline[2], (ENUM_OBJECT)fline[3], (int)fline[4], 1, 1);
               x = Count() - 1;
            }
            else if (fline[0] == "TP")
            {
               ObjctSetIntegerIndex(x, OBJPROP_TIME, (int)fline[1], (datetime)fline[2]);
               ObjctSetDoubleIndex(x, OBJPROP_PRICE, (int)fline[1], (double)fline[3]);
            }
            else if (fline[0] == "Level")
            {
               ObjctSetDoubleIndex(x, OBJPROP_LEVELVALUE, (int)fline[1], (double)fline[2]);
               ObjctSetIntegerIndex(x, OBJPROP_LEVELSTYLE, (int)fline[1], (long)fline[3]);
               ObjctSetIntegerIndex(x, OBJPROP_LEVELCOLOR, (int)fline[1], (long)fline[4]);
               ObjctSetIntegerIndex(x, OBJPROP_LEVELWIDTH, (int)fline[1], (long)fline[5]);
               ObjctSetStringIndex(x, OBJPROP_LEVELTEXT, (int)fline[1], fline[6]);
            }
            else if (fline[0] == "propDouble")
               ObjctSetDoubleIndex(x, (ENUM_OBJECT_PROPERTY_DOUBLE)fline[2],
                                   (int)fline[1], (double)fline[3]);
            else if (fline[0] == "propInterger")
               ObjctSetIntegerIndex(x, (ENUM_OBJECT_PROPERTY_INTEGER)fline[2],
                                    (int)fline[1], (long)fline[3]);
            else if (fline[0] == "propString")
               ObjctSetStringIndex(x, (ENUM_OBJECT_PROPERTY_STRING)fline[2],
                                   (int)fline[1], fline[3]);
            //else if (fline[0]=="EndObject")
         }
         FileClose(hFile);
         return(true);
      }
      if (print_error) Print("ObjectEmul - LoadFile error ", GetLastError());
      return(false);
   }

   bool SaveFile(string fname = "", bool print_error = false)
   {
      int hFile = FileOpen((fname != "") ? fname : FileName, FILE_WRITE | FILE_CSV | FILE_COMMON, '\t');
      if (hFile != INVALID_HANDLE)
      {
         for (int x = 0, count = Count(); x < count; x++)
         {
            int px, pcount;
            FileWrite(hFile, "Object", objs[x].chart_id, objs[x].name, objs[x].type, objs[x].sub_window);
            for (px = 0, pcount = ArraySize(objs[x].tp); px < pcount; px++)
               FileWrite(hFile, "TP", px, objs[x].tp[px].time, objs[x].tp[px].price);
            for (px = 0, pcount = ArraySize(objs[x].level); px < pcount; px++)
               FileWrite(hFile, "Level", px, objs[x].level[px].level, objs[x].level[px].style,
                         objs[x].level[px].clr, objs[x].level[px].width, objs[x].level[px].descr);
            for (px = 0, pcount = ArraySize(objs[x].propDouble); px < pcount; px++)
               FileWrite(hFile, "propDouble", px, objs[x].propDouble[px].prop, objs[x].propDouble[px].value);
            for (px = 0, pcount = ArraySize(objs[x].propInterger); px < pcount; px++)
               FileWrite(hFile, "propInterger", px, objs[x].propInterger[px].prop,
                         objs[x].propInterger[px].value);
            for (px = 0, pcount = ArraySize(objs[x].propString); px < pcount; px++)
               FileWrite(hFile, "propString", px, objs[x].propString[px].prop, objs[x].propString[px].value);
            FileWrite(hFile, "EndObject");
         }
         FileClose(hFile);
         return(true);
      }
      if (print_error) Print("ObjectEmul - SaveFile error ", GetLastError());
      return(false);
   }

   void DrawAll()
   {
      int x, px, count = Count();

      for (x = 0; x < count; x++)
      {
         ObjectCreate(objs[x].chart_id, objs[x].name, objs[x].type, objs[x].sub_window,
                      objs[x].tp[0].time, objs[x].tp[0].price);
         ObjectSetInteger(objs[x].chart_id, objs[x].name, OBJPROP_HIDDEN, false);
         for (px = ArraySize(objs[x].tp) - 1; px > -1; px--)
            ObjectMove(objs[x].chart_id, objs[x].name, px, objs[x].tp[px].time, objs[x].tp[px].price);
         for (px = ArraySize(objs[x].level) - 1; px > -1; px--)
         {
            ObjectSetDouble(objs[x].chart_id, objs[x].name, OBJPROP_LEVELVALUE, objs[x].level[px].level);
            ObjectSetInteger(objs[x].chart_id, objs[x].name, OBJPROP_LEVELSTYLE, objs[x].level[px].style);
            ObjectSetInteger(objs[x].chart_id, objs[x].name, OBJPROP_LEVELCOLOR, objs[x].level[px].clr);
            ObjectSetInteger(objs[x].chart_id, objs[x].name, OBJPROP_LEVELWIDTH, objs[x].level[px].width);
            ObjectSetString(objs[x].chart_id, objs[x].name, OBJPROP_LEVELTEXT, objs[x].level[px].descr);
         }
         for (px = ArraySize(objs[x].propDouble) - 1; px > -1; px--)
            ObjectSetDouble(objs[x].chart_id, objs[x].name, objs[x].propDouble[px].prop,
                            objs[x].propDouble[px].value);
         for (px = ArraySize(objs[x].propInterger) - 1; px > -1; px--)
            ObjectSetInteger(objs[x].chart_id, objs[x].name, objs[x].propInterger[px].prop,
                             objs[x].propInterger[px].value);
         for (px = ArraySize(objs[x].propString) - 1; px > -1; px--)
            ObjectSetString(objs[x].chart_id, objs[x].name, objs[x].propString[px].prop,
                            objs[x].propString[px].value);
      }
   }

   int ObjctFind(long chart_id, string name)
   {
      int count = Count();
      for (int x = 0; x < count; x++)
         if (objs[x].chart_id == chart_id && objs[x].name == name) return(objs[x].sub_window);
      return(-1);
   }
   int ObjctFindIndex(long chart_id, string name)
   {
      int count = Count();
      for (int x = 0; x < count; x++)
         if (objs[x].chart_id == chart_id && objs[x].name == name) return(x);
      return(-1);
   }

   bool ObjctCreate(long chart_id, string name, ENUM_OBJECT type, int sub_window,
                    datetime time1, double price1, datetime time2 = 0, double price2 = 0,
                    datetime time3 = 0, double price3 = 0, datetime time4 = 0, double price4 = 0)
   //datetime time30=0, double price30=0
   {
      if (ObjctFindIndex(chart_id, name) > -1) return(false);
      if (ArrayResize(objs, Count() + 1, 10) == -1) return(false);
      int last = Count() - 1;
      objs[last] = new stObject();
      objs[last].chart_id = chart_id;
      objs[last].name = name;
      objs[last].type = type;
      objs[last].sub_window = sub_window;
      if (time1 > 0 || price1 > 0) ObjctCreateFill(objs[last].tp, 1, time1, price1);
      if (time2 > 0 || price2 > 0) ObjctCreateFill(objs[last].tp, 2, time2, price2);
      if (time3 > 0 || price3 > 0) ObjctCreateFill(objs[last].tp, 3, time3, price3);
      if (time4 > 0 || price4 > 0) ObjctCreateFill(objs[last].tp, 4, time4, price4);
      return(true);
   }

   int ObjctsDeleteAll(long chart_id, int sub_window = -1, int type = -1, string name = "")
   {
      int last = 0;
      int count = Count();
      for (int x = 0; x < count && last < count; x++)
      {
         if (objs[x].chart_id == chart_id &&
             (sub_window == -1 || objs[x].sub_window == sub_window) &&
             (type == -1 || objs[x].type == type) &&
             (name == "" || objs[x].name == name))
         {
            delete(objs[x]);
            continue;
         }
         if (x > last) objs[last] = GetPointer(objs[x]);
         last++;
      }
      if (last < count) ArrayResize(objs, last, 10);
      return(count - last);
   }

   bool ObjctDelete(long chart_id, string name)
   {
      return((bool)ObjctsDeleteAll(chart_id, -1, -1, name));
   }

   string ObjctName(long chart_id, int pos, int sub_window = -1, int type = -1)
   {
      /*
      Original ObjectName() returns number from the SORTED  of the list name!
      */
      if (pos < Count() &&
          objs[pos].chart_id == chart_id &&
          (sub_window == -1 || objs[pos].sub_window == sub_window) &&
          (type == -1 || objs[pos].type == type)) return(objs[pos].name);
      return("");
   }

   datetime ObjctGetTimeByValueIndex(int pos_in_array, double value, int line_id = 0)
   {
      /*
      Realized as understood... perhaps misunderstood...
      */
      int x = pos_in_array;
      if (x > -1)
      {
         switch (objs[x].type)
         {
            case OBJ_TREND:
            case OBJ_TRENDBYANGLE:
            case OBJ_GANNLINE:
            case OBJ_CHANNEL:
            case OBJ_REGRESSION:
            case OBJ_STDDEVCHANNEL:
            case OBJ_ARROWED_LINE:
               if (line_id > -1 && line_id < ArraySize(objs[x].tp) && objs[x].tp[line_id].price == value)
                  return(objs[x].tp[line_id].time);
               return(0);
            default:
               if (line_id != 0) return(0);
               for (int px = 0, propcount = ArraySize(objs[x].tp); px < propcount; px++)
                  if (objs[x].tp[px].price == value) return(objs[x].tp[px].time);
               return(0);
         }
      }
      return(0);
   }

   datetime ObjctGetTimeByValue(long chart_id, string name, double value, int line_id = 0)
   {
      return(ObjctGetTimeByValueIndex(ObjctFindIndex(chart_id, name), value, line_id));
   }

   double ObjctGetValueByTimeIndex(int pos_in_array, datetime time, int line_id = 0)
   {
      /*
      Realized as understood... perhaps misunderstood...
      */
      int x = pos_in_array;
      if (x > -1)
      {
         switch (objs[x].type)
         {
            case OBJ_TREND:
            case OBJ_TRENDBYANGLE:
            case OBJ_GANNLINE:
            case OBJ_CHANNEL:
            case OBJ_REGRESSION:
            case OBJ_STDDEVCHANNEL:
            case OBJ_ARROWED_LINE:
               if (line_id > -1 && line_id < ArraySize(objs[x].tp) && objs[x].tp[line_id].time == time)
                  return(objs[x].tp[line_id].price);
               return(0);
            default:
               if (line_id != 0) return(0);
               for (int px = 0, propcount = ArraySize(objs[x].tp); px < propcount; px++)
                  if (objs[x].tp[px].time == time) return(objs[x].tp[px].price);
               return(0);
         }
      }
      return(0);
   }

   double ObjctGetValueByTime(long chart_id, string name, datetime time, int line_id = 0)
   {
      return(ObjctGetValueByTimeIndex(ObjctFindIndex(chart_id, name), time, line_id));
   }

   int ObjctsTotal(long chart_id, int sub_window = -1, int type = -1)
   {
      int result = 0;
      int count = Count();
      for (int x = 0; x < count; x++)
         if (objs[x].chart_id == chart_id &&
             (sub_window == -1 || objs[x].sub_window == sub_window) &&
             (type == -1 || objs[x].type == type)) result++;
      return(result);
   }

   double ObjctGetDoubleIndex(int pos_in_array, ENUM_OBJECT_PROPERTY_DOUBLE prop_id,
                              int prop_modifier = 0)
   {
      if (prop_modifier < 0) return(0);
      int x = pos_in_array;
      if (x > -1)
      {
         switch (prop_id)
         {
            case OBJPROP_PRICE:
               if (prop_modifier < ArraySize(objs[x].tp)) return(objs[x].tp[prop_modifier].price);
               if (objs[x].type == OBJ_ELLIOTWAVE5 && prop_modifier == 4) return(1);
               return(0);
            case OBJPROP_LEVELVALUE:
               if (prop_modifier < ArraySize(objs[x].level)) return(objs[x].level[prop_modifier].level);
               switch (objs[x].type)
               {
                  case OBJ_PITCHFORK:
                  case OBJ_FIBOCHANNEL:
                     switch (prop_modifier)
                     {
                        case 1:
                        case 2: return(1);
                        case 3: return(2);
                        default: return(0);
                     }
                  case OBJ_FIBO:
                     switch (prop_modifier)
                     {
                        case 5:
                        case 6: return(1);
                        case 7: return(2);
                        case 8: return(4);
                        default: return(0);
                     }
                  case OBJ_FIBOTIMES:
                     switch (prop_modifier)
                     {
                        case 1: return(1);
                        case 2: return(2);
                        case 3: return(3);
                        case 4: return(5);
                        case 5: return(8);
                        case 6: return(13);
                        case 7: return(21);
                        case 8: return(34);
                        default: return(0);
                     }
                  case OBJ_EXPANSION:
                     switch (prop_modifier)
                     {
                        case 1:
                        case 2:
                           return(1);
                        default:
                           return(0);
                     }
                  default:
                     return(0);
               }
            default:
               for (int px = 0, propcount = ArraySize(objs[x].propDouble); px < propcount; px++)
                  if (objs[x].propDouble[px].prop == prop_id) return(objs[x].propDouble[px].value);
               // default value:
               switch (prop_id)
               {
                  case OBJPROP_ANGLE:
                     if (objs[x].type == OBJ_TRENDBYANGLE) return(90);
                     if (objs[x].type == OBJ_GANNLINE) return(1);
                     return(0);
                  case OBJPROP_DEVIATION:
                     if (objs[x].type == OBJ_STDDEVCHANNEL) return(1);
                     return(0);
                  case OBJPROP_SCALE:
                     switch (objs[x].type)
                     {
                        case OBJ_GANNLINE:
                        case OBJ_GANNFAN:
                        case OBJ_GANNGRID:
                        case OBJ_FIBOARC:
                           return(1);
                        default:
                           return(0);
                     }
                  default:
                     return(0);
               }
         }
      }
      return(0);
   }

   double ObjctGetDouble(long chart_id, string name, ENUM_OBJECT_PROPERTY_DOUBLE prop_id,
                         int prop_modifier = 0)
   {
      return(ObjctGetDoubleIndex(ObjctFindIndex(chart_id, name), prop_id, prop_modifier));
   }

   bool ObjctGetDouble(long chart_id, string name, ENUM_OBJECT_PROPERTY_DOUBLE prop_id,
                       int prop_modifier, double& double_var)
   {
      double_var = ObjctGetDoubleIndex(ObjctFindIndex(chart_id, name), prop_id, prop_modifier);
      if (double_var > 0) return(true);
      return(false);
   }

   long ObjctGetIntegerIndex(int pos_in_array, ENUM_OBJECT_PROPERTY_INTEGER prop_id,
                             int prop_modifier = 0)
   {
      if (prop_modifier < 0) return(0);
      int x = pos_in_array;
      if (x > -1)
      {
         switch (prop_id)
         {
            case OBJPROP_CHART_ID:
               return(objs[x].chart_id);
            case OBJPROP_TYPE:
               return(objs[x].type);
            case OBJPROP_TIME:
               if (prop_modifier < ArraySize(objs[x].tp)) return(objs[x].tp[prop_modifier].time);
               return(0);
            case OBJPROP_LEVELS:
               if (ArraySize(objs[x].level) == 0)
               {
                  switch (objs[x].type)
                  {
                     case OBJ_FIBOFAN:
                     case OBJ_FIBOARC:
                     case OBJ_EXPANSION:
                        return(3);
                     case OBJ_PITCHFORK:
                     case OBJ_FIBOCHANNEL:
                        return(4);
                     case OBJ_FIBO:
                     case OBJ_FIBOTIMES:
                        return(9);
                     default:
                        return(0);
                  }
               }
               return(ArraySize(objs[x].level));
            case OBJPROP_LEVELCOLOR:
               if (prop_modifier < ArraySize(objs[x].level)) return(objs[x].level[prop_modifier].clr);
               if (objs[x].type == OBJ_PITCHFORK || objs[x].type == OBJ_FIBOCHANNEL) return(255);
               return(65535);
            case OBJPROP_LEVELSTYLE:
               if (prop_modifier < ArraySize(objs[x].level)) return(objs[x].level[prop_modifier].style);
               if (objs[x].type == OBJ_PITCHFORK) return(2);
               return(0);
            case OBJPROP_LEVELWIDTH:
               if (prop_modifier < ArraySize(objs[x].level)) return(objs[x].level[prop_modifier].width);
               return(1);
            default:
               for (int px = 0, propcount = ArraySize(objs[x].propInterger); px < propcount; px++)
                  if (objs[x].propInterger[px].prop == prop_id) return(objs[x].propInterger[px].value);
               // default value:
               switch (prop_id)
               {
                  case OBJPROP_HIDDEN:
                  case OBJPROP_WIDTH:
                  case OBJPROP_RAY:
                     return(1);
                  case OBJPROP_RAY_RIGHT:
                     if (objs[x].type == OBJ_TRENDBYANGLE || objs[x].type == OBJ_GANNLINE) return(1);
                     return(0);
                  case OBJPROP_COLOR:
                     switch (objs[x].type)
                     {
                        case OBJ_BUTTON:
                        case OBJ_RECTANGLE_LABEL:
                           return(0);
                        case OBJ_ARROW_BUY:
                           return(11296515);
                        case OBJ_ARROW_SELL:
                           return(1918177);
                        default:
                           return(255);
                     }
                  case OBJPROP_TIMEFRAMES:
                     return(OBJ_ALL_PERIODS);
                  case OBJPROP_STYLE:
                     switch (objs[x].type)
                     {
                        case OBJ_FIBOTIMES:
                        case OBJ_FIBOFAN:
                        case OBJ_FIBOARC:
                        case OBJ_EXPANSION:
                        case OBJ_ELLIOTWAVE3:
                        case OBJ_ELLIOTWAVE5:
                           return(2);
                        default:
                           return(0);
                     }
                  case OBJPROP_XSIZE:
                     switch (objs[x].type)
                     {
                        case OBJ_BITMAP:
                        case OBJ_BITMAP_LABEL:
                           return(10);
                        case OBJ_BUTTON:
                        case OBJ_EDIT:
                        case OBJ_RECTANGLE_LABEL:
                           return(50);
                        case OBJ_CHART:
                           return(300);
                        default:
                           return(0);
                     }
                  case OBJPROP_YSIZE:
                     switch (objs[x].type)
                     {
                        case OBJ_BITMAP:
                        case OBJ_BITMAP_LABEL:
                           return(10);
                        case OBJ_BUTTON:
                        case OBJ_EDIT:
                        case OBJ_RECTANGLE_LABEL:
                           return(18);
                        case OBJ_CHART:
                           return(200);
                        default:
                           return(0);
                     }
                  case OBJPROP_ARROWCODE:
                     switch (objs[x].type)
                     {
                        case OBJ_ARROW_THUMB_UP: return(67);
                        case OBJ_ARROW_THUMB_DOWN: return(68);
                        case OBJ_ARROW_UP: return(241);
                        case OBJ_ARROW_DOWN: return(242);
                        case OBJ_ARROW_STOP: return(251);
                        case OBJ_ARROW_CHECK: return(252);
                        default: return(0);
                     }
                  case OBJPROP_FONTSIZE:
                     switch (objs[x].type)
                     {
                        case OBJ_TEXT:
                        case OBJ_LABEL:
                        case OBJ_BUTTON:
                        case OBJ_EDIT:
                           return(10);
                        default:
                           return(0);
                     }
                  case OBJPROP_DEGREE:
                     if (objs[x].type == OBJ_ELLIOTWAVE3 || objs[x].type == OBJ_ELLIOTWAVE5) return(7);
                     return(0);
                  case OBJPROP_ALIGN:
                     if (objs[x].type == OBJ_EDIT) return(1);
                     return(0);
                  case OBJPROP_BGCOLOR:
                     if (objs[x].type == OBJ_BUTTON || objs[x].type == OBJ_RECTANGLE_LABEL) return(15790320);
                     return(0);
                  case OBJPROP_BORDER_COLOR:
                     if (objs[x].type == OBJ_BUTTON || objs[x].type == OBJ_EDIT) return(-1);
                     return(0);
                  case OBJPROP_BORDER_TYPE:
                     if (objs[x].type == OBJ_RECTANGLE_LABEL) return(2);
                     return(0);
                  default:
                     return(0);
               }
         }
      }
      return(0);
   }

   long ObjctGetInteger(long chart_id, string name, ENUM_OBJECT_PROPERTY_INTEGER prop_id,
                        int prop_modifier = 0)
   {
      return(ObjctGetIntegerIndex(ObjctFindIndex(chart_id, name), prop_id, prop_modifier));
   }

   bool ObjctGetInteger(long chart_id, string name, ENUM_OBJECT_PROPERTY_INTEGER prop_id,
                        int prop_modifier, long& long_var)
   {
      long_var = ObjctGetIntegerIndex(ObjctFindIndex(chart_id, name), prop_id, prop_modifier);
      if (long_var > 0) return(true);
      return(false);
   }

   string ObjctGetStringIndex(int pos_in_array, ENUM_OBJECT_PROPERTY_STRING prop_id,
                              int prop_modifier = 0)
   {
      if (prop_modifier < 0) return("");
      int x = pos_in_array;
      if (x > -1)
      {
         switch (prop_id)
         {
            case OBJPROP_NAME:
               return(objs[x].name);
            case OBJPROP_LEVELTEXT:
               if (prop_modifier < ArraySize(objs[x].level)) return(objs[x].level[prop_modifier].descr);
               switch (objs[x].type)
               {
                  case OBJ_PITCHFORK:
                  case OBJ_FIBOCHANNEL:
                     switch (prop_modifier)
                     {
                        case 0: return("61");
                        case 1: return("100");
                        case 2: return("161");
                        case 3: return("261");
                        default: return("");
                     }
                  case OBJ_FIBO:
                     switch (prop_modifier)
                     {
                        case 1: return("23");
                        case 2: return("38");
                        case 3: return("50");
                        case 4: return("61");
                        case 5: return("100");
                        case 6: return("161");
                        case 7: return("261");
                        case 8: return("423");
                        default: return("");
                     }
                  case OBJ_FIBOTIMES:
                     switch (prop_modifier)
                     {
                        case 1: return("1");
                        case 2: return("2");
                        case 3: return("3");
                        case 4: return("5");
                        case 5: return("8");
                        case 6: return("13");
                        case 7: return("21");
                        case 8: return("34");
                        default: return("");
                     }
                  case OBJ_FIBOARC:
                  case OBJ_FIBOFAN:
                     switch (prop_modifier)
                     {
                        case 0: return("38");
                        case 1: return("50");
                        case 2: return("61");
                        default: return("");
                     }
                  default:
                     return("");
               }
            default:
               for (int px = 0, propcount = ArraySize(objs[x].propString); px < propcount; px++)
                  if (objs[x].propString[px].prop == prop_id) return(objs[x].propString[px].value);
         }
      }
      return("");
   }

   string ObjctGetString(long chart_id, string name, ENUM_OBJECT_PROPERTY_STRING prop_id,
                         int prop_modifier = 0)
   {
      return(ObjctGetStringIndex(ObjctFindIndex(chart_id, name), prop_id, prop_modifier));
   }

   bool ObjctGetString(long chart_id, string name, ENUM_OBJECT_PROPERTY_STRING prop_id,
                       int prop_modifier, string& string_var)
   {
      string_var = ObjctGetStringIndex(ObjctFindIndex(chart_id, name), prop_id, prop_modifier);
      if (string_var != "") return(true);
      return(false);
   }

   bool ObjctMoveIndex(int pos_in_array, int point_index, datetime time, double price)
   {
      if (point_index < 0) return(false);
      int x = pos_in_array;
      if (x > -1 && point_index < ArraySize(objs[x].tp))
      {
         objs[x].tp[point_index].time = time;
         objs[x].tp[point_index].price = price;
         return(true);
      }
      return(false);
   }

   bool ObjctMove(long chart_id, string name, int point_index, datetime time, double price)
   {
      return(ObjctMoveIndex(ObjctFindIndex(chart_id, name), point_index, time, price));
   }

   bool ObjctSetDoubleIndex(int pos_in_array, ENUM_OBJECT_PROPERTY_DOUBLE prop_id,
                            int prop_modifier, double prop_value)
   {
      if (prop_modifier < 0) return(false);
      int x = pos_in_array;
      if (x > -1)
      {
         int propcount;
         switch (prop_id)
         {
            case OBJPROP_PRICE:
               if (prop_modifier >= ArraySize(objs[x].tp)) ArrayResize(objs[x].tp, prop_modifier + 1);
               objs[x].tp[prop_modifier].price = prop_value;
               return(true);
            case OBJPROP_LEVELVALUE:
               if (prop_modifier >= ArraySize(objs[x].level)) ArrayResize(objs[x].level, prop_modifier + 1);
               objs[x].level[prop_modifier].level = prop_value;
               return(true);
            default:
               propcount = ArraySize(objs[x].propDouble);
               for (int px = 0; px < propcount; px++)
                  if (objs[x].propDouble[px].prop == prop_id)
                  {
                     objs[x].propDouble[px].value = prop_value;
                     return(true);
                  }
               ArrayResize(objs[x].propDouble, propcount + 1);
               objs[x].propDouble[propcount].prop = prop_id;
               objs[x].propDouble[propcount].value = prop_value;
               return(true);
         }
      }
      return(false);
   }

   bool ObjctSetDouble(long chart_id, string name, ENUM_OBJECT_PROPERTY_DOUBLE prop_id,
                       int prop_modifier, double prop_value)
   {
      return(ObjctSetDoubleIndex(ObjctFindIndex(chart_id, name), prop_id, prop_modifier, prop_value));
   }

   bool ObjctSetDouble(long chart_id, string name, ENUM_OBJECT_PROPERTY_DOUBLE prop_id,
                       double prop_value)
   {
      return(ObjctSetDoubleIndex(ObjctFindIndex(chart_id, name), prop_id, 0, prop_value));
   }

   bool ObjctSetIntegerIndex(int pos_in_array, ENUM_OBJECT_PROPERTY_INTEGER prop_id,
                             int prop_modifier, long prop_value)
   {
      if (prop_modifier < 0) return(false);
      int x = pos_in_array;
      if (x > -1)
      {
         int propcount;
         switch (prop_id)
         {
            case OBJPROP_CHART_ID:
               objs[x].chart_id = prop_value;
               return(true);
            case OBJPROP_TYPE:
               objs[x].type = (ENUM_OBJECT)prop_value;
               return(true);
            case OBJPROP_TIME:
               if (prop_modifier >= ArraySize(objs[x].tp)) ArrayResize(objs[x].tp, prop_modifier + 1);
               objs[x].tp[prop_modifier].time = (datetime)prop_value;
               return(true);
            case OBJPROP_LEVELS:
               return(false);
            case OBJPROP_LEVELCOLOR:
               if (prop_modifier >= ArraySize(objs[x].level)) ArrayResize(objs[x].level, prop_modifier + 1);
               objs[x].level[prop_modifier].clr = (color)prop_value;
               return(true);
            case OBJPROP_LEVELSTYLE:
               if (prop_modifier >= ArraySize(objs[x].level)) ArrayResize(objs[x].level, prop_modifier + 1);
               objs[x].level[prop_modifier].style = (ENUM_LINE_STYLE)prop_value;
               return(true);
            case OBJPROP_LEVELWIDTH:
               if (prop_modifier >= ArraySize(objs[x].level)) ArrayResize(objs[x].level, prop_modifier + 1);
               objs[x].level[prop_modifier].width = (int)prop_value;
               return(true);
            default:
               propcount = ArraySize(objs[x].propInterger);
               for (int px = 0; px < propcount; px++)
                  if (objs[x].propInterger[px].prop == prop_id)
                  {
                     objs[x].propInterger[px].value = prop_value;
                     return(true);
                  }
               ArrayResize(objs[x].propInterger, propcount + 1);
               objs[x].propInterger[propcount].prop = prop_id;
               objs[x].propInterger[propcount].value = prop_value;
               return(true);
         }
      }
      return(false);
   }

   bool ObjctSetInteger(long chart_id, string name, ENUM_OBJECT_PROPERTY_INTEGER prop_id,
                        int prop_modifier, long prop_value)
   {
      return(ObjctSetIntegerIndex(ObjctFindIndex(chart_id, name), prop_id, prop_modifier, prop_value));
   }

   bool ObjctSetInteger(long chart_id, string name, ENUM_OBJECT_PROPERTY_INTEGER prop_id,
                        long prop_value)
   {
      return(ObjctSetIntegerIndex(ObjctFindIndex(chart_id, name), prop_id, 0, prop_value));
   }

   bool ObjctSetStringIndex(int pos_in_array, ENUM_OBJECT_PROPERTY_STRING prop_id,
                            int prop_modifier, string prop_value)
   {
      if (prop_modifier < 0) return(false);
      int x = pos_in_array;
      if (x > -1)
      {
         int propcount;
         switch (prop_id)
         {
            case OBJPROP_NAME:
               objs[x].name = prop_value;
               return(true);
            case OBJPROP_LEVELTEXT:
               if (prop_modifier >= ArraySize(objs[x].level)) ArrayResize(objs[x].level, prop_modifier + 1);
               objs[x].level[prop_modifier].descr = prop_value;
               return(true);
            default:
               propcount = ArraySize(objs[x].propString);
               for (int px = 0; px < propcount; px++)
                  if (objs[x].propString[px].prop == prop_id)
                  {
                     objs[x].propString[px].value = prop_value;
                     return(true);
                  }
               ArrayResize(objs[x].propString, propcount + 1);
               objs[x].propString[propcount].prop = prop_id;
               objs[x].propString[propcount].value = prop_value;
               return(true);
         }
      }
      return(false);
   }

   bool ObjctSetString(long chart_id, string name, ENUM_OBJECT_PROPERTY_STRING prop_id,
                       int prop_modifier, string prop_value)
   {
      return(ObjctSetStringIndex(ObjctFindIndex(chart_id, name), prop_id, prop_modifier, prop_value));
   }

   bool ObjctSetString(long chart_id, string name, ENUM_OBJECT_PROPERTY_STRING prop_id,
                       string prop_value)
   {
      return(ObjctSetStringIndex(ObjctFindIndex(chart_id, name), prop_id, 0, prop_value));
   }
};
