//+------------------------------------------------------------------+ 
//|                                             ColorRsiMACD_HTF.mq5 | 
//|                               Copyright  2016, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----   
#property version   "1.60"
//----     
#property indicator_separate_window 
//----    4
#property indicator_buffers 4 
//----     
#property indicator_plots   2
//+-----------------------------------+
//|     1 |
//+-----------------------------------+
//----      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//----      
#property indicator_color1 clrGray,clrTeal,clrBlueViolet,clrIndianRed,clrMagenta
//----   - 
#property indicator_style1 STYLE_SOLID
//----     2
#property indicator_width1 2
//----   
#property indicator_label1 "ColorRsiMACD"
//+-----------------------------------+
//|     2 |
//+-----------------------------------+
//----      
#property indicator_type2 DRAW_COLOR_LINE
//----      
#property indicator_color2 clrGray,clrDodgerBlue,clrMagenta
//----   -  
#property indicator_style2 STYLE_SOLID
//----     3
#property indicator_width2 3
//----    
#property indicator_label2  "Signal Line"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0 //        
//+-----------------------------------+
//|          |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_   //TrendFollow_2 Price 
  };
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;// 
input uint    RSIPeriod=14;
input ENUM_APPLIED_PRICE   RSIPrice=PRICE_CLOSE;
input Smooth_Method XMA_Method=MODE_T3; //  
input uint Fast_XMA = 12; //  
input uint Slow_XMA = 26; //  
input int XPhase=100;  //  ,
                       // JJMA    -100 ... +100,     ;
//  VIDIA   CMO,  AMA    
input Smooth_Method Signal_Method=MODE_JJMA; //   
input int Signal_XMA=9; //   
input int Signal_Phase=100; //   ,
                            //   -100 ... +100,
//    ;
input Applied_price_ AppliedPrice=PRICE_CLOSE_;// 
input bool ReDraw=false; //     
//+-----------------------------------+
//----       
bool Init;
//----      
int min_rates_total;
//----      
int XMACD_Handle;
//----   ,    
//      
double XMACDBuffer[],SignBuffer[],ColorXMACDBuffer[],ColorSignBuffer[];
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {
//----
   return(StringSubstr(EnumToString(timeframe),7,-1));
//----
  }
//+------------------------------------------------------------------+    
//| XMACD indicator initialization function                          | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=3;
   Init=true;

//----     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("    ColorRsiMACD       ");
      Init=false;
      return;
     }

//----    ColorRsiMACD
   XMACD_Handle=iCustom(Symbol(),TimeFrame,"ColorRsiMACD",RSIPeriod,RSIPrice,XMA_Method,Fast_XMA,Slow_XMA,XPhase,Signal_Method,Signal_XMA,Signal_Phase,AppliedPrice);
   if(XMACD_Handle==INVALID_HANDLE)
     {
      Print("      ColorRsiMACD");
      Init=false;
      return;
     }

//----    XMACDBuffer   
   SetIndexBuffer(0,XMACDBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(XMACDBuffer,true);

//----     ,     
   SetIndexBuffer(1,ColorXMACDBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorXMACDBuffer,true);

//----    SignBuffer   
   SetIndexBuffer(2,SignBuffer,INDICATOR_DATA);
//----      
//----       
   ArraySetAsSeries(SignBuffer,true);

//----     ,     
   SetIndexBuffer(3,ColorSignBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorSignBuffer,true);
   
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----    CXMA   SmoothAlgorithms.mqh
   CXMA XMA;
   string Smooth1=XMA.GetString_MA_Method(XMA_Method);
   string Smooth2=XMA.GetString_MA_Method(Signal_Method);
//----      
   string shortname;
   StringConcatenate(shortname,"ColorRsiMACD HTF( ",GetStringTimeframe(TimeFrame)," )");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
  }
//+------------------------------------------------------------------+  
//| XMACD iteration function                                         | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total || !Init) return(RESET);
   if(BarsCalculated(XMACD_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);

//----   
   int limit,bar;
//----       
   double XMACD[2],SIGN[2];
   datetime XMACDTime[1];
   static uint LastCountBar;

//----      
//  limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      LastCountBar=rates_total;
     }
   else limit=int(LastCountBar)+rates_total-prev_calculated; //       

//----         
   ArraySetAsSeries(time,true);

//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----      
      XMACDBuffer[bar]=EMPTY_VALUE;
      SignBuffer[bar]=EMPTY_VALUE;
      ColorXMACDBuffer[bar]=0;
      ColorSignBuffer[bar]=0;

      //----      
      if(CopyTime(Symbol(),TimeFrame,time[bar],1,XMACDTime)<=0) return(RESET);

      if(time[bar]>=XMACDTime[0] && time[bar+1]<XMACDTime[0])
        {
         LastCountBar=bar;
         
         //----      
         if(CopyBuffer(XMACD_Handle,0,time[bar],2,XMACD)<=0) return(RESET);
         if(CopyBuffer(XMACD_Handle,2,time[bar],2,SIGN)<=0) return(RESET);

         //----      
         XMACDBuffer[bar]=XMACD[1];
         SignBuffer[bar]=SIGN[1];
         
         if(XMACDBuffer[bar]>0)
           {
            if(XMACD[1]>XMACD[0]) ColorXMACDBuffer[bar]=1;
            if(XMACD[1]<XMACD[0]) ColorXMACDBuffer[bar]=2;
           }

         if(XMACDBuffer[bar]<0)
           {
            if(XMACD[1]<XMACD[0]) ColorXMACDBuffer[bar]=3;
            if(XMACD[1]>XMACD[0]) ColorXMACDBuffer[bar]=4;
           }

         if(XMACDBuffer[bar]>SignBuffer[bar]) ColorSignBuffer[bar]=1;
         if(XMACDBuffer[bar]<SignBuffer[bar]) ColorSignBuffer[bar]=2;
        }
        
       if(ReDraw)
         {
          if(XMACDBuffer[bar+1]!=EMPTY_VALUE&&XMACDBuffer[bar]==EMPTY_VALUE)
            {
             XMACDBuffer[bar]=XMACDBuffer[bar+1];
             ColorXMACDBuffer[bar]=ColorXMACDBuffer[bar+1];
             SignBuffer[bar]=SignBuffer[bar+1];
             ColorSignBuffer[bar]=ColorSignBuffer[bar+1];
            }
         }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
