//+------------------------------------------------------------------+ 
//|                                        PriceChannel_Stop_HTF.mq5 | 
//|                               Copyright  2016, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---   
#property version   "1.60"
#property description "PriceChannel_Stop       "
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 6
//----     
#property indicator_plots   6
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                                 //        
#define INDICATOR_NAME "PriceChannel_Stop"      //    
#define SIZE 1                                  //      CountIndicator 
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_ARROW
//----        
#property indicator_color1  Magenta
//----    1  1
#property indicator_width1  1
//----    1
#property indicator_label1  "SellSignal"

//----   2   
#property indicator_type2   DRAW_ARROW
//----        
#property indicator_color2  Magenta
//----    2  1
#property indicator_width2  1
//----    2
#property indicator_label2 "SellStopSignal"

//----   3   
#property indicator_type3   DRAW_LINE
//----        
#property indicator_color3  Magenta
//----    3  1
#property indicator_width3  1
//----    3
#property indicator_label3 "SellStopLine"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//----   4   
#property indicator_type4   DRAW_ARROW
//----       - 
#property indicator_color4  Lime
//----    4  1
#property indicator_width4  1
//----    4
#property indicator_label4  "BuySignal"

//----   5   
#property indicator_type5   DRAW_ARROW
//----       - 
#property indicator_color5  Lime
//----    5  1
#property indicator_width5  1
//----    5
#property indicator_label5 "BuyStopSignal"

//----   6   
#property indicator_type6   DRAW_LINE
//----       - 
#property indicator_color6  Lime
//----    6  1
#property indicator_width6  1
//----    6
#property indicator_label6 "BuyStopLine"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;    //    ()
input uint ChannelPeriod=5;
input double Risk=0.10;
input bool Signal=true;
input bool Line=true;
input int Shift=0;      //       
//+----------------------------------------------+
//---   ,   
//---      
double IndBuffer1[];
double IndBuffer2[];
double IndBuffer3[];
double IndBuffer4[];
double IndBuffer5[];
double IndBuffer6[];
//---      
int min_rates_total;
//---      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   if(!TimeFramesCheck(INDICATOR_NAME,TimeFrame)) return(INIT_FAILED);
//---   
   min_rates_total=2;
//---    PChannel
   Ind_Handle=iCustom(Symbol(),TimeFrame,"PriceChannel_Stop",ChannelPeriod,Risk,Signal,Line);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      PChannel");
      return(INIT_FAILED);
     }
//---   
   IndInit(0,IndBuffer1,INDICATOR_DATA);
   IndInit(1,IndBuffer2,INDICATOR_DATA);
   IndInit(2,IndBuffer3,INDICATOR_DATA);
   IndInit(3,IndBuffer4,INDICATOR_DATA);
   IndInit(4,IndBuffer5,INDICATOR_DATA);
   IndInit(5,IndBuffer6,INDICATOR_DATA);
//---  
   PlotInit(0,0.0,0,Shift);
   PlotInit(1,0.0,0,Shift);
   PlotInit(2,0.0,0,Shift);
   PlotInit(3,0.0,0,Shift);
   PlotInit(4,0.0,0,Shift);
   PlotInit(5,0.0,0,Shift);
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,108);
   PlotIndexSetInteger(1,PLOT_ARROW,159);
   PlotIndexSetInteger(3,PLOT_ARROW,108);
   PlotIndexSetInteger(4,PLOT_ARROW,159);
//---           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,"(",GetStringTimeframe(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//---         
   ArraySetAsSeries(time,true);
//---
   if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,
      0,IndBuffer1,1,IndBuffer2,2,IndBuffer3,3,IndBuffer4,4,IndBuffer5,5,IndBuffer6,
      time,rates_total,prev_calculated,min_rates_total)) return(RESET);
//---     
   return(rates_total);
  }
//---
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void IndInit(int Number,double &Buffer[],ENUM_INDEXBUFFER_TYPE Type)
  {
//---      
   SetIndexBuffer(Number,Buffer,Type);
//---       
   ArraySetAsSeries(Buffer,true);
//---
  }
//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+    
void PlotInit(int Number,double Empty_Value,int Draw_Begin,int nShift)
  {
//---      
   PlotIndexSetInteger(Number,PLOT_DRAW_BEGIN,Draw_Begin);
//---   ,      
   PlotIndexSetDouble(Number,PLOT_EMPTY_VALUE,Empty_Value);
//---       Shift
   PlotIndexSetInteger(Number,PLOT_SHIFT,nShift);
//---
  }
//+------------------------------------------------------------------+
//| CountLine                                                        |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      IndHandle,       //   
                    uint     BuffNumb1,       //  1   
                    double&  IndBuf1[],       //  1  
                    uint     BuffNumb2,       //  2   
                    double&  IndBuf2[],       //  2  
                    uint     BuffNumb3,       //  3   
                    double&  IndBuf3[],       //  3  
                    uint     BuffNumb4,       //  4   
                    double&  IndBuf4[],       //  4                      
                    uint     BuffNumb5,       //  5   
                    double&  IndBuf5[],       //  5  
                    uint     BuffNumb6,       //  6   
                    double&  IndBuf6[],       //  6  
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total)//       
  {
//---
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---       IndTime
      if(CopyTime(Symbol(),TFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      //---
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double Arr1[1],Arr2[1],Arr3[1],Arr4[1],Arr5[1],Arr6[1];
         //---      
         if(CopyBuffer(IndHandle,BuffNumb1,iTime[bar],1,Arr1)<=0) return(RESET);
         if(CopyBuffer(IndHandle,BuffNumb2,iTime[bar],1,Arr2)<=0) return(RESET);
         if(CopyBuffer(IndHandle,BuffNumb3,iTime[bar],1,Arr3)<=0) return(RESET);
         if(CopyBuffer(IndHandle,BuffNumb4,iTime[bar],1,Arr4)<=0) return(RESET);
         if(CopyBuffer(IndHandle,BuffNumb5,iTime[bar],1,Arr5)<=0) return(RESET);
         if(CopyBuffer(IndHandle,BuffNumb6,iTime[bar],1,Arr6)<=0) return(RESET);
         //---         
         IndBuf1[bar]=Arr1[0];
         IndBuf2[bar]=Arr2[0];
         IndBuf3[bar]=Arr3[0];
         IndBuf4[bar]=Arr4[0];
         IndBuf5[bar]=Arr5[0];
         IndBuf6[bar]=Arr6[0];
        }
      else
        {
         IndBuf1[bar]=IndBuf1[bar+1];
         IndBuf2[bar]=IndBuf2[bar+1];
         IndBuf3[bar]=IndBuf3[bar+1];
         IndBuf4[bar]=IndBuf4[bar+1];
         IndBuf5[bar]=IndBuf5[bar+1];
         IndBuf6[bar]=IndBuf6[bar+1];
        }
     }
//--- 
   return(true);
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(string IndName,
                     ENUM_TIMEFRAMES TFrame) //   ()
  {
//---     
   if(TFrame<Period() && TFrame!=PERIOD_CURRENT)
     {
      Print("    "+IndName+"       !");
      Print("    !");
      return(RESET);
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
