//+------------------------------------------------------------------+
//|                                                       TrendX.mq5 |
//|                               Copyright  2006,   |
//|                                    http://www.chebotariov.co.ua/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006,  "
#property link      "http://www.chebotariov.co.ua/"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----    2
#property indicator_buffers 2 
//----    
#property indicator_plots   2
//+----------------------------------------------+
//|    Adaptive RVI  |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_LINE
//----         Green
#property indicator_color1  clrGreen
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  1
#property indicator_width1  1
//----    
#property indicator_label1  "TrendX Fast"
//+----------------------------------------------+
//|    Trigger       |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----         Red
#property indicator_color2  clrRed
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  1
#property indicator_width2  1
//----    
#property indicator_label2  "TrendX Slow"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|    CXMA                        |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+

//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method MA_Method1=MODE_EMA_; //    
input uint Length1=21; //                      
input int Phase1=15; //  ,
                     // JJMA    -100 ... +100,     ;
//  VIDIA   CMO,  AMA    
input Smooth_Method MA_Method2=MODE_EMA_; //    
input uint Length2=80; //   
input int Phase2=15;  //  ,
                      // JJMA    -100 ... +100,     ;
//  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE_;// 
input int Shift=0; //      
//+----------------------------------------------+
//----   ,    
//      
double IndBuffer1[];
double IndBuffer2[];
//----      
int min_rates_total;
//----   
int Count[];
double Value1[],Value2[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
//----
   int numb,Max1,Max2;
   static int count=1;

   Max2=Size;
   Max1=Max2-1;

   count--;
   if(count<0) count=Max1;

   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//----
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   min_rates_total=int(MathMax(Length1,Length2));
//----       
   ArrayResize(Count,min_rates_total);
   ArrayResize(Value1,min_rates_total);
   ArrayResize(Value2,min_rates_total);

//----      
   SetIndexBuffer(0,IndBuffer1,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   SetIndexBuffer(1,IndBuffer2,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       2  min_rates_total
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);

//----      
   string short_name="TrendX("+string(Length1)+" ,"+string(Length2)+")";
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(RESET);

//----    
   int first,bar,Sign;
   double price,Fast,Fast2,Slow,Slow2,Diff,Diff2,Percent,absmacd;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=0; //      
      ArrayInitialize(Count,0);
      ArrayInitialize(Value1,0.0);
      ArrayInitialize(Value2,0.0);
     }
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      price=PriceSeries(IPC,bar,open,low,high,close);
      Fast=Value1[Count[0]]=XMA1.XMASeries(0,prev_calculated,rates_total,MA_Method1,Phase1,Length1,price,bar,false);
      Slow=Value2[Count[0]]=XMA2.XMASeries(0,prev_calculated,rates_total,MA_Method2,Phase2,Length2,price,bar,false);
      Fast2=Value1[Count[Length1-1]];
      Slow2=Value2[Count[Length2-1]];
      absmacd=MathAbs(Fast-Slow);     
      Diff=MathAbs(absmacd-MathAbs(Fast-Slow2));
      Diff2=absmacd+MathAbs(Fast2-Slow2)/2;
      Percent=Diff*100*((Fast+Fast2)/2)*Diff2;
      if(absmacd-MathAbs(Fast-Slow2)<0) Sign=-1;
      else Sign=+1;
      IndBuffer1[bar]=Percent*Sign;
      IndBuffer2[bar]=(Slow-Fast)+(Fast-Fast2);  
      if(bar<rates_total-1) Recount_ArrayZeroPos(Count,min_rates_total);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
