//+------------------------------------------------------------------+
//|                                             DarvasBoxesCloud.mq5 |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2004, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//---        
#property indicator_buffers 7
//---    
#property indicator_plots   5
//+----------------------------------------------+
//|                      |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_FILLING
//----      LightSkyBlue
#property indicator_color1  clrLightSkyBlue
//----   
#property indicator_label1  "Upper Cloud"
//+----------------------------------------------+
//|              |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----        DodgerBlue
#property indicator_color2  clrDodgerBlue
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  2
#property indicator_width2  2
//----    
#property indicator_label2  "Upper DarvasBox"
//+----------------------------------------------+
//|                |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_LINE
//----        Gray
#property indicator_color3  clrGray
//----   3 -  
#property indicator_style3  STYLE_SOLID
//----    3  2
#property indicator_width3  2
//----    
#property indicator_label3  "Middle DarvasBox"
//+----------------------------------------------+
//|               |
//+----------------------------------------------+
//----   4   
#property indicator_type4   DRAW_LINE
//----        Brown
#property indicator_color4  clrBrown
//----   4 -  
#property indicator_style4  STYLE_SOLID
//----    4  2
#property indicator_width4  2
//----    
#property indicator_label4  "Lower DarvasBox"
//+----------------------------------------------+
//|                      |
//+----------------------------------------------+
//----      
#property indicator_type5   DRAW_FILLING
//----      Orchid
#property indicator_color5  clrOrchid
//----   
#property indicator_label5  "Lower Cloud"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input bool symmetry=true;
input int Shift=0; //      
//+-----------------------------------+
//----   ,         
double ExtUp1Buffer[];
double ExtUp2Buffer[];
double ExtABuffer[];
double ExtBBuffer[];
double ExtCBuffer[];
double ExtDn1Buffer[];
double ExtDn2Buffer[];
//----      
int  min_rates_total;
//+------------------------------------------------------------------+    
//| Donchian Channel indicator initialization function               | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=2;
//----      
   SetIndexBuffer(0,ExtUp1Buffer,INDICATOR_DATA);
   SetIndexBuffer(1,ExtUp2Buffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       
   ArraySetAsSeries(ExtUp1Buffer,true);
   ArraySetAsSeries(ExtUp2Buffer,true);

//----      
   SetIndexBuffer(2,ExtABuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       
   ArraySetAsSeries(ExtABuffer,true);

//----      
   SetIndexBuffer(3,ExtBBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----       
   ArraySetAsSeries(ExtBBuffer,true);

//----      
   SetIndexBuffer(4,ExtCBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(3,PLOT_SHIFT,Shift);
//----       
   ArraySetAsSeries(ExtCBuffer,true);
   
//----      
   SetIndexBuffer(5,ExtDn1Buffer,INDICATOR_DATA);
   SetIndexBuffer(6,ExtDn2Buffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(4,PLOT_SHIFT,Shift);
//----       
   ArraySetAsSeries(ExtDn1Buffer,true);
   ArraySetAsSeries(ExtDn2Buffer,true);

//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"DarvasBoxesCloud");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+  
//| Donchian Channel iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);

//----   
   int limit,bar;
//----   
   static int state,STATE;
   static double box_top,box_bottom,BOX_TOP,BOX_BUTTOM;

//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total; //      
      BOX_TOP=high[limit+1];
      BOX_BUTTOM=low[limit+1];
      STATE=1;
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }

//----   
   state=STATE;
   box_top=BOX_TOP;
   box_bottom=BOX_BUTTOM;

//----        
   for(bar=limit; bar>=0; bar--)
     {       
      switch(state)
        {
         case 1:  box_top=high[bar]; if(symmetry)box_bottom=low[bar]; break;
         case 2:  if(box_top<=high[bar]) box_top=high[bar]; break;
         case 3:  if(box_top> high[bar]) box_bottom=low[bar]; else box_top=high[bar]; break;
         case 4:  if(box_top > high[bar]) {if(box_bottom >= low[bar]) box_bottom=low[bar];} else box_top=high[bar]; break;
         case 5:  if(box_top > high[bar]) {if(box_bottom >= low[bar]) box_bottom=low[bar];} else box_top=high[bar]; state=0; break;
        }

      ExtABuffer[bar] = box_top;
      ExtCBuffer[bar] = box_bottom;
      ExtBBuffer[bar]=(box_top+box_bottom)/2.0;
      ExtUp1Buffer[bar]=ExtABuffer[bar];
      ExtUp2Buffer[bar]=ExtBBuffer[bar];
      ExtDn1Buffer[bar]=ExtBBuffer[bar];
      ExtDn2Buffer[bar]=ExtCBuffer[bar];
      state++;
      
      //----        
      if(bar==1)
        {
         STATE=state;
         BOX_TOP=box_top;
         BOX_BUTTOM=box_bottom;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
