//+------------------------------------------------------------------+
//|                                                   SmartTrail.mq4 |
//|                        Copyright 2016, MetaQuotes Software Corp. |
//|                                   https://M2P_Design@hotmail.com |
//+------------------------------------------------------------------+
#property library
#property copyright "Copyright 2016, MetaQuotes Software Corp."
#property link      "https://M2P_Design@hotmail.com"
#property version   "1.00"
#property strict


extern  int         Magic = 280456;
extern  int          Step = 10;
extern bool UseSmartTrail = false;
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
// void OnTick()
//   {
//   if(UseSmartTrail) SmartTrail();
//   }
//+------------------------------------------------------------------+
//| New Candle function                                              |
//+------------------------------------------------------------------+
bool NewCandle()
  {
   static int i=0;
   if(Bars==i) return(false);
   i=Bars;
   return(true);
  }
//+------------------------------------------------------------------+
//| Smart Trail function                                             |
//+------------------------------------------------------------------+
void SmartTrail()
  {
   double MyPoint=Point;
   if(Digits==3 || Digits==5) MyPoint=Point*10;

   for(int i=OrdersTotal()-1;i>=0;i--)
     {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES))
         if(OrderMagicNumber()==Magic && Symbol()==OrderSymbol())
            if(OrderType()==OP_BUY)
              {
               if(NewCandle())
                  if(OrderStopLoss()<Low[1]-Step*MyPoint)
                     int SBM=OrderModify(OrderTicket(),OrderOpenPrice(),Low[1]-Step*MyPoint,OrderTakeProfit(),0,clrNONE);
              }
      else if(OrderType()==OP_SELL)
        {
         if(NewCandle())
            if(OrderStopLoss()>High[1]+Step*MyPoint)
               int SSM=OrderModify(OrderTicket(),OrderOpenPrice(),High[1]+Step*MyPoint,OrderTakeProfit(),0,clrNONE);
        }
     }
  }
//+------------------------------------------------------------------+
