//+------------------------------------------------------------------+
//|                                                    AroonHorn.mq5 |
//|                                        Copyright  2011, tonyc2a | 
//|                                         mailto:tonyc2a@yahoo.com | 
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2011, tonyc2a"
//----    
#property link "mailto:tonyc2a@yahoo.com"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 4
//----    
#property indicator_plots   3
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_LINE
//----         
#property indicator_color1  clrLimeGreen
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  2
#property indicator_width1  2
//----    
#property indicator_label1  "BullsAroon"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----         
#property indicator_color2  clrCrimson
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  2
#property indicator_width2  2
//----    
#property indicator_label2  "BearsAroon"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//----      
#property indicator_type3   DRAW_FILLING
//----     
#property indicator_color3  clrPaleGreen,clrLightPink
//----   
#property indicator_label3  "Signal Aroon Cloud"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 70.0
#property indicator_level2 50.0
#property indicator_level3 30.0
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int AroonPeriod= 9; //   
input int AroonShift = 0; //       
//+----------------------------------------------+
//----   ,    
//      
double BullsAroonBuffer1[];
double BearsAroonBuffer1[];
double BullsAroonBuffer2[];
double BearsAroonBuffer2[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----    BullsAroonBuffer   
   SetIndexBuffer(0,BullsAroonBuffer1,INDICATOR_DATA);
//----    1    AroonShift
   PlotIndexSetInteger(0,PLOT_SHIFT,AroonShift);
//----       1  AroonPeriod
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,AroonPeriod);

//----    BearsAroonBuffer   
   SetIndexBuffer(1,BearsAroonBuffer1,INDICATOR_DATA);
//----    2    AroonShift
   PlotIndexSetInteger(1,PLOT_SHIFT,AroonShift);
//----       2  AroonPeriod
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,AroonPeriod);

//----    BullsAroonBuffer   
   SetIndexBuffer(2,BullsAroonBuffer2,INDICATOR_DATA);
//----    BearsAroonBuffer   
   SetIndexBuffer(3,BearsAroonBuffer2,INDICATOR_DATA);
//----    1    AroonShift
   PlotIndexSetInteger(2,PLOT_SHIFT,AroonShift);
//----       1  AroonPeriod
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,AroonPeriod);

//----      
   string shortname;
   StringConcatenate(shortname,"Aroon(",AroonPeriod,", ",AroonShift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<AroonPeriod-1) return(0);

//----    
   int first,bar;
   double BULLS,BEARS;

//----         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=AroonPeriod-1; //      
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      int barx=rates_total-bar-1;
      //----   
      BULLS=NormalizeDouble(100-(ArrayMaximum(high,barx,AroonPeriod)-barx+0.5)*100/AroonPeriod,0);
      BEARS=NormalizeDouble(100-(ArrayMinimum(low,barx,AroonPeriod)-barx+0.5)*100/AroonPeriod,0);

      //----       
      BullsAroonBuffer1[bar]=BULLS;
      BearsAroonBuffer1[bar]=BEARS;
      BullsAroonBuffer2[bar]=0;
      BearsAroonBuffer2[bar]=0;

      if(BULLS!=BEARS)
        {
         if(BULLS>BEARS && BULLS>=50)
           {
            BullsAroonBuffer2[bar]=BULLS;
            BearsAroonBuffer2[bar]=BEARS;           
           }

         if(BULLS<BEARS && BEARS>=50)
           {
            BullsAroonBuffer2[bar]=BULLS;
            BearsAroonBuffer2[bar]=BEARS;
           }
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
