//+------------------------------------------------------------------+ 
//|                                            KalmanFilterStDev.mq5 | 
//|                    MQL5 code: Copyright  2015, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 6
//----     
#property indicator_plots   5
//+----------------------------------------------+
//|     KalmanFilter |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_COLOR_LINE
//----      
#property indicator_color1 clrOrange,clrTurquoise
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "KalmanFilter"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_ARROW
//----        
#property indicator_color2  clrDeepPink
//----    2  2
#property indicator_width2  2
//----    
#property indicator_label2  "Dn_Signal 1"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_ARROW
//----        
#property indicator_color3  clrTeal
//----    3  2
#property indicator_width3  2
//----    
#property indicator_label3  "Up_Signal 1"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   4   
#property indicator_type4   DRAW_ARROW
//----        
#property indicator_color4  clrDeepPink
//----    4  5
#property indicator_width4  5
//----    
#property indicator_label4  "Dn_Signal 2"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//----   5   
#property indicator_type5   DRAW_ARROW
//----        
#property indicator_color5  clrTeal
//----    5  5
#property indicator_width5  5
//----    
#property indicator_label5  "Up_Signal 2"
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  // TrendFollow_2 Price 
   PRICE_DEMARK_         // Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+  
enum Signal_mode
  {
   Trend, // 
   Kalman // 
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input double K=1.0; //                     
input Applied_price_ IPC=PRICE_WEIGHTED_;// 
input Signal_mode Signal=Kalman; //   
input int Shift=0; //      
input int PriceShift=0; // c     
input double dK1=1.5;  // 1   
input double dK2=2.5;  // 2   
input uint std_period=9; //  
//+----------------------------------------------+
//----   ,    
//      
double ExtLineBuffer[],ColorExtLineBuffer[];
double BearsBuffer1[],BullsBuffer1[];
double BearsBuffer2[],BullsBuffer2[];
//----
double dPriceShift,Sqrt100,K100,dKalman[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+    
//| KalmanFilter indicator initialization function                   | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=2+int(std_period);

//----     
   Sqrt100=MathSqrt(K/100);
   K100=K/100.0;

//----    
   dPriceShift=_Point*PriceShift;

//----       
   ArrayResize(dKalman,std_period);

//----      
   SetIndexBuffer(0,ExtLineBuffer,INDICATOR_DATA);
//----       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----     ,     
   SetIndexBuffer(1,ColorExtLineBuffer,INDICATOR_COLOR_INDEX);

//----    BearsBuffer   
   SetIndexBuffer(2,BearsBuffer1,INDICATOR_DATA);
//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(1,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----    BullsBuffer   
   SetIndexBuffer(3,BullsBuffer1,INDICATOR_DATA);
//----    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(2,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----    BearsBuffer   
   SetIndexBuffer(4,BearsBuffer2,INDICATOR_DATA);
//----    2  
   PlotIndexSetInteger(3,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(3,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----    BullsBuffer   
   SetIndexBuffer(5,BullsBuffer2,INDICATOR_DATA);
//----    3  
   PlotIndexSetInteger(4,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(4,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   string shortname;
   StringConcatenate(shortname,"KalmanFilterStDev(",DoubleToString(K,2),")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+  
//| KalmanFilter iteration function                                  | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total)return(0);

//----   
   int first,bar;
   double Velocity,Distance,Error;
   static double Velocity_;
   double Kalman,SMAdif,Sum,StDev,dstd,BEARS1,BULLS1,BEARS2,BULLS2,Filter1,Filter2;
//----

   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=1; //      
      //----  
      ExtLineBuffer[first-1]=PriceSeries(IPC,first-1,open,low,high,close);
      Velocity_=0.0;
     }
   else first=prev_calculated-1; //      

//----   
   Velocity=Velocity_;

//----    
   for(bar=first; bar<rates_total; bar++)
     {
      //----        
      if(rates_total!=prev_calculated && bar==rates_total-1)
        {
         Velocity_=Velocity;
        }

      Distance=PriceSeries(IPC,bar,open,low,high,close)-ExtLineBuffer[bar-1];
      Error=ExtLineBuffer[bar-1]+Distance*Sqrt100;
      Velocity+=Distance*K100;
      ExtLineBuffer[bar]=Error+Velocity+dPriceShift;

      if(Signal==Trend)
        {
         if(ExtLineBuffer[bar-1]>ExtLineBuffer[bar]) ColorExtLineBuffer[bar]=0;
         else ColorExtLineBuffer[bar]=1;
        }
      else
        {
         if(Velocity>0) ColorExtLineBuffer[bar]=1;
         else           ColorExtLineBuffer[bar]=0;
        }
     }
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_total;
//----      
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //----        
      for(int iii=0; iii<int(std_period); iii++) dKalman[iii]=ExtLineBuffer[bar-iii]-ExtLineBuffer[bar-iii-1];

      //----     
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=dKalman[iii];
      SMAdif=Sum/std_period;

      //----       
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=MathPow(dKalman[iii]-SMAdif,2);

      //----      StDev   
      StDev=MathSqrt(Sum/std_period);

      //----  
      dstd=NormalizeDouble(dKalman[0],_Digits+2);
      Filter1=NormalizeDouble(dK1*StDev,_Digits+2);
      Filter2=NormalizeDouble(dK2*StDev,_Digits+2);
      BEARS1=EMPTY_VALUE;
      BULLS1=EMPTY_VALUE;
      BEARS2=EMPTY_VALUE;
      BULLS2=EMPTY_VALUE;
      Kalman=ExtLineBuffer[bar];

      //----   
      if(dstd<-Filter1 && dstd>=-Filter2) BEARS1=Kalman; //  
      if(dstd<-Filter2) BEARS2=Kalman; //  
      if(dstd>+Filter1 && dstd<=+Filter2) BULLS1=Kalman; //  
      if(dstd>+Filter2) BULLS2=Kalman; //  

      //----       
      BullsBuffer1[bar]=BULLS1;
      BearsBuffer1[bar]=BEARS1;
      BullsBuffer2[bar]=BULLS2;
      BearsBuffer2[bar]=BEARS2;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+   
//|                                 |
//+------------------------------------------------------------------+ 
double PriceSeries
(
 uint applied_price,//  
 uint   bar,//            ).
 const double &Open[],
 const double &Low[],
 const double &High[],
 const double &Close[]
 )
//PriceSeries(applied_price, bar, open, low, high, close)
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
  {
//----
   switch(applied_price)
     {
      //----     ENUM_APPLIED_PRICE
      case  PRICE_CLOSE: return(Close[bar]);
      case  PRICE_OPEN: return(Open [bar]);
      case  PRICE_HIGH: return(High [bar]);
      case  PRICE_LOW: return(Low[bar]);
      case  PRICE_MEDIAN: return((High[bar]+Low[bar])/2.0);
      case  PRICE_TYPICAL: return((Close[bar]+High[bar]+Low[bar])/3.0);
      case  PRICE_WEIGHTED: return((2*Close[bar]+High[bar]+Low[bar])/4.0);

      //----                            
      case  8: return((Open[bar] + Close[bar])/2.0);
      case  9: return((Open[bar] + Close[bar] + High[bar] + Low[bar])/4.0);
      //----                                
      case 10:
        {
         if(Close[bar]>Open[bar])return(High[bar]);
         else
           {
            if(Close[bar]<Open[bar])
               return(Low[bar]);
            else return(Close[bar]);
           }
        }
      //----         
      case 11:
        {
         if(Close[bar]>Open[bar])return((High[bar]+Close[bar])/2.0);
         else
           {
            if(Close[bar]<Open[bar])
               return((Low[bar]+Close[bar])/2.0);
            else return(Close[bar]);
           }
         break;
        }
      //----
      default: return(Close[bar]);
     }
//----
//return(0);
  }
//+------------------------------------------------------------------+
