//+---------------------------------------------------------------------+
//|                                               XDerivative_StDev.mq5 | 
//|                                  Copyright  2015, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 5
//----     
#property indicator_plots   5
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       DodgerBlue 
#property indicator_color1 clrDodgerBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "XDerivative"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_ARROW
//----        
#property indicator_color2  clrRed
//----    2  2
#property indicator_width2  2
//----    
#property indicator_label2  "Dn_Signal 1"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_ARROW
//----        
#property indicator_color3  clrSpringGreen
//----    3  2
#property indicator_width3  2
//----    
#property indicator_label3  "Up_Signal 1"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   4   
#property indicator_type4   DRAW_ARROW
//----        
#property indicator_color4  clrRed
//----    4  4
#property indicator_width4  4
//----    
#property indicator_label4  "Dn_Signal 2"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//----   5   
#property indicator_type5   DRAW_ARROW
//----        
#property indicator_color5  clrSpringGreen
//----    5  4
#property indicator_width5  4
//----    
#property indicator_label5  "Up_Signal 2"
//+----------------------------------------------+
//|    CXMA                        |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+

//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum ENUM_PRICE_TYPE // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint  i_slowing = 34; // Slowing / 
input ENUM_PRICE_TYPE i_price = PRICE_WEIGHTED_; // Applied price /  
input Smooth_Method XMA_Method=MODE_JJMA; // 
input int XLength=7; //                     
input int XPhase=15; // ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input double dK1=1.5;  // 1   
input double dK2=2.5;  // 2   
input uint std_period=9; //  
input int Shift=0; //      
//+----------------------------------------------+

//----   ,    
//      
double IndBuffer[];
double BearsBuffer1[],BullsBuffer1[];
double BearsBuffer2[],BullsBuffer2[];
double DDer[];
//----      
int min_rates_1,min_rates_total;
//+------------------------------------------------------------------+   
//| XMA indicator initialization function                            | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_1=int(i_slowing);
   min_rates_total=min_rates_1+GetStartBars(XMA_Method,XLength,XPhase)+int(std_period);
//----       
   XMA1.XMALengthCheck("XLength",XLength);
   XMA1.XMAPhaseCheck("XPhase",XPhase,XMA_Method);
//----       
   ArrayResize(DDer,std_period);
   
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   
//----    BearsBuffer   
   SetIndexBuffer(1,BearsBuffer1,INDICATOR_DATA);
//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(1,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----    BullsBuffer   
   SetIndexBuffer(2,BullsBuffer1,INDICATOR_DATA);
//----    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(2,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----    BearsBuffer   
   SetIndexBuffer(3,BearsBuffer2,INDICATOR_DATA);
//----    2  
   PlotIndexSetInteger(3,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(3,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----    BullsBuffer   
   SetIndexBuffer(4,BullsBuffer2,INDICATOR_DATA);
//----    3  
   PlotIndexSetInteger(4,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(4,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   
//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(XMA_Method);
   StringConcatenate(shortname,"XDerivative_StDev(",i_slowing,", ",XLength,", ",Smooth1,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
   
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
  }
//+------------------------------------------------------------------+ 
//| XMA iteration function                                           | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----       
   double der,SMAdif,Sum,StDev,dstd,BEARS1,BULLS1,BEARS2,BULLS2,Filter1,Filter2;
//----        
   int first,bar;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_1; //      
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      der=100.0 *(PriceSeries(i_price,bar,open,low,high,close)-PriceSeries(i_price,bar-i_slowing,open,low,high,close))/i_slowing;
      IndBuffer[bar]=XMA1.XMASeries(min_rates_1,prev_calculated,rates_total,XMA_Method,XPhase,XLength,der,bar,false);
     }
     
     
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_total;
//----      
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //----        
      for(int iii=0; iii<int(std_period); iii++) DDer[iii]=IndBuffer[bar-iii]-IndBuffer[bar-iii-1];

      //----     
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=DDer[iii];
      SMAdif=Sum/std_period;

      //----       
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=MathPow(DDer[iii]-SMAdif,2);

      //----      StDev   
      StDev=MathSqrt(Sum/std_period);

      //----  
      dstd=NormalizeDouble(DDer[0],_Digits+2);
      Filter1=NormalizeDouble(dK1*StDev,_Digits+2);
      Filter2=NormalizeDouble(dK2*StDev,_Digits+2);
      BEARS1=EMPTY_VALUE;
      BULLS1=EMPTY_VALUE;
      BEARS2=EMPTY_VALUE;
      BULLS2=EMPTY_VALUE;
      der=IndBuffer[bar];

      //----   
      if(dstd<-Filter1 && dstd>=-Filter2) BEARS1=der; //  
      if(dstd<-Filter2) BEARS2=der; //  
      if(dstd>+Filter1 && dstd<=+Filter2) BULLS1=der; //  
      if(dstd>+Filter2) BULLS2=der; //  

      //----       
      BullsBuffer1[bar]=BULLS1;
      BearsBuffer1[bar]=BEARS1;
      BullsBuffer2[bar]=BULLS2;
      BearsBuffer2[bar]=BEARS2;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
