//+------------------------------------------------------------------+
//|                                                     PChannel.mq5 |
//|                                           Copyright  2005, Xaoc |
//|                                             http://forex.xcd.ru/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, Xaoc"
#property link      "http://forex.xcd.ru/"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 2
//----    
#property indicator_plots   2
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_LINE
//----         
#property indicator_color1  clrLimeGreen
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  2
#property indicator_width1  2
//----    
#property indicator_label1  "TOPBAND"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----         
#property indicator_color2  clrRed
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  2
#property indicator_width2  2
//----    
#property indicator_label2  "BOTBAND"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint   PCPeriod=55; 
input int    Shift=0;     //       
//+-----------------------------------+

//----      
int  min_rates_total;
//----   ,    
//      
double ExtABuffer[];
double ExtBBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//----     
   min_rates_total=int(PCPeriod);
   
//----      
   SetIndexBuffer(0,ExtABuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       
   ArraySetAsSeries(ExtABuffer,true);

//----      
   SetIndexBuffer(1,ExtBBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       
   ArraySetAsSeries(ExtBBuffer,true);

//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"PChannel("+string(PCPeriod)+")");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &Time[],
                const double &Open[],
                const double &High[],
                const double &Low[],
                const double &Close[],
                const long &Tick_Volume[],
                const long &Volume[],
                const int &Spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);
   
//----   
   int limit;

//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
        limit=rates_total-min_rates_total-1; //      
   else limit=rates_total-prev_calculated;  //       

//----         
   ArraySetAsSeries(High,true);
   ArraySetAsSeries(Low,true);   
   
//----    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ExtABuffer[bar]=High[ArrayMaximum(High,bar,PCPeriod)];
      ExtBBuffer[bar]=Low[ArrayMinimum(Low,bar,PCPeriod)];
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
