//+------------------------------------------------------------------+
//|                                                        Price.mq5 |
//|                               Copyright  2016, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2016, Nikolay Kositsin"
//----    
#property link      "farria@mail.redcom.ru"
//----   
#property version   "1.00"
//----
#property description " "
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 0
//----    
#property indicator_plots  0
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
enum PriceMode
  {
   BID=0,  //
   ASK     //
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input string  SirName="Price";               //    
input PriceMode Price=BID;                   //  
input uint  Digits_=0;                       // 
input color  Color_= clrMagenta;             // 
input uint FontSize = 2;                     //  
input int  Shift = 10;                       //      
//+----------------------------------------------+
color clr;
int Normalize;
string ObjectNames;
double PointPow10;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----  
   ObjectNames=SirName+" PriceLable";
//----           
   PointPow10=_Point*MathPow(10,Digits_);
   Normalize=int(_Digits-Digits_);
//----
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+    
void OnDeinit(const int reason)
  {
//----
   ObjectDelete(0,ObjectNames);
//----
   ChartRedraw(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   ArraySetAsSeries(close,false);
   ArraySetAsSeries(time,false);
   double price;
   if(Price==BID) price=close[rates_total-1];
   else 
    {
     ArraySetAsSeries(spread,false);
     price=close[rates_total-1]+_Point*spread[rates_total-1];
    }
   double res=NormalizeDouble(PointPow10*MathCeil(price/PointPow10),Normalize);
   datetime time0=time[rates_total-1]+PeriodSeconds()*Shift;
//----
   string info=ObjectNames+" "+DoubleToString(res,Normalize);
   SetRightPrice(0,ObjectNames,0,time0,res,Color_,FontSize,info);
//----
   ChartRedraw(0);
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|  RightPrice creation                                             |
//+------------------------------------------------------------------+
void CreateRightPrice(long chart_id,// chart ID
                      string   name,              // object name
                      int      nwin,              // window index
                      datetime time,              // price level time
                      double   price,             // price level
                      color    Color,             // price color
                      int      fontsize,          // price size
                      string   text               // 
                      )
  {
//----
   ObjectCreate(chart_id,name,OBJ_ARROW_RIGHT_PRICE,nwin,time,price);
   ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
   ObjectSetInteger(chart_id,name,OBJPROP_BACK,false);
   ObjectSetInteger(chart_id,name,OBJPROP_WIDTH,fontsize);
   ObjectSetString(chart_id,name,OBJPROP_TEXT,text);
   ObjectSetInteger(chart_id,name,OBJPROP_SELECTED,false);
   ObjectSetInteger(chart_id,name,OBJPROP_SELECTABLE,false);
//----
  }
//+------------------------------------------------------------------+
//|  RightPrice reinstallation                                       |
//+------------------------------------------------------------------+
void SetRightPrice(long chart_id,// chart ID
                   string   name,              // object name
                   int      nwin,              // window index
                   datetime time,              // price level time
                   double   price,             // price level
                   color    Color,             // price color
                   int      fontsize,          // price size
                   string   text               // 
                   )
  {
//----
   if(ObjectFind(chart_id,name)==-1) CreateRightPrice(chart_id,name,nwin,time,price,Color,fontsize,text);
   else
     {
      ObjectMove(chart_id,name,0,time,price);
      ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
     }
  }
//+------------------------------------------------------------------+
