//+------------------------------------------------------------------+ 
//|                                                 Ichimoku_HTF.mq5 | 
//|                               Copyright  2016, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---   
#property version   "1.00"
//----     
#property indicator_chart_window
//----    8
#property indicator_buffers 8
//----     
#property indicator_plots   5
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                                 //        
#define INDICATOR_NAME "Ichimoku"               //    
#define SIZE 8                                  //      CountLine
//+----------------------------------------------+
//|    Tenkan-sen    |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_LINE
//----         Red
#property indicator_color1  clrRed
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  1
#property indicator_width1  1
//----    
#property indicator_label1  "Tenkan-sen"
//+----------------------------------------------+
//|    Kijun-sen     |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----         Blue
#property indicator_color2  clrBlue
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  1
#property indicator_width2  1
//----    
#property indicator_label2  "Kijun-sen"
//+----------------------------------------------+
//|     Senkou           |
//+----------------------------------------------+
//----      
#property indicator_type3   DRAW_FILLING
//----     
#property indicator_color3  clrPaleTurquoise,clrLavenderBlush
//----   
#property indicator_label3  "Senkou Span A;Senkou Span B"
//+----------------------------------------------+
//|      Chinkou Span   |
//+----------------------------------------------+
//----     
#property indicator_type4   DRAW_LINE
//----        
#property indicator_color4 clrLime
//----   - 
#property indicator_style4  STYLE_SOLID
//----     2
#property indicator_width4  2
//----   
#property indicator_label4  "Chinkou Span"
//+----------------------------------------------+
//|      Chinkou Span   |
//+----------------------------------------------+
//----      
#property indicator_type5   DRAW_COLOR_HISTOGRAM2
//----      
#property indicator_color5 clrRed,clrBlue
//----   - -
#property indicator_style5  STYLE_DASHDOTDOT
//----     1
#property indicator_width5  1
//----   
#property indicator_label5  "Tenkan-sen; Kijun-sen"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;//  
input int InpTenkan=9;     // Tenkan-sen
input int InpKijun=26;     // Kijun-sen
input int InpSenkou=52;    // Senkou Span B
//+----------------------------------------------+
//----   ,    
//      
double ExtLineBuffer1[],ExtLineBuffer2[],ExtLineBuffer3[],ExtLineBuffer4[];
double ExtLineBuffer5[],ExtLineBuffer6[],ExtLineBuffer7[],ExtLineBuffer8[];
//---   
string Symbol_,Word;
//---      
int min_rates_total,Shift;
//---      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES Timeframe)
  {return(StringSubstr(EnumToString(Timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   if(InpTenkan>0)
      if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
        {
         Print("    Ichimoku       ");
         return(INIT_FAILED);
        }
//---   
   min_rates_total=2;
   if(InpTenkan>0) Shift=(InpKijun-2)*PeriodSeconds(TimeFrame)/PeriodSeconds(PERIOD_CURRENT);
   Symbol_=Symbol();
   Word=INDICATOR_NAME+" : "+Symbol_+StringSubstr(EnumToString(_Period),7,-1);
//---    Ichimoku
   if(InpTenkan>0)
     {
      Ind_Handle=iCustom(Symbol_,TimeFrame,MQLInfoString(MQL_PROGRAM_NAME),PERIOD_CURRENT,-InpTenkan,InpKijun,InpSenkou);
      if(Ind_Handle==INVALID_HANDLE)
        {
         Print("      "+MQLInfoString(MQL_PROGRAM_NAME));
         return(INIT_FAILED);
        }
     }
//----      
   SetIndexBuffer(0,ExtLineBuffer1,INDICATOR_DATA);
   SetIndexBuffer(1,ExtLineBuffer2,INDICATOR_DATA);
   SetIndexBuffer(2,ExtLineBuffer3,INDICATOR_DATA);
   SetIndexBuffer(3,ExtLineBuffer4,INDICATOR_DATA);
   SetIndexBuffer(4,ExtLineBuffer5,INDICATOR_DATA);
   SetIndexBuffer(5,ExtLineBuffer6,INDICATOR_DATA);
   SetIndexBuffer(6,ExtLineBuffer7,INDICATOR_DATA);
   SetIndexBuffer(7,ExtLineBuffer8,INDICATOR_COLOR_INDEX);
//----  ,     
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(ExtLineBuffer1,true);
   ArraySetAsSeries(ExtLineBuffer2,true);
   ArraySetAsSeries(ExtLineBuffer3,true);
   ArraySetAsSeries(ExtLineBuffer4,true);
   ArraySetAsSeries(ExtLineBuffer5,true);
   ArraySetAsSeries(ExtLineBuffer6,true);
   ArraySetAsSeries(ExtLineBuffer7,true);
   ArraySetAsSeries(ExtLineBuffer8,true);
//---           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME"(",GetStringTimeframe(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &Time[],
                const double &Open[],
                const double &High[],
                const double &Low[],
                const double &Close[],
                const long &TickVolume[],
                const long &Volume[],
                const int &Spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
   if(InpTenkan>0)
     {
      //---         
      ArraySetAsSeries(Time,true);
      //----     
      datetime time1[1],timex[];
      if(CopyTime(Symbol(),TimeFrame,1,1,time1)<=0) return(RESET);
      if(CopyTime(Symbol(),NULL,Time[0],time1[0],timex)<=0) return(RESET);
      int shiftx=Shift+ArraySize(timex);
      PlotIndexSetInteger(2,PLOT_SHIFT,shiftx);
      PlotIndexSetInteger(3,PLOT_SHIFT,-shiftx);
      //---    
      if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,0,ExtLineBuffer1,Time,rates_total,prev_calculated,min_rates_total)) return(RESET);
      if(!CountIndicator(1,NULL,TimeFrame,Ind_Handle,1,ExtLineBuffer2,Time,rates_total,prev_calculated,min_rates_total)) return(RESET);
      if(!CountIndicator(2,NULL,TimeFrame,Ind_Handle,2,ExtLineBuffer3,Time,rates_total,prev_calculated,min_rates_total)) return(RESET);
      if(!CountIndicator(3,NULL,TimeFrame,Ind_Handle,3,ExtLineBuffer4,Time,rates_total,prev_calculated,min_rates_total)) return(RESET);
      if(!CountIndicator(4,NULL,TimeFrame,Ind_Handle,4,ExtLineBuffer5,Time,rates_total,prev_calculated,min_rates_total)) return(RESET);
      if(!CountIndicator(5,NULL,TimeFrame,Ind_Handle,5,ExtLineBuffer6,Time,rates_total,prev_calculated,min_rates_total)) return(RESET);
      if(!CountIndicator(6,NULL,TimeFrame,Ind_Handle,6,ExtLineBuffer7,Time,rates_total,prev_calculated,min_rates_total)) return(RESET);
      if(!CountIndicator(7,NULL,TimeFrame,Ind_Handle,7,ExtLineBuffer8,Time,rates_total,prev_calculated,min_rates_total)) return(RESET);
     }
   else
     {
      int limit;
      //----         
      ArraySetAsSeries(High,true);
      ArraySetAsSeries(Low,true);
      ArraySetAsSeries(Close,true);
      //---
      if(prev_calculated==0) limit=0;
      else                   limit=prev_calculated-1;
      //---
      for(int i=limit;i<rates_total && !IsStopped();i++)
        {
         ExtLineBuffer5[i]=Close[i];
         //--- tenkan sen
         double high=High[ArrayMaximum(High,i,MathAbs(InpTenkan))];
         double low=Low[ArrayMinimum(Low,i,MathAbs(InpTenkan))];
         ExtLineBuffer1[i]=ExtLineBuffer6[i]=(high+low)/2.0;
         //--- kijun sen
         high=High[ArrayMaximum(High,i,InpKijun)];
         low=Low[ArrayMinimum(Low,i,InpKijun)];
         ExtLineBuffer2[i]=ExtLineBuffer7[i]=(high+low)/2.0;
         //--- senkou span a
         ExtLineBuffer3[i]=(ExtLineBuffer1[i]+ExtLineBuffer2[i])/2.0;
         //--- senkou span b
         high=High[ArrayMaximum(High,i,InpSenkou)];
         low=Low[ArrayMinimum(Low,i,InpSenkou)];
         ExtLineBuffer4[i]=(high+low)/2.0;
         if(ExtLineBuffer2[i]<ExtLineBuffer1[i]) ExtLineBuffer8[i]=1;
         else ExtLineBuffer8[i]=0;
        }
     }
   return(rates_total);
  }
//+------------------------------------------------------------------+
//| CountLine                                                        |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      IndHandle,       //   
                    uint     BuffNumb,        //    
                    double&  IndBuf[],        //   
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total)//       
  {
//---
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---      
      IndBuf[bar]=0.0;
      //---       IndTime
      if(CopyTime(Symbol_,TimeFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      //---
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double Arr[1];
         //---       Arr
         if(CopyBuffer(IndHandle,BuffNumb,iTime[bar],1,Arr)<=0) return(RESET);
         IndBuf[bar]=Arr[0];
        }
      else IndBuf[bar]=IndBuf[bar+1];
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+
