//+------------------------------------------------------------------+
//|                                                HLR_Histogram.mq5 |
//|                                      Copyright  2007, Alexandre |
//|                      http://www.kroufr.ru/content/view/1184/124/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Alexandre"
#property link      "http://www.kroufr.ru/content/view/1184/124/"
#property description "Hi-Lo Range Oscillator"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window 
//----    3
#property indicator_buffers 3 
//----    
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_COLOR_HISTOGRAM2
//----     
#property indicator_color1  clrLime,clrDarkTurquoise,clrMediumPurple,clrDarkOrange,clrMagenta
//----   - 
#property indicator_style1 STYLE_SOLID
//----     2
#property indicator_width1 2
//----   
#property indicator_label1  "Hi-Lo Range Oscillator"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0   //        
#define MIDLLE 50 //     
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint HLR_Range=40;         //   
input uint HighLevel=80;         //  
input uint LowLevel=20;          //  
input int  Shift=0;              //      
//+----------------------------------------------+
//----   ,    
//      
double UpBuffer[],DnBuffer[],ColorBuffer[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| HLR indicator initialization function                            | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=int(HLR_Range+1);
//----      
   SetIndexBuffer(0,UpBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       InpKijun
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       
   ArraySetAsSeries(UpBuffer,true);
//----      
   SetIndexBuffer(1,DnBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(DnBuffer,true);
//----     ,     
   SetIndexBuffer(2,ColorBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorBuffer,true);
//----      
   string shortname;
   StringConcatenate(shortname,"Hi-Lo Range Oscillator Histogram(",HLR_Range,", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----      3   
   IndicatorSetInteger(INDICATOR_LEVELS,3);
//----       
   IndicatorSetDouble(INDICATOR_LEVELVALUE,0,HighLevel);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,1,MIDLLE);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,2,LowLevel);
//----       
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,clrBlue);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,clrGray);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,2,clrMagenta);
//----       -  
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,2,STYLE_DASHDOTDOT);
//----  
  }
//+------------------------------------------------------------------+ 
//| HLR iteration function                                           | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
//----       
   double m_pr,HH,LL,HL,res;
//----        
   int limit,bar,trend;
   static int trend_prev;
//----      
//  limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      trend_prev=0;
     }
   else limit=rates_total-prev_calculated; //      
//----    ,     
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
//----   
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      HH=high[ArrayMaximum(high,bar,HLR_Range)];
      LL=low [ArrayMinimum(low, bar,HLR_Range)];
      m_pr=(high[bar]+low[bar])/2.0;
      HL=HH-LL;
      if(HL) res=100.0*(m_pr-LL)/(HL);
      else res=MIDLLE;
      UpBuffer[bar]=res;
      DnBuffer[bar]=MIDLLE;
      int clr=2;
      trend=trend_prev;
      if(res>HighLevel)
        {
         if(trend_prev<0) clr=0;
         else clr=1;
         trend=+1;
        }
      else if(res<LowLevel)
        {
         if(trend_prev>0) clr=4;
         else clr=3;
         trend=-1;
        }
      ColorBuffer[bar]=clr;
      if(bar && trend) trend_prev=trend;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
