//+------------------------------------------------------------------+
//|                                                      GFilter.mq5 |
//|                                         Copyright  2012, zzuegg | 
//|                                http://when-money-makes-money.com | 
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2012, zzuegg"
//----    
#property link      "http://when-money-makes-money.com"
//----   
#property version   "1.00"
#property description "This indicator calculates a filterline with the use of gaussian filtration"
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 4
//----    
#property indicator_plots   3
//+----------------------------------------------+
//|     GFilter           |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_COLOR_LINE
//----      
#property indicator_color1  clrTeal,clrCrimson
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  3
#property indicator_width1  3
//----    
#property indicator_label1  "GFilter"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_ARROW
//----        
#property indicator_color2  clrMagenta
//----    2  3
#property indicator_width2  3
//----    
#property indicator_label2  "Dn_Signal"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_ARROW
//----        
#property indicator_color3  clrLime
//----    3  3
#property indicator_width3  3
//----    
#property indicator_label3  "Up_Signal"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define pi 3.1415926535
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_      // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint FilterPeriod=12;            //  
input Applied_price_ IPC=PRICE_CLOSE_; //  
input int Shift=0;                     //      
input int PriceShift=0;                //      
//+----------------------------------------------+
//----   ,    
//      
double IndBuffer[];
double ColorIndBuffer[];
double BearsBuffer[];
double BullsBuffer[];

double fil_alfa;
//----      
double dPriceShift;
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double getAlfa(int p)
  {
//----
   double w=2*pi/p;
   double beta=(1-MathCos(w))/(MathPow(1.414,2.0/3)-1);
   double alfa=-beta+MathSqrt(beta*beta+2*beta);
//----
   return (alfa);
  }
//+------------------------------------------------------------------+
//| GSMOOTH                                                          |
//+------------------------------------------------------------------+
double GSMOOTH(double price,double &arr[],double alfa,int index)
  {
//----
   double ret=MathPow(alfa,4)*price+4*(1-alfa)*arr[index-1]-6*MathPow(1-alfa,2)*arr[index-2]+4*MathPow(1-alfa,3)*arr[index-3]-MathPow(1-alfa,4)*arr[index-4];
//----
   return (ret);
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=int(FilterPeriod+4);
//----    
   dPriceShift=_Point*PriceShift;
//----    
   fil_alfa=getAlfa(FilterPeriod);

//----    IndBuffer   
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----    ColorIndBuffer   
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_DATA);
//----    BearsBuffer   
   SetIndexBuffer(2,BearsBuffer,INDICATOR_DATA);
//----    BullsBuffer   
   SetIndexBuffer(3,BullsBuffer,INDICATOR_DATA);

//----    1    shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,FilterPeriod);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);

//----    2    shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,FilterPeriod);
//----    
   PlotIndexSetInteger(1,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);

//----    3    shift
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----       3
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,FilterPeriod);
//----    
   PlotIndexSetInteger(2,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);

//----      
   string shortname;
   StringConcatenate(shortname,"GFilter( ",FilterPeriod," )");
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----    
   int first,bar;
   double series,s1,s2;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=int(FilterPeriod)-1; //      
      IndBuffer[first-1]=PriceSeries(IPC,first-1,open,low,high,close);
      IndBuffer[first-2]=PriceSeries(IPC,first-2,open,low,high,close);
      IndBuffer[first-3]=PriceSeries(IPC,first-3,open,low,high,close);
      IndBuffer[first-4]=PriceSeries(IPC,first-4,open,low,high,close);
     }
   else
     {
      first=prev_calculated-1; //      
     }
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      BullsBuffer[bar]=0.0;
      BearsBuffer[bar]=0.0;
      //----    PriceSeries     Series
      series=PriceSeries(IPC,bar,open,low,high,close);
      IndBuffer[bar]=GSMOOTH(series,IndBuffer,fil_alfa,bar);
     }
   if(prev_calculated>rates_total || prev_calculated<=0) first++;
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      if(IndBuffer[bar]<IndBuffer[bar-1]) ColorIndBuffer[bar]=1;
      else ColorIndBuffer[bar]=0;
     }
   if(prev_calculated>rates_total || prev_calculated<=0) first++;
//----      
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      s2=IndBuffer[bar-2]-IndBuffer[bar-1];
      s1=IndBuffer[bar-1]-IndBuffer[bar];
      //----
      if(s1<s2) BullsBuffer[bar]=IndBuffer[bar];
      if(s1>s2) BearsBuffer[bar]=IndBuffer[bar];
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+   
//|                                 |
//+------------------------------------------------------------------+ 
double PriceSeries(uint applied_price,//  
                   uint   bar,//            ).
                   const double &Open[],
                   const double &Low[],
                   const double &High[],
                   const double &Close[])
  {
//----
   switch(applied_price)
     {
      //----     ENUM_APPLIED_PRICE
      case  PRICE_CLOSE: return(Close[bar]);
      case  PRICE_OPEN: return(Open [bar]);
      case  PRICE_HIGH: return(High [bar]);
      case  PRICE_LOW: return(Low[bar]);
      case  PRICE_MEDIAN: return((High[bar]+Low[bar])/2.0);
      case  PRICE_TYPICAL: return((Close[bar]+High[bar]+Low[bar])/3.0);
      case  PRICE_WEIGHTED: return((2*Close[bar]+High[bar]+Low[bar])/4.0);
      //----                            
      case  8: return((Open[bar] + Close[bar])/2.0);
      case  9: return((Open[bar] + Close[bar] + High[bar] + Low[bar])/4.0);
      //----                                
      case 10:
        {
         if(Close[bar]>Open[bar])return(High[bar]);
         else
           {
            if(Close[bar]<Open[bar])
               return(Low[bar]);
            else return(Close[bar]);
           }
        }
      //----         
      case 11:
        {
         if(Close[bar]>Open[bar])return((High[bar]+Close[bar])/2.0);
         else
           {
            if(Close[bar]<Open[bar])
               return((Low[bar]+Close[bar])/2.0);
            else return(Close[bar]);
           }
         break;
        }
      //----
      case 12:
        {
         double res=High[bar]+Low[bar]+Close[bar];
         //----
         if(Close[bar]<Open[bar]) res=(res+Low[bar])/2;
         if(Close[bar]>Open[bar]) res=(res+High[bar])/2;
         if(Close[bar]==Open[bar]) res=(res+Close[bar])/2;
         return(((res-Low[bar])+(res-High[bar]))/2);
        }
      //----
      default: return(Close[bar]);
     }
//----
//return(0);
  }
//+------------------------------------------------------------------+
