//+---------------------------------------------------------------------+
//|                                                           d_XMA.mq5 | 
//|                                  Copyright  2011,   | 
//|                                                      dmitriy62@i.ua | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2011,  "
#property link "dmitriy62@i.ua"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       DodgerBlue 
#property indicator_color1 clrDodgerBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "d_XMA"
//+----------------------------------------------+
//|   CXMA                         |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_      // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum SmoothMethod -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method XMA_Method=MODE_SMA; // 
input uint XLength=80;                   // 
input int XPhase=15;                     // 
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE;    // 
input int Shift=0;                       //     
input int PriceShift=0;                  //     
uint Len=3;                              // 
//+----------------------------------------------+
//----   ,    
//      
double IndBuffer[];
//----      
double dPriceShift;
//----      
int min_rates_total,resl;
//----   ,    
//      
int Count[];
double d_XMA[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
//----
   int numb,Max1,Max2;
   static int count=1;
//----
   Max2=Size;
   Max1=Max2-1;
//----
   count--;
   if(count<0) count=Max1;
//----
   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//----
  }
//+------------------------------------------------------------------+   
//| d_XMA indicator initialization function                          | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=GetStartBars(XMA_Method,XLength,XPhase);
   resl=int(XLength-3);
//----       
   XMA1.XMALengthCheck("XLength",XLength);
   XMA1.XMAPhaseCheck("XPhase",XPhase,XMA_Method);
//----    
   dPriceShift=_Point*PriceShift;
//----       
   ArrayResize(Count,Len);
   ArrayResize(d_XMA,Len);
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(XMA_Method);
   StringConcatenate(shortname,"d_XMA(",XLength,", ",Smooth1,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+ 
//| d_XMA iteration function                                         | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----       
   double price,price1,price2,x1xma=0.0,ma1,ma2;
//----        
   int first,bar,p_ma;
   static int p_ma1;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=int(XLength)+resl; //      
      ArrayInitialize(Count,0);
      ArrayInitialize(d_XMA,0.0);
      p_ma1=int(XLength);
     }
   else first=prev_calculated-1; //      
   p_ma=p_ma1;
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      for(int iii=p_ma+resl; iii>=0; iii--)
        {
         price=PriceSeries(IPC,bar-iii,open,low,high,close);
         x1xma=XMA1.XMASeries(bar-p_ma-resl,prev_calculated,rates_total,XMA_Method,XPhase,p_ma,price,bar-iii,false);
        }
      d_XMA[Count[0]]=x1xma;
      price1=PriceSeries(IPC,bar-1,open,low,high,close);
      price2=PriceSeries(IPC,bar-2,open,low,high,close);
      ma1=d_XMA[Count[1]];
      ma2=d_XMA[Count[2]];
      //----
      if((price1>price2 && price1-ma1>price2-ma2) || (price1<price2 && price1-ma1<price2-ma2))
        {
         p_ma--;
         p_ma=MathMax(2,p_ma);
        }
      //----
      if((price1>ma1 && price2<ma2) || (price1<ma1 && price2>ma2)) p_ma=int(XLength);
      //----       
      IndBuffer[bar]=x1xma+dPriceShift;
      if(bar<rates_total-1)
        {
         Recount_ArrayZeroPos(Count,Len);
         p_ma1=p_ma;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
