//+------------------------------------------------------------------+ 
//|                                                 ReversalNavi.mq5 | 
//|                                         Copyright  2015, fxborg | 
//|                                  http://blog.livedoor.jp/fxborg/ | 
//+------------------------------------------------------------------+ 
//----  
#property copyright "Copyright  2015, fxborg"
//----  
#property link      "http://blog.livedoor.jp/fxborg/"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 8
//----    
#property indicator_plots   6
//+----------------------------------------------+
//|     1  |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---        Red 
#property indicator_color1  clrRed
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "Sell Reversal Bar Mark"
//+----------------------------------------------+
//|     1     |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---        DodgerBlue 
#property indicator_color2  clrDodgerBlue
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "Buy Reversal Bar Mark"
//+----------------------------------------------+
//|     2  |
//+----------------------------------------------+
//---   3   
#property indicator_type3   DRAW_ARROW
//---        Red 
#property indicator_color3  clrRed
//---    3  4
#property indicator_width3  4
//---    
#property indicator_label3  "Sell Reversal Bar"
//+----------------------------------------------+
//|     2     |
//+----------------------------------------------+
//---   4   
#property indicator_type4   DRAW_ARROW
//---        DodgerBlue 
#property indicator_color4  clrDodgerBlue
//---    4  4
#property indicator_width4  4
//---    
#property indicator_label4 "Buy Reversal Bar"
//+----------------------------------------------+
//|     3  |
//+----------------------------------------------+
//----     
#property indicator_type5   DRAW_LINE
//----       Red 
#property indicator_color5 clrRed
//----   -  
#property indicator_style5  STYLE_SOLID
//----     2
#property indicator_width5  2
//----   
#property indicator_label5  "Sell Reversal Bar Line"
//+----------------------------------------------+
//|     3     |
//+----------------------------------------------+
//----     
#property indicator_type6   DRAW_LINE
//----       DodgerBlue 
#property indicator_color6 clrDodgerBlue
//----   -  
#property indicator_style6  STYLE_SOLID
//----     2
#property indicator_width6  2
//----   
#property indicator_label6  "Buy Reversal Bar Line"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0       //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int InpHiLoPeriod=8; // High Low Period
input int InpStanbyBars=8; // Stanby Bars
int CalcBarCount=4;        // Calc Bar Count
input int Shift=0;         //       
//+----------------------------------------------+
//----   ,    
//----      
double ExtTopBuffer[];
double ExtBtmBuffer[];
double ExtSellStandbyBuffer[];
double ExtBuyStandbyBuffer[];
double ExtSellLineBuffer[];
double ExtBuyLineBuffer[];
//---- for calc 
double ExtHighesBuffer[];
double ExtLowesBuffer[];
//----      
int ATR_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   int ATR_Period=10;
   min_rates_total=int(MathMax(InpHiLoPeriod+InpStanbyBars+CalcBarCount,ATR_Period));

//----    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,ExtTopBuffer,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,218);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);

//----      
   SetIndexBuffer(1,ExtBtmBuffer,INDICATOR_DATA);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(1,PLOT_ARROW,217);
//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);

//----      
   SetIndexBuffer(2,ExtSellStandbyBuffer,INDICATOR_DATA);
//----       3
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(2,PLOT_ARROW,159);
//----    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);

//----      
   SetIndexBuffer(3,ExtBuyStandbyBuffer,INDICATOR_DATA);
//----       4
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(3,PLOT_ARROW,159);
//----    4  
   PlotIndexSetInteger(3,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,0.0);

//----      
   SetIndexBuffer(4,ExtSellLineBuffer,INDICATOR_DATA);
//----       5
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,min_rates_total);
//----    1  
   PlotIndexSetInteger(4,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,0.0);

//----      
   SetIndexBuffer(5,ExtBuyLineBuffer,INDICATOR_DATA);
//----       6
   PlotIndexSetInteger(5,PLOT_DRAW_BEGIN,min_rates_total);
//----    1  
   PlotIndexSetInteger(5,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetDouble(5,PLOT_EMPTY_VALUE,0.0);

//----      
   SetIndexBuffer(6,ExtHighesBuffer,INDICATOR_CALCULATIONS);
//----      
   SetIndexBuffer(7,ExtLowesBuffer,INDICATOR_CALCULATIONS);

//----      
   string shortname;
   StringConcatenate(shortname,"ReversalNavi(",InpHiLoPeriod,", ",InpStanbyBars,", ",Shift,")");
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----    
   int first,bar;
   double dmin,dmax,entry_point,range_lo,range_hi,ATR[1];
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=min_rates_total;                   //      
     }
   else first=prev_calculated-1; //      
//----
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //--- calculate range spread
      dmin=1000000.0;
      dmax=-1000000.0;
      for(int iii=bar-int(InpHiLoPeriod)+1; iii<=bar; iii++)
        {
         if(dmin>low[iii]) dmin=low[iii];
         if(dmax<high[iii]) dmax=high[iii];
        }
      ExtLowesBuffer[bar]=dmin;
      ExtHighesBuffer[bar]=dmax;
      ExtBuyStandbyBuffer[bar]=NULL;
      ExtSellStandbyBuffer[bar]=NULL;
      ExtBuyLineBuffer[bar]=NULL;
      ExtSellLineBuffer[bar]=NULL;
      ExtTopBuffer[bar]=NULL;
      ExtBtmBuffer[bar]=NULL;
     }
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //--- buy
      int btm_pos=bar-1;
      for(int iii=bar-1; iii>1; iii--)
        {
         if(ExtLowesBuffer[iii-2]>ExtLowesBuffer[iii-1] && ExtLowesBuffer[iii-1]==ExtLowesBuffer[iii])
           {
            btm_pos=iii-1;
            break;
           }
        }
      int setup=NULL;
      for(int iii=btm_pos; iii<=bar-1; iii++)
        {
         if(ExtBuyStandbyBuffer[iii])
           {
            setup=iii;
            break;
           }
        }
      //--- entry line
      entry_point=NULL;
      range_lo=1000000.0;
      range_hi=-1000000.0;
      if(!setup || bar-setup<=int(InpStanbyBars))
        {
         for(int iii=btm_pos; iii<=bar-1; iii++)
           {
            if(range_hi<high[iii])range_hi=high[iii];
            if(range_lo>low[iii])range_lo=low[iii];
           }
         //---
         entry_point=(range_hi+range_lo)/2;
         ExtBuyLineBuffer[bar]=entry_point;
        }
      //---
      if(MathMin(low[bar-4],MathMin(low[bar-3],low[bar-2]))<low[bar-1])
        {
         if(!setup)
           {
            //----      
            if(CopyBuffer(ATR_Handle,0,time[btm_pos],1,ATR)<=0) return(RESET);
            ExtBtmBuffer[btm_pos]=low[btm_pos]-MathMax(ATR[0]*3/8,5*_Point);
            ExtBuyStandbyBuffer[bar]=entry_point;
           }
         //else ExtBtmBuffer[btm_pos]=NULL;
        }
      //--- sell
      int top_pos=bar-1;
      for(int iii=bar-1; iii>1; iii--)
        {
         if(ExtHighesBuffer[iii-2]<ExtHighesBuffer[iii-1] && ExtHighesBuffer[iii-1]==ExtHighesBuffer[iii])
           {
            top_pos=iii-1;
            break;
           }
        }
      setup=NULL;
      for(int iii=top_pos; iii<=bar-1; iii++)
        {
         if(ExtSellStandbyBuffer[iii])
           {
            setup=iii;
            break;
           }
        }
      //----
      entry_point=NULL;
      range_lo=1000000.0;
      range_hi=-1000000.0;
      //----
      if(!setup || (bar-setup)<=int(InpStanbyBars))
        {
         //---
         for(int iii=top_pos; iii<=bar-1; iii++)
           {
            if(range_hi<high[iii]) range_hi=high[iii];
            if(range_lo>low[iii]) range_lo=low[iii];
           }
         entry_point=(range_hi+range_lo)/2;
         ExtSellLineBuffer[bar]=entry_point;
        }
      if(MathMax(high[bar-4],MathMax(high[bar-3],high[bar-2]))>high[bar-1])
        {
         if(!setup)
           {
            //----      
            if(CopyBuffer(ATR_Handle,0,time[top_pos],1,ATR)<=0) return(RESET);
            ExtTopBuffer[top_pos]=high[top_pos]+MathMax(ATR[0]*3/8,5*_Point);
            ExtSellStandbyBuffer[bar]=entry_point;
           }
         // else ExtTopBuffer[top_pos]=NULL;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
