//+---------------------------------------------------------------------+
//|                                                     XEnvelopes3.mq5 |
//|                                  Copyright  2016, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
#property description ""
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----    10
#property indicator_buffers 10 
//----     
#property indicator_plots   5
//+----------------------------------------------+
//|                      |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_FILLING
//----     
#property indicator_color1  clrLightSkyBlue
//----   
#property indicator_label1  "Upper XEnvelopes3 Cloud"
//+----------------------------------------------+
//|                      |
//+----------------------------------------------+
//----      
#property indicator_type2   DRAW_FILLING
//----     
#property indicator_color2  clrPaleGreen
//----   
#property indicator_label2  "Upper XEnvelopes2 Cloud"
//+----------------------------------------------+
//|                      |
//+----------------------------------------------+
//----      
#property indicator_type3   DRAW_FILLING
//----     
#property indicator_color3  clrLavender
//----   
#property indicator_label3  "XEnvelopes1 Cloud"
//+----------------------------------------------+
//|                      |
//+----------------------------------------------+
//----      
#property indicator_type4   DRAW_FILLING
//----     
#property indicator_color4  clrPink
//----   
#property indicator_label4  "Lower XEnvelopes2 Cloud"
//+----------------------------------------------+
//|                      |
//+----------------------------------------------+
//----      
#property indicator_type5   DRAW_FILLING
//----     
#property indicator_color5  clrViolet
//----   
#property indicator_label5  "Lower XEnvelopes3 Cloud"
//+----------------------------------------------+
//|   CXMA                         |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_      // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum SmoothMethod -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method XMA_Method=MODE_SMA; //  
input uint XLength=12;                   //  
input int XPhase=15;                     //  
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE;     //  
input double Deviation1=0.1;              //  1
input double Deviation2=0.3;              //  2
input double Deviation3=0.6;              //  3
input int Shift=0;                        //      
input int PriceShift=0;                   //      
//+----------------------------------------------+
//----   ,    
//----      
double UpBuffer1[],DnBuffer1[],UpBuffer2[],DnBuffer2[],UpBuffer3[],DnBuffer3[],UpBuffer4[],DnBuffer4[],UpBuffer5[],DnBuffer5[];
//----         
double dPriceShift,UpKdev1,DnKdev1,UpKdev2,DnKdev2,UpKdev3,DnKdev3;
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----     
   min_rates_total=XMA1.GetStartBars(XMA_Method,XLength,XPhase);
//----       
   XMA1.XMALengthCheck("XLength",XLength);
   XMA1.XMAPhaseCheck("XPhase",XPhase,XMA_Method);
//----    
   dPriceShift=_Point*PriceShift;
//----   
   if(Deviation1>=Deviation2)
     {
      Print("   2        1!      !");
      return(INIT_FAILED);
     }
   if(Deviation2>=Deviation3)
     {
      Print("   3        2!      !");
      return(INIT_FAILED);
     }
//----     
   UpKdev1=(1+Deviation1/100.0);
   DnKdev1=(1-Deviation1/100.0);
   UpKdev2=(1+Deviation2/100.0);
   DnKdev2=(1-Deviation2/100.0);
   UpKdev3=(1+Deviation3/100.0);
   DnKdev3=(1-Deviation3/100.0);
//----      
   SetIndexBuffer(0,UpBuffer4,INDICATOR_DATA);
   SetIndexBuffer(1,DnBuffer4,INDICATOR_DATA);
   SetIndexBuffer(2,UpBuffer2,INDICATOR_DATA);
   SetIndexBuffer(3,DnBuffer2,INDICATOR_DATA);
   SetIndexBuffer(4,UpBuffer1,INDICATOR_DATA);
   SetIndexBuffer(5,DnBuffer1,INDICATOR_DATA);
   SetIndexBuffer(6,UpBuffer3,INDICATOR_DATA);
   SetIndexBuffer(7,DnBuffer3,INDICATOR_DATA);
   SetIndexBuffer(8,UpBuffer5,INDICATOR_DATA);
   SetIndexBuffer(9,DnBuffer5,INDICATOR_DATA);
//----     
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
   PlotIndexSetInteger(3,PLOT_SHIFT,Shift);
   PlotIndexSetInteger(4,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,min_rates_total);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"Env("+string(XLength)+")");
   PlotIndexSetString(0,PLOT_LABEL,"Env("+string(XLength)+")Upper Cloud3");
   PlotIndexSetString(1,PLOT_LABEL,"Env("+string(XLength)+")Upper Cloud2");
   PlotIndexSetString(2,PLOT_LABEL,"Env("+string(XLength)+")Cloud1");
   PlotIndexSetString(3,PLOT_LABEL,"Env("+string(XLength)+")Lower Cloud2");
   PlotIndexSetString(4,PLOT_LABEL,"Env("+string(XLength)+")Lower Cloud3");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----       
   double price,xma;
//----        
   int first,bar;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=0; //      
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      price=PriceSeries(IPC,bar,open,low,high,close);
      xma=XMA1.XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,XLength,price,bar,false);
      UpBuffer4[bar]=UpKdev3*xma+dPriceShift;
      UpBuffer1[bar]=DnBuffer2[bar]=UpKdev1*xma+dPriceShift;
      DnBuffer1[bar]=UpBuffer3[bar]=DnKdev1*xma+dPriceShift;
      //----
      UpBuffer2[bar]=DnBuffer4[bar]=UpKdev2*xma+dPriceShift;
      DnBuffer3[bar]=UpBuffer5[bar]=DnKdev2*xma+dPriceShift;
      DnBuffer5[bar]=DnKdev3*xma+dPriceShift;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
