//+------------------------------------------------------------------+
//|                                    AlphaTrendSpotter-pa_free.mq5 |               
//|             Copyright  2015, Andy Ismail - All rights reserved! |
//|                                            http://fbsbroker.com/ |
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright  2015, Andy Ismail"
//---    
#property link      "http://fbsbroker.com"
//---   
#property version   "1.00"
#property description   "Alpha Trend Spotter Price Action"
#property description   "Suplement for Alpha Trend Spotter Indicator"
#property description   "Suitable for 5M to above timeframe"
#property description   "Suitable for 5 minutes Binary Option"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---     
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---         
#property indicator_color1  clrPink
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "AlphaTrendSpotter-pa_free Sell"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---         
#property indicator_color2  clrLime
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "AlphaTrendSpotter-pa_free Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint iPeriod=3;
//+----------------------------------------------+
//---   ,   
//---      
double SellBuffer[];
double BuyBuffer[];
//---
int ATR_Handle,min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---    
   int ATR_Period=15;
   min_rates_total=int(iPeriod+iPeriod);
   min_rates_total=int(MathMax(min_rates_total,ATR_Period))+1;
//---    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(0,PLOT_ARROW,234);
//---       
   ArraySetAsSeries(SellBuffer,true);
//---      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,233);
//---       
   ArraySetAsSeries(BuyBuffer,true);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---         
   string short_name="AlphaTrendSpotter-pa_free";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//---   
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//---    
   int to_copy,limit,bar;
   double ATR[],CandleOpen,CandleOpen1,CandleHigh,CandleHigh1,CandleLow,CandleLow1;
//---      
//---   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
   to_copy=limit+1;
//---       ATR[]
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
//---         
   ArraySetAsSeries(ATR,true);
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      CandleHigh=high[ArrayMaximum(high,bar,iPeriod)];
      CandleLow=low[ArrayMinimum(low,bar,iPeriod)];
      CandleOpen=open[bar];
      CandleHigh1=high[ArrayMaximum(high,bar+iPeriod,iPeriod)];
      CandleLow1=low[ArrayMinimum(low,bar+iPeriod,iPeriod)];
      CandleOpen1=open[bar+iPeriod];
      //---
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;
      //---
      if(CandleLow<CandleLow1  &&  CandleOpen>CandleHigh1) BuyBuffer[bar]=low[bar]-ATR[bar]*3/8;
      if(CandleHigh>CandleHigh1 && CandleOpen<CandleLow1) SellBuffer[bar]=high[bar]+ATR[bar]*3/8;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
